/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.webflux;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.EngineContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.spring5.context.webflux.ISpringWebFluxContext;
import org.thymeleaf.spring5.context.webflux.SpringWebFluxEngineContext;
import org.thymeleaf.util.Validate;

public class SpringWebFluxEngineContextFactory
implements IEngineContextFactory {
    public IEngineContext createEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        Validate.notNull((Object)context, (String)"Context object cannot be null");
        Set variableNames = context.getVariableNames();
        if (variableNames == null || variableNames.isEmpty()) {
            if (context instanceof ISpringWebFluxContext) {
                ISpringWebFluxContext srContext = (ISpringWebFluxContext)context;
                return new SpringWebFluxEngineContext(configuration, templateData, templateResolutionAttributes, srContext.getExchange(), srContext.getLocale(), Collections.EMPTY_MAP);
            }
            return new EngineContext(configuration, templateData, templateResolutionAttributes, context.getLocale(), Collections.EMPTY_MAP);
        }
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>(variableNames.size() + 1, 1.0f);
        for (String variableName : variableNames) {
            variables.put(variableName, context.getVariable(variableName));
        }
        if (context instanceof ISpringWebFluxContext) {
            ISpringWebFluxContext srContext = (ISpringWebFluxContext)context;
            return new SpringWebFluxEngineContext(configuration, templateData, templateResolutionAttributes, srContext.getExchange(), srContext.getLocale(), variables);
        }
        return new EngineContext(configuration, templateData, templateResolutionAttributes, context.getLocale(), variables);
    }
}

