/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeToken;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialValidator;
import org.apereo.cas.otp.web.flow.OneTimeTokenAccountSaveRegistrationAction;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GoogleAuthenticatorSaveRegistrationAction
extends OneTimeTokenAccountSaveRegistrationAction<GoogleAuthenticatorAccount> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorSaveRegistrationAction.class);
    public static final String REQUEST_PARAMETER_TOKEN = "token";
    private final OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator;

    public GoogleAuthenticatorSaveRegistrationAction(OneTimeTokenCredentialRepository repository, CasConfigurationProperties casProperties, OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator) {
        super(repository, casProperties);
        this.validator = validator;
    }

    protected boolean validate(GoogleAuthenticatorAccount account, RequestContext requestContext) {
        return (Boolean)FunctionUtils.doAndHandle(t -> {
            Integer token = requestContext.getRequestParameters().getRequiredInteger(REQUEST_PARAMETER_TOKEN);
            if (this.validator.isTokenAuthorizedFor(token.intValue(), (OneTimeTokenAccount)account)) {
                LOGGER.debug("Successfully validated token [{}]", (Object)token);
                GoogleAuthenticatorToken gtoken = new GoogleAuthenticatorToken(token, account.getUsername());
                this.validator.getTokenRepository().store((OneTimeToken)gtoken);
                return true;
            }
            return false;
        }, e -> false).apply(account);
    }

    protected Event getErrorEvent(RequestContext requestContext) {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        return this.error();
    }

    protected GoogleAuthenticatorAccount buildOneTimeTokenAccount(RequestContext requestContext) {
        OneTimeTokenAccount acct = super.buildOneTimeTokenAccount(requestContext);
        return GoogleAuthenticatorAccount.from((OneTimeTokenAccount)acct);
    }
}

