/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.GlobalConfiguration;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.DeactivateChangelogCommandStep;
import liquibase.command.core.InternalDropAllCommandStep;
import liquibase.command.core.InternalExecuteSqlCommandStep;
import liquibase.command.core.InternalHistoryCommandStep;
import liquibase.command.core.InternalSnapshotCommandStep;
import liquibase.command.core.InternalSyncHubCommandStep;
import liquibase.command.core.RegisterChangelogCommandStep;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.core.DeprecatedConfigurationValueProvider;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubServiceFactory;
import liquibase.integration.IntegrationDetails;
import liquibase.integration.commandline.ChangeExecListenerUtils;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.Location;
import liquibase.license.LocationType;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogMessageFilter;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.logging.core.JavaLogService;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.ui.ConsoleUIService;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;

public class Main {
    public static boolean runningFromNewCli;
    public static Map<String, String> newCliChangelogParameters;
    private static PrintStream outputStream;
    private static final String ERRORMSG_UNEXPECTED_PARAMETERS = "unexpected.command.parameters";
    private static final Logger LOG;
    private static ResourceBundle coreBundle;
    protected ClassLoader classLoader;
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String hubConnectionId;
    protected String hubProjectId;
    protected String hubProjectName;
    protected String databaseClass;
    protected String defaultSchemaName;
    protected String outputDefaultSchema;
    protected String outputDefaultCatalog;
    protected String liquibaseCatalogName;
    protected String liquibaseSchemaName;
    protected String databaseChangeLogTableName;
    protected String databaseChangeLogLockTableName;
    protected String databaseChangeLogTablespaceName;
    protected String defaultCatalogName;
    protected String changeLogFile;
    protected String overwriteOutputFile;
    protected String classpath;
    protected String contexts;
    protected String labels;
    protected String driverPropertiesFile;
    protected String propertyProviderClass;
    protected String changeExecListenerClass;
    protected String changeExecListenerPropertiesFile;
    protected Boolean promptForNonLocalDatabase;
    protected Boolean includeSystemClasspath;
    protected String defaultsFile = "liquibase.properties";
    protected String diffTypes;
    protected String changeSetAuthor;
    protected String changeSetContext;
    protected String dataOutputDirectory;
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String referenceDefaultCatalogName;
    protected String referenceDefaultSchemaName;
    protected String currentDateTimeFunction;
    protected String command;
    protected Set<String> commandParams = new LinkedHashSet<String>();
    protected String logLevel;
    protected String logFile;
    protected Map<String, Object> changeLogParameters = new HashMap<String, Object>();
    protected String outputFile;
    protected String excludeObjects;
    protected Boolean includeCatalog;
    protected String includeObjects;
    protected Boolean includeSchema;
    protected Boolean includeTablespace;
    protected Boolean deactivate;
    protected String outputSchemasAs;
    protected String referenceSchemas;
    protected String schemas;
    protected String snapshotFormat;
    protected String liquibaseProLicenseKey;
    private boolean liquibaseProLicenseValid = false;
    protected String liquibaseHubApiKey;
    protected String liquibaseHubUrl;
    private Boolean managingLogConfig = null;
    private boolean outputsLogMessages = false;
    protected String sqlFile;
    protected String delimiter;
    protected String rollbackScript;
    private static int[] suspiciousCodePoints;

    public static void main(String[] args) {
        int errorLevel = 0;
        try {
            errorLevel = Main.run(args);
        }
        catch (Throwable e2) {
            System.exit(-1);
        }
        System.exit(errorLevel);
    }

    public static int run(final String[] args) throws Exception {
        HashMap<String, Object> scopeObjects = new HashMap<String, Object>();
        IntegrationDetails integrationDetails = new IntegrationDetails();
        integrationDetails.setName("cli");
        ListIterator<String> argIterator = Arrays.asList(args).listIterator();
        while (argIterator.hasNext()) {
            String arg = argIterator.next();
            if (!arg.startsWith("--")) continue;
            if (arg.contains("=")) {
                String[] splitArg = arg.split("=", 2);
                String argKey = "argument__" + splitArg[0].replaceFirst("^--", "");
                if (splitArg.length == 2) {
                    integrationDetails.setParameter(argKey, splitArg[1]);
                    continue;
                }
                integrationDetails.setParameter(argKey, "true");
                continue;
            }
            String argKey = "argument__" + arg.replaceFirst("^--", "");
            if (argIterator.hasNext()) {
                String next = argIterator.next();
                if (next.startsWith("--") || Main.isCommand(next)) {
                    integrationDetails.setParameter(argKey, "true");
                    argIterator.previous();
                    continue;
                }
                integrationDetails.setParameter(argKey, next);
                continue;
            }
            integrationDetails.setParameter(argKey, "true");
        }
        scopeObjects.put("integrationDetails", integrationDetails);
        if (!runningFromNewCli) {
            ConsoleUIService ui = new ConsoleUIService();
            ui.setAllowPrompt(true);
            scopeObjects.put(Scope.Attr.ui.name(), ui);
        }
        return Scope.child(scopeObjects, new Scope.ScopedRunnerWithReturn<Integer>(){

            @Override
            public Integer run() throws Exception {
                Main main = new Main();
                try {
                    List<String> setupMessages;
                    LicenseService licenseService;
                    if (args.length == 0 || args.length == 1 && "--help".equals(args[0])) {
                        main.printHelp(outputStream);
                        return 0;
                    }
                    if ("--version".equals(args[0])) {
                        main.command = "";
                        main.parseDefaultPropertyFiles();
                        Scope.getCurrentScope().getUI().sendMessage(CommandLineUtils.getBanner());
                        Scope.getCurrentScope().getUI().sendMessage(String.format(coreBundle.getString("version.number"), LiquibaseUtil.getBuildVersionInfo()));
                        LicenseService licenseService2 = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService();
                        if (licenseService2 != null && main.liquibaseProLicenseKey != null) {
                            Location licenseKeyLocation = new Location("property liquibaseProLicenseKey", LocationType.BASE64_STRING, main.liquibaseProLicenseKey);
                            LicenseInstallResult result = licenseService2.installLicense(licenseKeyLocation);
                            if (result.code != 0) {
                                String allMessages = String.join((CharSequence)"\n", result.messages);
                                Scope.getCurrentScope().getUI().sendErrorMessage(allMessages);
                            }
                        }
                        if (licenseService2 != null) {
                            Scope.getCurrentScope().getUI().sendMessage(licenseService2.getLicenseInfo());
                        }
                        Scope.getCurrentScope().getUI().sendMessage(String.format("Running Java under %s (Version %s)", System.getProperties().getProperty("java.home"), System.getProperty("java.version")));
                        return 0;
                    }
                    for (int i2 = 0; i2 < args.length; ++i2) {
                        CodePointCheck codePointCheck = Main.checkArg(args[i2]);
                        if (codePointCheck == null) continue;
                        String message = "A non-standard character '" + codePointCheck.ch + "' was detected on the command line at position " + (codePointCheck.position + 1) + " of argument number " + (i2 + 1) + ".\nIf problems occur, please remove the character and try again.";
                        LOG.warning(message);
                        System.err.println(message);
                    }
                    try {
                        main.parseOptions(args);
                        if (main.command == null) {
                            main.printHelp(outputStream);
                            return 0;
                        }
                    }
                    catch (CommandLineParsingException e2) {
                        Scope.getCurrentScope().getUI().sendMessage(CommandLineUtils.getBanner());
                        Scope.getCurrentScope().getUI().sendMessage(coreBundle.getString("how.to.display.help"));
                        throw e2;
                    }
                    if (!runningFromNewCli) {
                        ConsoleUIService ui = (ConsoleUIService)Scope.getCurrentScope().getUI();
                        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %4$s [%2$s] %5$s%6$s%n");
                        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
                        java.util.logging.Logger liquibaseLogger = java.util.logging.Logger.getLogger("liquibase");
                        liquibaseLogger.setParent(rootLogger);
                        JavaLogService logService = (JavaLogService)((Object)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class));
                        logService.setParent(liquibaseLogger);
                        if (main.logLevel == null) {
                            String defaultLogLevel = System.getProperty("liquibase.log.level");
                            if (defaultLogLevel == null) {
                                Main.setLogLevel(logService, rootLogger, liquibaseLogger, Level.OFF);
                            } else {
                                Main.setLogLevel(logService, rootLogger, liquibaseLogger, Main.parseLogLevel(defaultLogLevel, ui));
                            }
                        } else {
                            Main.setLogLevel(logService, rootLogger, liquibaseLogger, Main.parseLogLevel(main.logLevel, ui));
                        }
                        if (main.logFile != null) {
                            FileHandler fileHandler = new FileHandler(main.logFile, true);
                            fileHandler.setFormatter(new SimpleFormatter());
                            if (liquibaseLogger.getLevel() == Level.OFF) {
                                fileHandler.setLevel(Level.FINE);
                            }
                            rootLogger.addHandler(fileHandler);
                            for (Handler handler : rootLogger.getHandlers()) {
                                if (!(handler instanceof ConsoleHandler)) continue;
                                handler.setLevel(Level.OFF);
                            }
                        }
                        if (main.command != null && main.command.toLowerCase().endsWith("sql")) {
                            ui.setOutputStream(System.err);
                        }
                    }
                    if ((licenseService = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService()) != null) {
                        if (main.liquibaseProLicenseKey == null) {
                            if (!runningFromNewCli) {
                                Scope.getCurrentScope().getLog(this.getClass()).info("No Liquibase Pro license key supplied. Please set liquibaseProLicenseKey on command line or in liquibase.properties to use Liquibase Pro features.");
                            }
                        } else {
                            Location licenseKeyLocation = new Location("property liquibaseProLicenseKey", LocationType.BASE64_STRING, main.liquibaseProLicenseKey);
                            LicenseInstallResult result = licenseService.installLicense(licenseKeyLocation);
                            if (result.code != 0) {
                                String allMessages = String.join((CharSequence)"\n", result.messages);
                                if (!runningFromNewCli) {
                                    Scope.getCurrentScope().getUI().sendMessage(allMessages);
                                }
                            } else {
                                main.liquibaseProLicenseValid = true;
                            }
                        }
                        if (licenseService.daysTilExpiration() < 0) {
                            main.liquibaseProLicenseValid = false;
                        }
                        if (!runningFromNewCli) {
                            Scope.getCurrentScope().getUI().sendMessage(licenseService.getLicenseInfo());
                        }
                    }
                    if (!runningFromNewCli) {
                        Scope.getCurrentScope().getUI().sendMessage(CommandLineUtils.getBanner());
                    }
                    if (!LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentValue().booleanValue()) {
                        Scope.getCurrentScope().getUI().sendErrorMessage(String.format(coreBundle.getString("did.not.run.because.param.was.set.to.false"), LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentConfiguredValue().getProvidedValue().getActualKey()));
                        return 0;
                    }
                    if (Main.setupNeeded(main) && !(setupMessages = main.checkSetup()).isEmpty()) {
                        main.printHelp(setupMessages, Main.isStandardOutputRequired(main.command) ? System.err : outputStream);
                        return 1;
                    }
                    if (StringUtil.isNotEmpty(main.liquibaseHubApiKey)) {
                        DeprecatedConfigurationValueProvider.setData(HubConfiguration.LIQUIBASE_HUB_API_KEY, main.liquibaseHubApiKey);
                    }
                    if (StringUtil.isNotEmpty(main.liquibaseHubUrl)) {
                        DeprecatedConfigurationValueProvider.setData(HubConfiguration.LIQUIBASE_HUB_URL, main.liquibaseHubUrl);
                    }
                    main.applyDefaults();
                    HashMap<String, Object> innerScopeObjects = new HashMap<String, Object>();
                    innerScopeObjects.put("defaultsFile", LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentValue());
                    if (!runningFromNewCli) {
                        innerScopeObjects.put(Scope.Attr.resourceAccessor.name(), new ClassLoaderResourceAccessor(main.configureClassLoader()));
                    }
                    Scope.child(innerScopeObjects, () -> {
                        main.doMigration();
                        if (!runningFromNewCli) {
                            if ("update".equals(main.command)) {
                                Scope.getCurrentScope().getUI().sendMessage(coreBundle.getString("update.successful"));
                            } else if (main.command.startsWith("rollback")) {
                                Scope.getCurrentScope().getUI().sendMessage(coreBundle.getString("rollback.successful"));
                            } else {
                                Scope.getCurrentScope().getUI().sendMessage(String.format(coreBundle.getString("command.successful"), main.command));
                            }
                        }
                    });
                }
                catch (Throwable e3) {
                    String message = e3.getMessage();
                    if (e3.getCause() != null) {
                        message = e3.getCause().getMessage();
                    }
                    if (message == null) {
                        message = coreBundle.getString("unknown.reason");
                    }
                    try {
                        if (e3.getCause() instanceof ValidationFailedException) {
                            ((ValidationFailedException)e3.getCause()).printDescriptiveError(outputStream);
                        } else if (!runningFromNewCli) {
                            if (main.outputsLogMessages) {
                                Scope.getCurrentScope().getUI().sendErrorMessage(String.format(coreBundle.getString("unexpected.error"), message), e3);
                            } else {
                                Scope.getCurrentScope().getUI().sendMessage(String.format(coreBundle.getString("unexpected.error"), message));
                                Scope.getCurrentScope().getUI().sendMessage(coreBundle.getString("for.more.information.use.loglevel.flag"));
                                Scope.getCurrentScope().getLog(this.getClass()).severe(String.format(coreBundle.getString("unexpected.error"), message), e3);
                            }
                        }
                    }
                    catch (IllegalFormatException e1) {
                        if (runningFromNewCli) {
                            throw e1;
                        }
                        e1.printStackTrace();
                    }
                    throw new LiquibaseException(String.format(coreBundle.getString("unexpected.error"), message), e3);
                }
                if (Main.isHubEnabled(main.command) && HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue() != null && !Scope.getCurrentScope().getSingleton(HubServiceFactory.class).isOnline()) {
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: The command " + main.command + " operations were not synced with your Liquibase Hub account because: " + StringUtil.lowerCaseFirst(Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getOfflineReason()));
                }
                return 0;
            }
        });
    }

    private static boolean setupNeeded(Main main) throws CommandLineParsingException {
        if (main.command.toLowerCase().startsWith("registerChangeLog".toLowerCase()) || main.command.toLowerCase().startsWith("deactivateChangeLog".toLowerCase())) {
            return false;
        }
        if (!main.commandParams.contains("--help")) {
            return true;
        }
        return !main.command.toLowerCase().startsWith("rollbackOneChangeSet".toLowerCase()) && !main.command.toLowerCase().startsWith("rollbackOneUpdate".toLowerCase()) && (!main.command.toLowerCase().startsWith("diff".toLowerCase()) || !main.isFormattedDiff());
    }

    protected static void setLogLevel(LogService logService, java.util.logging.Logger rootLogger, java.util.logging.Logger liquibaseLogger, Level level) {
        if (runningFromNewCli) {
            return;
        }
        if (level.intValue() < Level.INFO.intValue()) {
            rootLogger.setLevel(Level.INFO);
        } else {
            rootLogger.setLevel(level);
        }
        liquibaseLogger.setLevel(level);
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(level);
            handler.setFilter(new SecureLogFilter(logService.getFilter()));
        }
        if (level != Level.OFF) {
            DeprecatedConfigurationValueProvider.setData(HubConfiguration.LIQUIBASE_HUB_LOGLEVEL, level);
        }
    }

    private static Level parseLogLevel(String logLevelName, ConsoleUIService ui) {
        Level logLevel;
        if ((logLevelName = logLevelName.toUpperCase()).equals("DEBUG")) {
            logLevel = Level.FINE;
        } else if (logLevelName.equals("WARN")) {
            logLevel = Level.WARNING;
        } else if (logLevelName.equals("ERROR")) {
            logLevel = Level.SEVERE;
        } else {
            try {
                logLevel = Level.parse(logLevelName);
            }
            catch (IllegalArgumentException e2) {
                ui.sendErrorMessage("Unknown log level " + logLevelName);
                logLevel = Level.OFF;
            }
        }
        return logLevel;
    }

    private static String generateLogLevelWarningMessage(boolean outputLoggingEnabled) {
        if (outputLoggingEnabled) {
            return "";
        }
        return "\n\n" + coreBundle.getString("for.more.information.use.loglevel.flag");
    }

    private static String[] splitArg(String arg) throws CommandLineParsingException {
        String[] splitArg = arg.split("=", 2);
        if (splitArg.length < 2) {
            throw new CommandLineParsingException(String.format(coreBundle.getString("could.not.parse.expression"), arg));
        }
        splitArg[0] = splitArg[0].replaceFirst("--", "");
        return splitArg;
    }

    private static boolean isHubEnabled(String command) {
        return "changelogSyncSQL".equalsIgnoreCase(command) || "updateCount".equalsIgnoreCase(command) || "updateToTag".equalsIgnoreCase(command) || "update".equalsIgnoreCase(command) || "rollback".equalsIgnoreCase(command) || "rollbackToDate".equalsIgnoreCase(command) || "rollbackCount".equalsIgnoreCase(command) || "rollbackOneChangeSet".equalsIgnoreCase(command) || "rollbackOneUpdate".equalsIgnoreCase(command) || "dropAll".equalsIgnoreCase(command);
    }

    private static boolean isStandardOutputRequired(String command) {
        return "snapshot".equalsIgnoreCase(command) || "snapshotReference".equalsIgnoreCase(command) || "changelogSyncSQL".equalsIgnoreCase(command) || "changelogSyncToTagSQL".equalsIgnoreCase(command) || "markNextChangeSetRanSQL".equalsIgnoreCase(command) || "updateCountSQL".equalsIgnoreCase(command) || "updateToTagSQL".equalsIgnoreCase(command) || "updateSQL".equalsIgnoreCase(command) || "rollbackSQL".equalsIgnoreCase(command) || "rollbackToDateSQL".equalsIgnoreCase(command) || "rollbackCountSQL".equalsIgnoreCase(command) || "futureRollbackSQL".equalsIgnoreCase(command) || "futureRollbackCountSQL".equalsIgnoreCase(command) || "futureRollbackFromTagSQL".equalsIgnoreCase(command);
    }

    private static boolean isChangeLogRequired(String command) {
        return command.toLowerCase().startsWith("update") || command.toLowerCase().startsWith("rollback") && !command.equalsIgnoreCase("rollbackOneChangeSet") && !command.equalsIgnoreCase("rollbackOneUpdate") || "registerChangeLog".equalsIgnoreCase(command) || "deactivateChangeLog".equalsIgnoreCase(command) || "calculateCheckSum".equalsIgnoreCase(command) || "status".equalsIgnoreCase(command) || "validate".equalsIgnoreCase(command) || "changelogSync".equalsIgnoreCase(command) || "changelogSyncSQL".equalsIgnoreCase(command) || "changelogSyncToTag".equalsIgnoreCase(command) || "changelogSyncToTagSQL".equalsIgnoreCase(command) || "generateChangeLog".equalsIgnoreCase(command) || "unexpectedChangeSets".equalsIgnoreCase(command) || "diffChangeLog".equalsIgnoreCase(command) || "rollbackOneChangeSet".equalsIgnoreCase(command) || "rollbackOneUpdate".equalsIgnoreCase(command);
    }

    private static boolean isCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "updateCount".equalsIgnoreCase(arg) || "updateCountSQL".equalsIgnoreCase(arg) || "updateToTag".equalsIgnoreCase(arg) || "updateToTagSQL".equalsIgnoreCase(arg) || "rollback".equalsIgnoreCase(arg) || "rollbackToDate".equalsIgnoreCase(arg) || "rollbackCount".equalsIgnoreCase(arg) || "rollbackSQL".equalsIgnoreCase(arg) || "rollbackToDateSQL".equalsIgnoreCase(arg) || "rollbackCountSQL".equalsIgnoreCase(arg) || "registerChangeLog".equalsIgnoreCase(arg) || "deactivateChangeLog".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "futureRollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackFromTagSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "tag".equalsIgnoreCase(arg) || "tagExists".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "history".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "status".equalsIgnoreCase(arg) || "unexpectedChangeSets".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "diff".equalsIgnoreCase(arg) || "diffChangeLog".equalsIgnoreCase(arg) || "generateChangeLog".equalsIgnoreCase(arg) || "snapshot".equalsIgnoreCase(arg) || "snapshotReference".equalsIgnoreCase(arg) || "syncHub".equalsIgnoreCase(arg) || "executeSql".equalsIgnoreCase(arg) || "calculateCheckSum".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "dbDoc".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "changelogSyncToTag".equalsIgnoreCase(arg) || "changelogSyncToTagSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg) || "rollbackOneChangeSet".equalsIgnoreCase(arg) || "rollbackOneChangeSetSQL".equalsIgnoreCase(arg) || "rollbackOneUpdate".equalsIgnoreCase(arg) || "rollbackOneUpdateSQL".equalsIgnoreCase(arg);
    }

    private static boolean isNoArgCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg);
    }

    private static void addWarFileClasspathEntries(File classPathFile, List<URL> urls) throws IOException {
        URL jarUrl = new URL("jar:" + classPathFile.toURI().toURL() + "!/WEB-INF/classes/");
        LOG.info("adding '" + jarUrl + "' to classpath");
        urls.add(jarUrl);
        try (JarFile warZip = new JarFile(classPathFile);){
            Enumeration<JarEntry> entries = warZip.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("WEB-INF/lib") || !entry.getName().toLowerCase().endsWith(".jar")) continue;
                File jar = Main.extract(warZip, entry);
                URL newUrl = new URL("jar:" + jar.toURI().toURL() + "!/");
                LOG.info("adding '" + newUrl + "' to classpath");
                urls.add(newUrl);
                jar.deleteOnExit();
            }
        }
    }

    private static File extract(JarFile jar, JarEntry entry) throws IOException {
        File tempFile = File.createTempFile("liquibase.tmp", null);
        try (BufferedInputStream inStream = new BufferedInputStream(jar.getInputStream(entry));
             BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int status;
            while ((status = inStream.read()) != -1) {
                outStream.write(status);
            }
        }
        return tempFile;
    }

    protected void parseDefaultPropertyFiles() throws CommandLineParsingException {
        LinkedHashSet<File> potentialPropertyFiles = new LinkedHashSet<File>();
        potentialPropertyFiles.add(new File(this.defaultsFile));
        String localDefaultsPathName = this.defaultsFile.replaceFirst("(\\.[^\\.]+)$", ".local$1");
        potentialPropertyFiles.add(new File(localDefaultsPathName));
        ConfiguredValue<String> currentConfiguredValue = LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentConfiguredValue();
        if (currentConfiguredValue.found()) {
            potentialPropertyFiles.add(new File(currentConfiguredValue.getValue()));
        }
        for (File potentialPropertyFile : potentialPropertyFiles) {
            try {
                if (potentialPropertyFile.exists()) {
                    this.parseDefaultPropertyFileFromFile(potentialPropertyFile);
                    continue;
                }
                this.parseDefaultPropertyFileFromResource(potentialPropertyFile);
            }
            catch (IOException e2) {
                throw new CommandLineParsingException(e2);
            }
        }
    }

    private void parseDefaultPropertyFileFromResource(File potentialPropertyFile) throws IOException, CommandLineParsingException {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(potentialPropertyFile.getPath());){
            if (resourceAsStream != null) {
                this.parsePropertiesFile(resourceAsStream);
            }
        }
    }

    private void parseDefaultPropertyFileFromFile(File potentialPropertyFile) throws IOException, CommandLineParsingException {
        try (FileInputStream stream = new FileInputStream(potentialPropertyFile);){
            this.parsePropertiesFile(stream);
        }
    }

    protected String[] fixupArgs(String[] args) {
        ArrayList<String> fixedArgs = new ArrayList<String>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if ((arg.startsWith("--") || arg.startsWith("-D")) && !arg.contains("=")) {
                String nextArg = null;
                if (i2 + 1 < args.length) {
                    nextArg = args[i2 + 1];
                }
                if (nextArg != null && !nextArg.startsWith("--") && !Main.isCommand(nextArg)) {
                    arg = arg + "=" + nextArg;
                    ++i2;
                }
            }
            arg = arg.replace("\\,", ",");
            fixedArgs.add(arg);
        }
        return fixedArgs.toArray(new String[fixedArgs.size()]);
    }

    protected List<String> checkSetup() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.command == null) {
            messages.add(coreBundle.getString("command.not.passed"));
        } else if (!Main.isCommand(this.command)) {
            messages.add(String.format(coreBundle.getString("command.unknown"), this.command));
        } else {
            if (StringUtil.trimToNull(this.url) == null && StringUtil.trimToNull(this.referenceUrl) == null) {
                messages.add(String.format(coreBundle.getString("option.required"), "--url"));
            }
            if (Main.isChangeLogRequired(this.command) && StringUtil.trimToNull(this.changeLogFile) == null) {
                messages.add(String.format(coreBundle.getString("option.required"), "--changeLogFile"));
            }
            if (Main.isNoArgCommand(this.command) && !this.commandParams.isEmpty()) {
                messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
            } else {
                this.validateCommandParameters(messages);
            }
        }
        return messages;
    }

    private void checkForUnexpectedCommandParameter(List<String> messages) {
        block17: {
            block19: {
                block18: {
                    block16: {
                        if (!"updateCount".equalsIgnoreCase(this.command) && !"updateCountSQL".equalsIgnoreCase(this.command) && !"updateToTag".equalsIgnoreCase(this.command) && !"updateToTagSQL".equalsIgnoreCase(this.command) && !"calculateCheckSum".equalsIgnoreCase(this.command) && !"dbDoc".equalsIgnoreCase(this.command) && !"tag".equalsIgnoreCase(this.command) && !"tagExists".equalsIgnoreCase(this.command) && !"changelogSyncToTag".equalsIgnoreCase(this.command) && !"changelogSyncToTagSQL".equalsIgnoreCase(this.command)) break block16;
                        if (this.commandParams.isEmpty() || !this.commandParams.iterator().next().startsWith("-")) break block17;
                        messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
                        break block17;
                    }
                    if (!"status".equalsIgnoreCase(this.command) && !"unexpectedChangeSets".equalsIgnoreCase(this.command)) break block18;
                    if (this.commandParams.isEmpty() || this.commandParams.iterator().next().equalsIgnoreCase("--verbose")) break block17;
                    messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
                    break block17;
                }
                if (!"diff".equalsIgnoreCase(this.command) && !"diffChangeLog".equalsIgnoreCase(this.command)) break block19;
                if (this.commandParams.isEmpty()) break block17;
                for (String cmdParm : this.commandParams) {
                    String caseInsensitiveCommandParam = cmdParm.toLowerCase();
                    if (!(caseInsensitiveCommandParam.startsWith("--" + "referenceUsername".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "referencePassword".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "referenceDriver".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "referenceDefaultCatalogName".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "referenceDefaultSchemaName".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "includeSchema".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "includeCatalog".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "includeTablespace".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "schemas".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "outputSchemasAs".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "referenceSchemas".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "referenceUrl".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "excludeObjects".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "includeObjects".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "diffTypes".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "format".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "help".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "snapshotFormat".toLowerCase()))) {
                        messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                    }
                    if (!"diffChangeLog".equalsIgnoreCase(this.command) || !cmdParm.toLowerCase().startsWith("--" + "format".toLowerCase())) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
                break block17;
            }
            if (("snapshot".equalsIgnoreCase(this.command) || "generateChangeLog".equalsIgnoreCase(this.command)) && !this.commandParams.isEmpty()) {
                for (String cmdParm : this.commandParams) {
                    String caseInsensitiveCommandParam = cmdParm.toLowerCase();
                    if (caseInsensitiveCommandParam.startsWith("--" + "includeSchema".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "includeCatalog".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "includeTablespace".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "schemas".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "snapshotFormat".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "dataOutputDirectory".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "outputSchemasAs".toLowerCase())) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            } else if ("rollbackOneChangeSet".equalsIgnoreCase(this.command)) {
                for (String cmdParm : this.commandParams) {
                    String caseInsensitiveCommandParam = cmdParm.toLowerCase();
                    if (caseInsensitiveCommandParam.startsWith("--" + "changeSetId".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "help".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "force".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "changeSetPath".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "changeSetAuthor".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "rollbackScript".toLowerCase())) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            } else if ("rollbackOneChangeSetSQL".equalsIgnoreCase(this.command)) {
                for (String cmdParm : this.commandParams) {
                    String caseInsensitiveCommandParam = cmdParm.toLowerCase();
                    if (caseInsensitiveCommandParam.startsWith("--" + "changeSetId".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "help".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "force".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "changeSetPath".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "changeSetAuthor".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "rollbackScript".toLowerCase())) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            } else if ("rollbackOneUpdate".equalsIgnoreCase(this.command)) {
                for (String cmdParm : this.commandParams) {
                    String caseInsensitiveCommandParam = cmdParm.toLowerCase();
                    if (caseInsensitiveCommandParam.startsWith("--" + "deploymentId".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "help".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "force".toLowerCase())) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            } else if ("rollbackOneUpdateSQL".equalsIgnoreCase(this.command)) {
                for (String cmdParm : this.commandParams) {
                    String caseInsensitiveCommandParam = cmdParm.toLowerCase();
                    if (caseInsensitiveCommandParam.startsWith("--" + "deploymentId".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "help".toLowerCase()) || caseInsensitiveCommandParam.startsWith("--" + "force".toLowerCase())) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            }
        }
    }

    private void validateCommandParameters(List<String> messages) {
        this.checkForUnexpectedCommandParameter(messages);
        this.checkForMissingCommandParameters(messages);
        this.checkForMalformedCommandParameters(messages);
    }

    private void checkForMissingCommandParameters(List<String> messages) {
        if ((this.commandParams.isEmpty() || this.commandParams.iterator().next().startsWith("-")) && "calculateCheckSum".equalsIgnoreCase(this.command)) {
            messages.add(coreBundle.getString("changeset.identifier.missing"));
        }
    }

    private void checkForMalformedCommandParameters(List<String> messages) {
        if (this.commandParams.isEmpty()) {
            return;
        }
        int CHANGESET_MINIMUM_IDENTIFIER_PARTS = 3;
        if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
            for (String param : this.commandParams) {
                String[] parts;
                if (param == null || param.startsWith("-") || (parts = param.split("::")).length >= 3) continue;
                messages.add(coreBundle.getString("changeset.identifier.must.have.form.filepath.id.author"));
                break;
            }
        } else if ("diffChangeLog".equalsIgnoreCase(this.command) && this.diffTypes != null && this.diffTypes.toLowerCase().contains("data")) {
            messages.add(String.format(coreBundle.getString("including.data.diffchangelog.has.no.effect"), "diffTypes", "generateChangeLog"));
        }
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws IOException, CommandLineParsingException {
        IntegrationDetails integrationDetails = (IntegrationDetails)((Object)Scope.getCurrentScope().get("integrationDetails", IntegrationDetails.class));
        Properties props = new Properties();
        props.load(propertiesInputStream);
        if (runningFromNewCli) {
            this.parsePropertiesFileForNewCli(props);
            return;
        }
        boolean strict = GlobalConfiguration.STRICT.getCurrentValue();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String entryValue = null;
            if (entry.getValue() != null) {
                entryValue = String.valueOf(entry.getValue());
            }
            if (integrationDetails != null) {
                integrationDetails.setParameter("defaultsFile__" + String.valueOf(entry.getKey()), entryValue);
            }
            try {
                if ("promptOnNonLocalDatabase".equals(entry.getKey())) continue;
                if (((String)entry.getKey()).startsWith("parameter.")) {
                    this.changeLogParameters.put(((String)entry.getKey()).replaceFirst("^parameter.", ""), entry.getValue());
                    continue;
                }
                if (((String)entry.getKey()).contains(".")) {
                    if (Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).getRegisteredDefinition((String)entry.getKey()) == null) {
                        if (strict) {
                            throw new CommandLineParsingException(String.format(coreBundle.getString("parameter.unknown"), entry.getKey()));
                        }
                        Scope.getCurrentScope().getLog(this.getClass()).warning(String.format(coreBundle.getString("parameter.ignored"), entry.getKey()));
                    }
                    if (System.getProperty((String)entry.getKey()) != null) continue;
                    DeprecatedConfigurationValueProvider.setData((String)entry.getKey(), entry.getValue());
                    continue;
                }
                Field field = this.getDeclaredField((String)entry.getKey());
                Object currentValue = field.get(this);
                if (currentValue != null) continue;
                String value = entry.getValue().toString().trim();
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(value));
                    continue;
                }
                field.set(this, value);
            }
            catch (NoSuchFieldException ignored) {
                if (strict) {
                    throw new CommandLineParsingException(String.format(coreBundle.getString("parameter.unknown"), entry.getKey()));
                }
                Scope.getCurrentScope().getLog(this.getClass()).warning(String.format(coreBundle.getString("parameter.ignored"), entry.getKey()));
            }
            catch (IllegalAccessException e2) {
                throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("parameter.unknown"), entry.getKey()));
            }
        }
    }

    private void parsePropertiesFileForNewCli(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!((String)entry.getKey()).startsWith("parameter.")) continue;
            this.changeLogParameters.put(((String)entry.getKey()).replaceFirst("^parameter.", ""), entry.getValue());
        }
    }

    protected void printHelp(List<String> errorMessages, PrintStream stream) {
        stream.println(coreBundle.getString("errors"));
        for (String message : errorMessages) {
            stream.println("  " + message);
        }
        stream.println();
    }

    protected void printHelp(PrintStream stream) {
        this.logLevel = Level.WARNING.toString();
        String helpText = "Help not available when running liquibase.integration.commandline.Main directly. Use liquibase.integration.commandline.LiquibaseCommandLine";
        stream.println(helpText);
    }

    protected static CodePointCheck checkArg(String arg) {
        char[] chars = arg.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            for (int j2 = 0; j2 < suspiciousCodePoints.length; ++j2) {
                if (suspiciousCodePoints[j2] != chars[i2]) continue;
                CodePointCheck codePointCheck = new CodePointCheck();
                codePointCheck.position = i2;
                codePointCheck.ch = chars[i2];
                return codePointCheck;
            }
        }
        return null;
    }

    protected void parseOptions(String[] paramArgs) throws CommandLineParsingException {
        Class clazz;
        String key;
        String[] args = this.fixupArgs(paramArgs);
        boolean seenCommand = false;
        for (String arg : args) {
            if (Main.isCommand(arg)) {
                this.command = arg;
                if (this.command.equalsIgnoreCase("migrate")) {
                    this.command = "update";
                } else if (this.command.equalsIgnoreCase("migrateSQL")) {
                    this.command = "updateSQL";
                }
                seenCommand = true;
                continue;
            }
            if (seenCommand) {
                if (arg.startsWith("-D")) {
                    String[] splitArg = Main.splitArg(arg);
                    String attributeName = splitArg[0].replaceFirst("^-D", "");
                    String value = splitArg[1];
                    this.changeLogParameters.put(attributeName, value);
                    continue;
                }
                this.commandParams.add(arg);
                if (!arg.startsWith("--")) continue;
                this.parseOptionArgument(arg, true);
                continue;
            }
            if (arg.startsWith("--")) {
                this.parseOptionArgument(arg, false);
                continue;
            }
            throw new CommandLineParsingException(String.format(coreBundle.getString("unexpected.value"), arg));
        }
        this.parseDefaultPropertyFiles();
        if (this.liquibaseProLicenseKey == null) {
            this.liquibaseProLicenseKey = key = (String)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).getCurrentConfiguredValue(null, null, "liquibase.pro.licenseKey").getValue();
        }
        if (this.liquibaseHubApiKey == null) {
            this.liquibaseHubApiKey = key = HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue();
        }
        if (this.propertyProviderClass == null && (clazz = LiquibaseCommandLineConfiguration.PROPERTY_PROVIDER_CLASS.getCurrentValue()) != null) {
            this.propertyProviderClass = clazz.getName();
        }
        if (this.databaseClass == null && (clazz = LiquibaseCommandLineConfiguration.DATABASE_CLASS.getCurrentValue()) != null) {
            this.databaseClass = clazz.getName();
        }
    }

    private void parseOptionArgument(String arg, boolean okIfNotAField) throws CommandLineParsingException {
        block8: {
            String PROMPT_FOR_VALUE = "PROMPT";
            if (arg.toLowerCase().startsWith("--verbose") || arg.toLowerCase().startsWith("--help")) {
                return;
            }
            if (arg.toLowerCase().equals("--force") || arg.toLowerCase().equals("--help")) {
                arg = arg + "=true";
            }
            String[] splitArg = Main.splitArg(arg);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if ("PROMPT".equalsIgnoreCase(StringUtil.trimToEmpty(value))) {
                Console c2 = System.console();
                if (c2 == null) {
                    throw new CommandLineParsingException(String.format(MessageFormat.format(coreBundle.getString("cannot.prompt.for.the.value.no.console"), attributeName), new Object[0]));
                }
                value = attributeName.toLowerCase().contains("password") ? new String(c2.readPassword(attributeName + ": ", new Object[0])) : c2.readLine(attributeName + ": ", new Object[0]);
            }
            try {
                Field field = this.getDeclaredField(attributeName);
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(value));
                } else {
                    field.set(this, value);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e2) {
                if (okIfNotAField) break block8;
                throw new CommandLineParsingException(String.format(coreBundle.getString("option.unknown"), attributeName));
            }
        }
    }

    private Field getDeclaredField(String attributeName) throws NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(attributeName)) continue;
            return field;
        }
        throw new NoSuchFieldException();
    }

    protected void applyDefaults() {
        if (this.promptForNonLocalDatabase == null) {
            this.promptForNonLocalDatabase = Boolean.FALSE;
        }
        if (this.logLevel == null) {
            this.logLevel = "off";
        }
        if (this.includeSystemClasspath == null) {
            this.includeSystemClasspath = Boolean.TRUE;
        }
        if (this.outputDefaultCatalog == null) {
            this.outputDefaultCatalog = "true";
        }
        if (this.outputDefaultSchema == null) {
            this.outputDefaultSchema = "true";
        }
        if (this.defaultsFile == null) {
            this.defaultsFile = "liquibase.properties";
        }
        if (this.includeSchema == null) {
            this.includeSchema = Boolean.FALSE;
        }
        if (this.includeCatalog == null) {
            this.includeCatalog = Boolean.FALSE;
        }
        if (this.includeTablespace == null) {
            this.includeTablespace = Boolean.FALSE;
        }
    }

    protected ClassLoader configureClassLoader() throws CommandLineParsingException {
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (this.classpath != null) {
            String[] classpathSoFar = this.isWindows() ? this.classpath.split(";") : this.classpath.split(":");
            for (String classpathEntry : classpathSoFar) {
                File classPathFile = new File(classpathEntry);
                if (!classPathFile.exists()) {
                    throw new CommandLineParsingException(String.format(coreBundle.getString("does.not.exist"), classPathFile.getAbsolutePath()));
                }
                if (classpathEntry.endsWith(".war")) {
                    try {
                        Main.addWarFileClasspathEntries(classPathFile, urls);
                        continue;
                    }
                    catch (IOException e2) {
                        throw new CommandLineParsingException(e2);
                    }
                }
                if (classpathEntry.endsWith(".ear")) {
                    try (JarFile earZip = new JarFile(classPathFile);){
                        Enumeration<JarEntry> entries = earZip.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.getName().toLowerCase().endsWith(".jar")) {
                                File jar = Main.extract(earZip, entry);
                                URL newUrl = new URL("jar:" + jar.toURI().toURL() + "!/");
                                urls.add(newUrl);
                                LOG.fine(String.format(coreBundle.getString("adding.to.classpath"), newUrl));
                                jar.deleteOnExit();
                                continue;
                            }
                            if (!entry.getName().toLowerCase().endsWith("war")) continue;
                            File warFile = Main.extract(earZip, entry);
                            Main.addWarFileClasspathEntries(warFile, urls);
                        }
                        continue;
                    }
                    catch (IOException e3) {
                        throw new CommandLineParsingException(e3);
                    }
                }
                URL newUrl = null;
                try {
                    newUrl = new File(classpathEntry).toURI().toURL();
                }
                catch (MalformedURLException e4) {
                    throw new CommandLineParsingException(e4);
                }
                LOG.fine(String.format(coreBundle.getString("adding.to.classpath"), newUrl));
                urls.add(newUrl);
            }
        }
        this.classLoader = this.includeSystemClasspath != false ? (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            }
        }) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
            }
        });
        Thread.currentThread().setContextClassLoader(this.classLoader);
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doMigration() throws Exception {
        if ("help".equalsIgnoreCase(this.command)) {
            this.printHelp(System.err);
            return;
        }
        if (StringUtil.isNotEmpty(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue())) {
            LOG.fine("Liquibase Hub API Key:  " + HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValueObfuscated());
        }
        if (StringUtil.isNotEmpty(HubConfiguration.LIQUIBASE_HUB_URL.getCurrentValue())) {
            LOG.fine("Liquibase Hub URL:      " + HubConfiguration.LIQUIBASE_HUB_URL.getCurrentValue());
        }
        LOG.fine("Liquibase Hub Mode:     " + (Object)((Object)HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue()));
        String formatValue = this.getCommandParam("format", null);
        if (this.isLicenseableCommand(formatValue)) {
            if (this.isFormattedDiff() && formatValue != null && !formatValue.equalsIgnoreCase("json")) {
                String messageString = "\nWARNING: The diff command optional Pro parameter '--format' currently supports only 'TXT' or 'JSON' as values.  (Blank defaults to 'TXT')";
                throw new LiquibaseException(String.format(messageString, new Object[0]));
            }
            if (!this.commandParams.contains("--help") && !this.liquibaseProLicenseValid) {
                String warningAboutCommand = this.command;
                if (this.command.equalsIgnoreCase("diff") && formatValue != null && !formatValue.isEmpty()) {
                    warningAboutCommand = "diff --format=" + formatValue;
                }
                String messageString = String.format(coreBundle.getString("no.pro.license.found"), warningAboutCommand);
                throw new LiquibaseException(messageString);
            }
        }
        ResourceAccessor fileOpener = runningFromNewCli ? Scope.getCurrentScope().getResourceAccessor() : new CompositeResourceAccessor(new FileSystemResourceAccessor(Paths.get(".", new String[0]).toAbsolutePath().toFile()), new CommandLineResourceAccessor(this.classLoader));
        Database database = null;
        if (this.dbConnectionNeeded(this.command) && this.url != null) {
            database = CommandLineUtils.createDatabaseObject(fileOpener, this.url, this.username, this.password, this.driver, this.defaultCatalogName, this.defaultSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), this.databaseClass, this.driverPropertiesFile, this.propertyProviderClass, this.liquibaseCatalogName, this.liquibaseSchemaName, this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
            if (this.databaseChangeLogTablespaceName != null) {
                database.setLiquibaseTablespaceName(this.databaseChangeLogTablespaceName);
            } else {
                database.setLiquibaseTablespaceName(GlobalConfiguration.LIQUIBASE_TABLESPACE_NAME.getCurrentConfiguredValue().getValue());
            }
        }
        try {
            HashMap<String, Object> argsMap;
            Writer outputWriter;
            CommandScope liquibaseCommand;
            HashMap<String, Object> argsMap2;
            Liquibase liquibase;
            block183: {
                CommandScope snapshotCommand;
                if (this.excludeObjects != null && this.includeObjects != null) {
                    throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("cannot.specify.both"), "excludeObjects", "includeObjects"));
                }
                if (GlobalConfiguration.SHOULD_SNAPSHOT_DATA.getCurrentValue().equals(false) && this.dataOutputDirectory != null) {
                    DeprecatedConfigurationValueProvider.setData(GlobalConfiguration.SHOULD_SNAPSHOT_DATA, true);
                }
                StandardObjectChangeFilter objectChangeFilter = null;
                CompareControl.ComputedSchemas computedSchemas = CompareControl.computeSchemas(this.schemas, this.referenceSchemas, this.outputSchemasAs, this.defaultCatalogName, this.defaultSchemaName, this.referenceDefaultCatalogName, this.referenceDefaultSchemaName, database);
                CompareControl.SchemaComparison[] finalSchemaComparisons = computedSchemas.finalSchemaComparisons;
                DiffOutputControl diffOutputControl = new DiffOutputControl(this.includeCatalog, this.includeSchema, this.includeTablespace, finalSchemaComparisons);
                if (this.excludeObjects != null) {
                    objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, this.excludeObjects);
                    diffOutputControl.setObjectChangeFilter(objectChangeFilter);
                }
                if (this.includeObjects != null) {
                    objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, this.includeObjects);
                    diffOutputControl.setObjectChangeFilter(objectChangeFilter);
                }
                for (CompareControl.SchemaComparison schema : finalSchemaComparisons) {
                    diffOutputControl.addIncludedSchema(schema.getReferenceSchema());
                    diffOutputControl.addIncludedSchema(schema.getComparisonSchema());
                }
                if ("diff".equalsIgnoreCase(this.command)) {
                    if (this.commandParams.contains("--help")) {
                        outputStream.println("liquibase diff\n          Outputs a description of differences.  If you have a Liquibase Pro key, you can output the differences as JSON using the --format=JSON option\n");
                        System.exit(0);
                    }
                    if (this.isFormattedDiff()) {
                        CommandScope liquibaseCommand2 = new CommandScope("internalFormattedDiff");
                        CommandScope diffCommand = CommandLineUtils.createDiffCommand(this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, StringUtil.trimToNull(this.diffTypes), finalSchemaComparisons, objectChangeFilter, new PrintStream(this.getOutputStream()));
                        liquibaseCommand2.addArgumentValue("format", this.getCommandParam("format", "JSON").toUpperCase());
                        liquibaseCommand2.addArgumentValue("diffCommand", diffCommand);
                        liquibaseCommand2.setOutput(this.getOutputStream());
                        liquibaseCommand2.execute();
                        return;
                    }
                    CommandLineUtils.doDiff(this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, StringUtil.trimToNull(this.diffTypes), finalSchemaComparisons, objectChangeFilter, new PrintStream(this.getOutputStream()));
                    return;
                }
                if ("diffChangeLog".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doDiffToChangeLog(this.changeLogFile, this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, diffOutputControl, objectChangeFilter, StringUtil.trimToNull(this.diffTypes), finalSchemaComparisons);
                    return;
                }
                if ("generateChangeLog".equalsIgnoreCase(this.command)) {
                    File file;
                    String currentChangeLogFile = this.changeLogFile;
                    if (currentChangeLogFile == null) {
                        currentChangeLogFile = "";
                    }
                    if ((file = new File(currentChangeLogFile)).exists() && !Boolean.parseBoolean(this.overwriteOutputFile)) {
                        throw new LiquibaseException(String.format(coreBundle.getString("changelogfile.already.exists"), currentChangeLogFile));
                    }
                    try {
                        if (file.delete()) {
                            // empty if block
                        }
                    }
                    catch (SecurityException e2) {
                        throw new LiquibaseException(String.format(coreBundle.getString("attempt.to.delete.the.file.failed.cannot.continue"), currentChangeLogFile), e2);
                    }
                    CatalogAndSchema[] finalTargetSchemas = computedSchemas.finalTargetSchemas;
                    CommandLineUtils.doGenerateChangeLog(currentChangeLogFile, database, finalTargetSchemas, StringUtil.trimToNull(this.diffTypes), StringUtil.trimToNull(this.changeSetAuthor), StringUtil.trimToNull(this.changeSetContext), StringUtil.trimToNull(this.dataOutputDirectory), diffOutputControl);
                    return;
                }
                if ("snapshot".equalsIgnoreCase(this.command)) {
                    snapshotCommand = new CommandScope("internalSnapshot");
                    snapshotCommand.addArgumentValue(InternalSnapshotCommandStep.DATABASE_ARG, database).addArgumentValue(InternalSnapshotCommandStep.SCHEMAS_ARG, InternalSnapshotCommandStep.parseSchemas(database, this.getSchemaParams(database))).addArgumentValue(InternalSnapshotCommandStep.SERIALIZER_FORMAT_ARG, this.getCommandParam("snapshotFormat", null));
                    Writer outputWriter2 = this.getOutputWriter();
                    String result = InternalSnapshotCommandStep.printSnapshot(snapshotCommand, snapshotCommand.execute());
                    outputWriter2.write(result);
                    outputWriter2.flush();
                    return;
                }
                if ("executeSql".equalsIgnoreCase(this.command)) {
                    CommandScope executeSqlCommand = new CommandScope("internalExecuteSql").addArgumentValue(InternalExecuteSqlCommandStep.DATABASE_ARG, database).addArgumentValue(InternalExecuteSqlCommandStep.SQL_ARG, this.getCommandParam("sql", null)).addArgumentValue(InternalExecuteSqlCommandStep.SQLFILE_ARG, this.getCommandParam("sqlFile", null)).addArgumentValue(InternalExecuteSqlCommandStep.DELIMITER_ARG, this.getCommandParam("delimiter", ";"));
                    CommandResults results = executeSqlCommand.execute();
                    Writer outputWriter3 = this.getOutputWriter();
                    String output = (String)results.getResult("output");
                    outputWriter3.write(output);
                    outputWriter3.flush();
                    return;
                }
                if ("snapshotReference".equalsIgnoreCase(this.command)) {
                    snapshotCommand = new CommandScope("internalSnapshot");
                    Database referenceDatabase = this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener);
                    snapshotCommand.addArgumentValue(InternalSnapshotCommandStep.DATABASE_ARG, referenceDatabase).addArgumentValue(InternalSnapshotCommandStep.SCHEMAS_ARG, InternalSnapshotCommandStep.parseSchemas(referenceDatabase, this.getSchemaParams(referenceDatabase))).addArgumentValue(InternalSnapshotCommandStep.SERIALIZER_FORMAT_ARG, this.getCommandParam("snapshotFormat", null));
                    Writer outputWriter4 = this.getOutputWriter();
                    outputWriter4.write(InternalSnapshotCommandStep.printSnapshot(snapshotCommand, snapshotCommand.execute()));
                    outputWriter4.flush();
                    return;
                }
                liquibase = new Liquibase(this.changeLogFile, fileOpener, database);
                if (newCliChangelogParameters != null) {
                    for (Map.Entry<String, String> param : newCliChangelogParameters.entrySet()) {
                        liquibase.setChangeLogParameter(param.getKey(), param.getValue());
                    }
                }
                try {
                    if (this.hubConnectionId == null) break block183;
                    try {
                        liquibase.setHubConnectionId(UUID.fromString(this.hubConnectionId));
                    }
                    catch (IllegalArgumentException e3) {
                        throw new LiquibaseException("The command '" + this.command + "' failed because parameter 'hubConnectionId' has invalid value '" + this.hubConnectionId + "' Learn more at https://hub.liquibase.com");
                    }
                }
                catch (IllegalArgumentException e4) {
                    throw new LiquibaseException("Unexpected hubConnectionId format: " + this.hubConnectionId, e4);
                }
            }
            ChangeExecListener listener = ChangeExecListenerUtils.getChangeExecListener(liquibase.getDatabase(), liquibase.getResourceAccessor(), this.changeExecListenerClass, this.changeExecListenerPropertiesFile);
            liquibase.setChangeExecListener(listener);
            if (database != null) {
                database.setCurrentDateTimeFunction(this.currentDateTimeFunction);
            }
            for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
            if ("listLocks".equalsIgnoreCase(this.command)) {
                liquibase.reportLocks(System.err);
                return;
            }
            if ("releaseLocks".equalsIgnoreCase(this.command)) {
                LockService lockService = LockServiceFactory.getInstance().getLockService(database);
                lockService.forceReleaseLock();
                Scope.getCurrentScope().getUI().sendMessage(String.format(coreBundle.getString("successfully.released.database.change.log.locks"), liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("tag".equalsIgnoreCase(this.command)) {
                liquibase.tag(this.getCommandArgument());
                Scope.getCurrentScope().getUI().sendMessage(String.format(coreBundle.getString("successfully.tagged"), liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("tagExists".equalsIgnoreCase(this.command)) {
                String tag = this.commandParams.iterator().next();
                boolean exists = liquibase.tagExists(tag);
                if (exists) {
                    Scope.getCurrentScope().getUI().sendMessage(String.format(coreBundle.getString("tag.exists"), tag, liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                    return;
                }
                Scope.getCurrentScope().getUI().sendMessage(String.format(coreBundle.getString("tag.does.not.exist"), tag, liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("rollbackOneChangeSet".equalsIgnoreCase(this.command)) {
                argsMap2 = new HashMap<String, Object>();
                this.loadChangeSetInfoToMap(argsMap2);
                argsMap2.put("changeLogFile", this.changeLogFile);
                liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "internalRollbackOneChangeSet", argsMap2);
                liquibaseCommand.execute();
                return;
            }
            if ("rollbackOneChangeSetSQL".equalsIgnoreCase(this.command)) {
                outputWriter = this.getOutputWriter();
                argsMap = new HashMap<String, Object>();
                this.loadChangeSetInfoToMap(argsMap);
                argsMap.put("changeLogFile", this.changeLogFile);
                argsMap.put("outputWriter", outputWriter);
                argsMap.put("force", Boolean.TRUE);
                CommandScope liquibaseCommand3 = this.createLiquibaseCommand(database, liquibase, "internalRollbackOneChangeSetSQL", argsMap);
                liquibaseCommand3.execute();
                return;
            }
            if ("rollbackOneUpdate".equalsIgnoreCase(this.command)) {
                argsMap2 = new HashMap();
                argsMap2.put("changeLogFile", this.changeLogFile);
                argsMap2.put("deploymentId", this.getCommandParam("deploymentId", null));
                liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "internalRollbackOneUpdate", argsMap2);
                liquibaseCommand.execute();
                return;
            }
            if ("rollbackOneUpdateSQL".equalsIgnoreCase(this.command)) {
                outputWriter = this.getOutputWriter();
                argsMap = new HashMap();
                argsMap.put("deploymentId", this.getCommandParam("deploymentId", null));
                argsMap.put("force", Boolean.TRUE);
                argsMap.put("outputWriter", outputWriter);
                CommandScope liquibaseCommand4 = this.createLiquibaseCommand(database, liquibase, "internalRollbackOneUpdateSQL", argsMap);
                liquibaseCommand4.execute();
                return;
            }
            if ("deactivateChangeLog".equalsIgnoreCase(this.command)) {
                argsMap2 = new HashMap();
                liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "deactivateChangeLog", argsMap2);
                liquibaseCommand.addArgumentValue(DeactivateChangelogCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile);
                liquibaseCommand.execute();
                return;
            }
            if ("registerChangeLog".equalsIgnoreCase(this.command)) {
                block184: {
                    argsMap2 = new HashMap();
                    liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "registerChangeLog", argsMap2);
                    if (this.hubProjectId != null && this.hubProjectName != null) {
                        throw new LiquibaseException("\nThe 'registerchangelog' command failed because too many parameters were provided. Command expects a Hub project ID or new Hub project name, but not both.\n");
                    }
                    try {
                        if (this.hubProjectId == null) break block184;
                        try {
                            liquibaseCommand.addArgumentValue(RegisterChangelogCommandStep.HUB_PROJECT_ID_ARG, UUID.fromString(this.hubProjectId));
                        }
                        catch (IllegalArgumentException e5) {
                            throw new LiquibaseException("The command '" + this.command + "' failed because parameter 'hubProjectId' has invalid value '" + this.hubProjectId + "'. Learn more at https://hub.liquibase.com");
                        }
                    }
                    catch (IllegalArgumentException e6) {
                        throw new LiquibaseException("Unexpected hubProjectId format: " + this.hubProjectId, e6);
                    }
                }
                if (this.hubProjectName != null) {
                    liquibaseCommand.addArgumentValue(RegisterChangelogCommandStep.HUB_PROJECT_NAME_ARG.getName(), this.hubProjectName);
                }
                liquibaseCommand.execute();
                return;
            }
            if ("syncHub".equalsIgnoreCase(this.command)) {
                this.executeSyncHub(database, liquibase);
                return;
            }
            if ("dropAll".equalsIgnoreCase(this.command)) {
                CommandScope dropAllCommand = new CommandScope("internalDropAll");
                if (this.hubConnectionId != null) {
                    dropAllCommand.addArgumentValue(InternalDropAllCommandStep.HUB_CONNECTION_ID_ARG, UUID.fromString(this.hubConnectionId));
                }
                if (this.hubProjectId != null) {
                    dropAllCommand.addArgumentValue(InternalDropAllCommandStep.HUB_PROJECT_ID_ARG, UUID.fromString(this.hubProjectId));
                }
                dropAllCommand.addArgumentValue(InternalDropAllCommandStep.DATABASE_ARG, liquibase.getDatabase()).addArgumentValue(InternalDropAllCommandStep.SCHEMAS_ARG, InternalSnapshotCommandStep.parseSchemas(database, this.getSchemaParams(database))).addArgumentValue(InternalDropAllCommandStep.CHANGELOG_FILE_ARG, this.changeLogFile);
                dropAllCommand.execute();
                return;
            }
            if ("status".equalsIgnoreCase(this.command)) {
                boolean runVerbose = false;
                if (this.commandParams.contains("--verbose")) {
                    runVerbose = true;
                }
                liquibase.reportStatus(runVerbose, new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                return;
            }
            if ("unexpectedChangeSets".equalsIgnoreCase(this.command)) {
                boolean runVerbose = false;
                if (this.commandParams.contains("--verbose")) {
                    runVerbose = true;
                }
                liquibase.reportUnexpectedChangeSets(runVerbose, this.contexts, this.getOutputWriter());
                return;
            }
            if ("validate".equalsIgnoreCase(this.command)) {
                liquibase.validate();
                Scope.getCurrentScope().getUI().sendMessage(coreBundle.getString("no.validation.errors.found"));
                return;
            }
            if ("clearCheckSums".equalsIgnoreCase(this.command)) {
                liquibase.clearCheckSums();
                return;
            }
            if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
                CheckSum checkSum = null;
                checkSum = liquibase.calculateCheckSum(this.commandParams.iterator().next());
                Scope.getCurrentScope().getUI().sendMessage(checkSum.toString());
                return;
            }
            if ("dbDoc".equalsIgnoreCase(this.command)) {
                if (this.commandParams.isEmpty()) {
                    throw new CommandLineParsingException(coreBundle.getString("dbdoc.requires.output.directory"));
                }
                if (this.changeLogFile == null) {
                    throw new CommandLineParsingException(coreBundle.getString("dbdoc.requires.changelog.parameter"));
                }
                liquibase.generateDocumentation(this.commandParams.iterator().next(), this.contexts);
                return;
            }
            try {
                if ("update".equalsIgnoreCase(this.command)) {
                    liquibase.update(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("changelogSync".equalsIgnoreCase(this.command)) {
                    liquibase.changeLogSync(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("changelogSyncSQL".equalsIgnoreCase(this.command)) {
                    liquibase.changeLogSync(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("changelogSyncToTag".equalsIgnoreCase(this.command)) {
                    if (this.commandParams != null && !this.commandParams.isEmpty()) {
                        liquibase.changeLogSync(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels));
                        return;
                    }
                    throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "changelogSyncToTag"));
                }
                if ("changelogSyncToTagSQL".equalsIgnoreCase(this.command)) {
                    if (this.commandParams != null && !this.commandParams.isEmpty()) {
                        liquibase.changeLogSync(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        return;
                    }
                    throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "changelogSyncToTagSQL"));
                }
                if ("markNextChangeSetRan".equalsIgnoreCase(this.command)) {
                    liquibase.markNextChangeSetRan(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("markNextChangeSetRanSQL".equalsIgnoreCase(this.command)) {
                    liquibase.markNextChangeSetRan(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateCount".equalsIgnoreCase(this.command)) {
                    liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("updateCountSQL".equalsIgnoreCase(this.command)) {
                    liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateToTag".equalsIgnoreCase(this.command)) {
                    if (this.commandParams != null && !this.commandParams.isEmpty()) {
                        liquibase.update(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels));
                        return;
                    }
                    throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "updateToTag"));
                }
                if ("updateToTagSQL".equalsIgnoreCase(this.command)) {
                    if (this.commandParams != null && !this.commandParams.isEmpty()) {
                        liquibase.update(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        return;
                    }
                    throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "updateToTagSQL"));
                }
                if ("updateSQL".equalsIgnoreCase(this.command)) {
                    liquibase.update(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollback".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "rollback"));
                    }
                    liquibase.rollback(this.getCommandArgument(), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackToDate".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.timestamp"), "rollbackToDate"));
                    }
                    liquibase.rollback(new ISODateFormat().parse(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackCount".equalsIgnoreCase(this.command)) {
                    liquibase.rollback(Integer.parseInt(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "rollbackSQL"));
                    }
                    liquibase.rollback(this.getCommandArgument(), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollbackToDateSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.timestamp"), "rollbackToDateSQL"));
                    }
                    liquibase.rollback(new ISODateFormat().parse(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollbackCountSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.count"), "rollbackCountSQL"));
                    }
                    liquibase.rollback(Integer.parseInt(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackSQL".equalsIgnoreCase(this.command)) {
                    liquibase.futureRollbackSQL(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackCountSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.count"), "futureRollbackCountSQL"));
                    }
                    liquibase.futureRollbackSQL(Integer.valueOf(this.getCommandArgument()), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackFromTagSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "futureRollbackFromTagSQL"));
                    }
                    liquibase.futureRollbackSQL(this.getCommandArgument(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateTestingRollback".equalsIgnoreCase(this.command)) {
                    liquibase.updateTestingRollback(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("history".equalsIgnoreCase(this.command)) {
                    CommandScope historyCommand = new CommandScope("internalHistory");
                    historyCommand.addArgumentValue(InternalHistoryCommandStep.DATABASE_ARG, database);
                    historyCommand.setOutput(this.getOutputStream());
                    historyCommand.execute();
                    return;
                }
                throw new CommandLineParsingException(String.format(coreBundle.getString("command.unknown"), this.command));
            }
            catch (ParseException ignored) {
                throw new CommandLineParsingException(coreBundle.getString("timeformat.invalid"));
            }
        }
        finally {
            try {
                if (database != null) {
                    database.rollback();
                    database.close();
                }
            }
            catch (DatabaseException e7) {
                Scope.getCurrentScope().getLog(this.getClass()).warning(coreBundle.getString("problem.closing.connection"), e7);
            }
        }
    }

    private void executeSyncHub(Database database, Liquibase liquibase) throws CommandLineParsingException, LiquibaseException, CommandExecutionException {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        CommandScope liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "internalSyncHub", argsMap);
        liquibaseCommand.addArgumentValue(InternalSyncHubCommandStep.HUB_CONNECTION_ID_ARG, this.hubConnectionId == null ? null : UUID.fromString(this.hubConnectionId)).addArgumentValue(InternalSyncHubCommandStep.URL_ARG, this.url).addArgumentValue(InternalSyncHubCommandStep.DATABASE_ARG, database).addArgumentValue(InternalSyncHubCommandStep.HUB_PROJECT_ID_ARG, this.hubProjectId == null ? null : UUID.fromString(this.hubProjectId));
        liquibaseCommand.execute();
    }

    private boolean dbConnectionNeeded(String command) {
        return !"registerChangeLog".equalsIgnoreCase(command) && !"deactivateChangeLog".equalsIgnoreCase(command);
    }

    private boolean isLicenseableCommand(String formatValue) {
        return "rollbackOneChangeSet".equalsIgnoreCase(this.command) || "rollbackOneChangeSetSQL".equalsIgnoreCase(this.command) || "rollbackOneUpdate".equalsIgnoreCase(this.command) || "rollbackOneUpdateSQL".equalsIgnoreCase(this.command) || "diff".equalsIgnoreCase(this.command) && formatValue != null && !formatValue.toLowerCase().equals("txt");
    }

    private void loadChangeSetInfoToMap(Map<String, Object> argsMap) throws CommandLineParsingException {
        argsMap.put("changeSetId", this.getCommandParam("changeSetId", null));
        argsMap.put("changeSetAuthor", this.getCommandParam("changeSetAuthor", null));
        argsMap.put("changeSetPath", this.getCommandParam("changeSetPath", null));
    }

    private boolean isFormattedDiff() throws CommandLineParsingException {
        String formatValue = this.getCommandParam("format", "txt");
        return !formatValue.equalsIgnoreCase("txt") && !formatValue.isEmpty();
    }

    private String getSchemaParams(Database database) throws CommandLineParsingException {
        String schemaParams = this.getCommandParam("schemas", this.schemas);
        if (schemaParams == null || schemaParams.isEmpty()) {
            return database.getDefaultSchema().getSchemaName();
        }
        return schemaParams;
    }

    private CommandScope createLiquibaseCommand(Database database, Liquibase liquibase, String commandName, Map<String, Object> argsMap) throws LiquibaseException {
        String liquibaseHubApiKey;
        argsMap.put("rollbackScript", this.rollbackScript);
        argsMap.put("changeLogFile", this.changeLogFile);
        argsMap.put("database", database);
        argsMap.put("liquibase", liquibase);
        if (!this.commandParams.contains("--help")) {
            argsMap.put("changeLog", liquibase.getDatabaseChangeLog());
        }
        ChangeLogParameters clp = new ChangeLogParameters(database);
        for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
            clp.set(entry.getKey(), entry.getValue());
        }
        argsMap.put("changeLogParameters", clp);
        if (this.commandParams.contains("--force") || this.commandParams.contains("--force=true")) {
            argsMap.put("force", Boolean.TRUE);
        }
        if (this.commandParams.contains("--help")) {
            argsMap.put("help", Boolean.TRUE);
        }
        if (this.liquibaseProLicenseKey != null) {
            argsMap.put("liquibaseProLicenseKey", this.liquibaseProLicenseKey);
        }
        if ((liquibaseHubApiKey = HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue()) != null) {
            argsMap.put("liquibaseHubApiKey", liquibaseHubApiKey);
        }
        CommandScope liquibaseCommand = new CommandScope(commandName);
        for (Map.Entry<String, Object> entry : argsMap.entrySet()) {
            liquibaseCommand.addArgumentValue(entry.getKey(), entry.getValue());
        }
        return liquibaseCommand;
    }

    private String getCommandArgument() {
        for (String param : this.commandParams) {
            if (param.contains("=")) continue;
            return param;
        }
        return null;
    }

    private String getCommandParam(String paramName, String defaultValue) throws CommandLineParsingException {
        for (String param : this.commandParams) {
            if (!param.contains("=")) continue;
            String[] splitArg = Main.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if (!attributeName.equalsIgnoreCase(paramName)) continue;
            return value;
        }
        return defaultValue;
    }

    private Database createReferenceDatabaseFromCommandParams(Set<String> commandParams, ResourceAccessor resourceAccessor) throws CommandLineParsingException, DatabaseException {
        String refDriver = this.referenceDriver;
        String refUrl = this.referenceUrl;
        String refUsername = this.referenceUsername;
        String refPassword = this.referencePassword;
        String defSchemaName = this.referenceDefaultSchemaName;
        String defCatalogName = this.referenceDefaultCatalogName;
        for (String param : commandParams) {
            String[] splitArg = Main.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if ("referenceDriver".equalsIgnoreCase(attributeName)) {
                refDriver = value;
                continue;
            }
            if ("referenceUrl".equalsIgnoreCase(attributeName)) {
                refUrl = value;
                continue;
            }
            if ("referenceUsername".equalsIgnoreCase(attributeName)) {
                refUsername = value;
                continue;
            }
            if ("referencePassword".equalsIgnoreCase(attributeName)) {
                refPassword = value;
                continue;
            }
            if ("referenceDefaultCatalogName".equalsIgnoreCase(attributeName)) {
                defCatalogName = value;
                continue;
            }
            if ("referenceDefaultSchemaName".equalsIgnoreCase(attributeName)) {
                defSchemaName = value;
                continue;
            }
            if (!"dataOutputDirectory".equalsIgnoreCase(attributeName)) continue;
            this.dataOutputDirectory = value;
        }
        if (refUrl == null) {
            throw new CommandLineParsingException(String.format(coreBundle.getString("option.required"), "--referenceUrl"));
        }
        return CommandLineUtils.createDatabaseObject(resourceAccessor, refUrl, refUsername, refPassword, refDriver, defCatalogName, defSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), null, null, this.propertyProviderClass, this.liquibaseCatalogName, this.liquibaseSchemaName, this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
    }

    private OutputStream getOutputStream() throws IOException {
        if (outputStream != null) {
            return outputStream;
        }
        if (this.outputFile != null) {
            try {
                FileOutputStream fileOut = new FileOutputStream(this.outputFile, false);
                return fileOut;
            }
            catch (IOException e2) {
                Scope.getCurrentScope().getLog(this.getClass()).severe(String.format(coreBundle.getString("could.not.create.output.file"), this.outputFile));
                throw e2;
            }
        }
        return outputStream;
    }

    public static PrintStream setOutputStream(PrintStream outputStream) {
        Main.outputStream = outputStream;
        return outputStream;
    }

    private Writer getOutputWriter() throws IOException {
        String charsetName = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        return new OutputStreamWriter(this.getOutputStream(), charsetName);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows ");
    }

    static {
        outputStream = System.out;
        LOG = Scope.getCurrentScope().getLog(Main.class);
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        suspiciousCodePoints = new int[]{160, 225, 226, 227, 228, 229, 230, 198, 200, 201, 202, 203, 204, 205, 206, 207, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 222, 223, 232, 233, 234, 235, 236, 237, 238, 239, 241, 249, 250, 251, 252, 255, 284, 332, 333, 334, 335, 336, 337, 359, 360, 361, 362, 363, 364, 365, 366, 367, 377, 399, 8192, 8193, 8194, 8196, 8197, 8199, 8200, 8201, 8202, 8203, 8211, 8287};
    }

    private static enum OPTIONS {

        private static final String VERBOSE = "verbose";
        private static final String CHANGELOG_FILE = "changeLogFile";
        private static final String DATA_OUTPUT_DIRECTORY = "dataOutputDirectory";
        private static final String DIFF_TYPES = "diffTypes";
        private static final String CHANGE_SET_ID = "changeSetId";
        private static final String CHANGE_SET_AUTHOR = "changeSetAuthor";
        private static final String CHANGE_SET_PATH = "changeSetPath";
        private static final String DEPLOYMENT_ID = "deploymentId";
        private static final String OUTPUT_FILE = "outputFile";
        private static final String FORCE = "force";
        private static final String FORMAT = "format";
        private static final String ROLLBACK_SCRIPT = "rollbackScript";
        private static final String EXCLUDE_OBJECTS = "excludeObjects";
        private static final String INCLUDE_CATALOG = "includeCatalog";
        private static final String INCLUDE_OBJECTS = "includeObjects";
        private static final String INCLUDE_SCHEMA = "includeSchema";
        private static final String INCLUDE_TABLESPACE = "includeTablespace";
        private static final String DEACTIVATE = "deactivate";
        private static final String OUTPUT_SCHEMAS_AS = "outputSchemasAs";
        private static final String REFERENCE_DEFAULT_CATALOG_NAME = "referenceDefaultCatalogName";
        private static final String REFERENCE_DEFAULT_SCHEMA_NAME = "referenceDefaultSchemaName";
        private static final String REFERENCE_DRIVER = "referenceDriver";
        private static final String REFERENCE_PASSWORD = "referencePassword";
        private static final String REFERENCE_SCHEMAS = "referenceSchemas";
        private static final String REFERENCE_URL = "referenceUrl";
        private static final String REFERENCE_USERNAME = "referenceUsername";
        private static final String SCHEMAS = "schemas";
        private static final String URL = "url";
        private static final String HELP = "help";
        private static final String VERSION = "version";
        private static final String SNAPSHOT_FORMAT = "snapshotFormat";
        private static final String LOG_FILE = "logFile";
        private static final String LOG_LEVEL = "logLevel";
    }

    private static enum COMMANDS {

        private static final String CALCULATE_CHECKSUM = "calculateCheckSum";
        private static final String CHANGELOG_SYNC = "changelogSync";
        private static final String CHANGELOG_SYNC_SQL = "changelogSyncSQL";
        private static final String CHANGELOG_SYNC_TO_TAG = "changelogSyncToTag";
        private static final String CHANGELOG_SYNC_TO_TAG_SQL = "changelogSyncToTagSQL";
        private static final String CLEAR_CHECKSUMS = "clearCheckSums";
        private static final String DB_DOC = "dbDoc";
        private static final String DIFF = "diff";
        private static final String DIFF_CHANGELOG = "diffChangeLog";
        private static final String DROP_ALL = "dropAll";
        private static final String EXECUTE_SQL = "executeSql";
        private static final String FUTURE_ROLLBACK_COUNT_SQL = "futureRollbackCountSQL";
        private static final String FUTURE_ROLLBACK_FROM_TAG_SQL = "futureRollbackFromTagSQL";
        private static final String FUTURE_ROLLBACK_SQL = "futureRollbackSQL";
        private static final String GENERATE_CHANGELOG = "generateChangeLog";
        private static final String HELP = "help";
        private static final String HISTORY = "history";
        private static final String LIST_LOCKS = "listLocks";
        private static final String MARK_NEXT_CHANGESET_RAN = "markNextChangeSetRan";
        private static final String MARK_NEXT_CHANGESET_RAN_SQL = "markNextChangeSetRanSQL";
        private static final String MIGRATE = "migrate";
        private static final String MIGRATE_SQL = "migrateSQL";
        private static final String RELEASE_LOCKS = "releaseLocks";
        private static final String ROLLBACK_ONE_CHANGE_SET = "rollbackOneChangeSet";
        private static final String ROLLBACK_ONE_CHANGE_SET_SQL = "rollbackOneChangeSetSQL";
        private static final String ROLLBACK_ONE_UPDATE = "rollbackOneUpdate";
        private static final String ROLLBACK_ONE_UPDATE_SQL = "rollbackOneUpdateSQL";
        private static final String REGISTER_CHANGELOG = "registerChangeLog";
        private static final String DEACTIVATE_CHANGELOG = "deactivateChangeLog";
        private static final String FORMATTED_DIFF = "formattedDiff";
        private static final String ROLLBACK = "rollback";
        private static final String ROLLBACK_COUNT = "rollbackCount";
        private static final String ROLLBACK_COUNT_SQL = "rollbackCountSQL";
        private static final String ROLLBACK_SCRIPT = "rollbackScript";
        private static final String ROLLBACK_SQL = "rollbackSQL";
        private static final String ROLLBACK_TO_DATE = "rollbackToDate";
        private static final String ROLLBACK_TO_DATE_SQL = "rollbackToDateSQL";
        private static final String SNAPSHOT = "snapshot";
        private static final String SNAPSHOT_REFERENCE = "snapshotReference";
        private static final String STATUS = "status";
        private static final String SYNC_HUB = "syncHub";
        private static final String TAG = "tag";
        private static final String TAG_EXISTS = "tagExists";
        private static final String UNEXPECTED_CHANGESETS = "unexpectedChangeSets";
        private static final String UPDATE = "update";
        private static final String UPDATE_COUNT = "updateCount";
        private static final String UPDATE_COUNT_SQL = "updateCountSQL";
        private static final String UPDATE_SQL = "updateSQL";
        private static final String UPDATE_TESTING_ROLLBACK = "updateTestingRollback";
        private static final String UPDATE_TO_TAG = "updateToTag";
        private static final String UPDATE_TO_TAG_SQL = "updateToTagSQL";
        private static final String VALIDATE = "validate";
    }

    private static enum FILE_SUFFIXES {

        private static final String FILE_SUFFIX_EAR = ".ear";
        private static final String WAR_FILE_SUFFIX = ".war";
    }

    public static class SecureLogFilter
    implements Filter {
        private LogMessageFilter filter;

        public SecureLogFilter(LogMessageFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String filteredMessage = this.filter.filterMessage(record.getMessage());
            boolean equals = filteredMessage.equals(record.getMessage());
            return equals;
        }
    }

    protected static class CodePointCheck {
        public int position;
        public char ch;

        protected CodePointCheck() {
        }
    }
}

