/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.request.cycle.RequestCycle;

public class FeedbackDelay
implements Serializable,
AutoCloseable {
    private static final MetaDataKey<FeedbackDelay> KEY = new MetaDataKey<FeedbackDelay>(){
        private static final long serialVersionUID = 1L;
    };
    private List<IFeedback> feedbacks = new ArrayList<IFeedback>();
    private RequestCycle cycle;

    public FeedbackDelay(RequestCycle cycle) {
        if (FeedbackDelay.get(cycle).isPresent()) {
            throw new WicketRuntimeException("feedbacks are already delayed");
        }
        cycle.setMetaData((MetaDataKey)KEY, this);
        this.cycle = cycle;
    }

    public static Optional<FeedbackDelay> get(RequestCycle cycle) {
        return Optional.ofNullable(cycle.getMetaData(KEY));
    }

    public FeedbackDelay postpone(IFeedback feedback) {
        this.feedbacks.add(feedback);
        return this;
    }

    public void beforeRender() {
        this.cycle.setMetaData((MetaDataKey)KEY, (Object)null);
        this.cycle = null;
        for (IFeedback feedback : this.feedbacks) {
            Component component;
            if (feedback instanceof Component && (component = (Component)((Object)feedback)).findParent(Page.class) == null) continue;
            feedback.beforeRender();
        }
    }

    @Override
    public void close() {
        if (this.cycle != null) {
            this.cycle.setMetaData((MetaDataKey)KEY, (Object)null);
            this.cycle = null;
            this.feedbacks.clear();
        }
    }
}

