/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;

public class RealmQuery
extends AbstractQuery {
    private static final long serialVersionUID = -2278419397595186866L;
    private String keyword;
    private Set<String> bases;

    public String getKeyword() {
        return this.keyword;
    }

    @QueryParam(value="keyword")
    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Set<String> getBases() {
        return this.bases;
    }

    @QueryParam(value="bases")
    public void setBases(Set<String> bases) {
        this.bases = bases;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealmQuery other = (RealmQuery)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.keyword, (Object)other.keyword).append(this.bases, other.bases).build();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.keyword).append(this.bases).build();
    }

    public static class Builder
    extends AbstractQuery.Builder<RealmQuery, Builder> {
        @Override
        protected RealmQuery newInstance() {
            return new RealmQuery();
        }

        public Builder keyword(String keyword) {
            ((RealmQuery)this.getInstance()).setKeyword(keyword);
            return this;
        }

        public Builder base(String ... bases) {
            if (bases != null) {
                Set b = Optional.ofNullable(((RealmQuery)this.getInstance()).getBases()).orElseGet(HashSet::new);
                b.addAll(Stream.of(bases).collect(Collectors.toSet()));
                ((RealmQuery)this.getInstance()).setBases(b);
            }
            return this;
        }

        public Builder bases(Collection<String> bases) {
            if (bases != null) {
                Set b = Optional.ofNullable(((RealmQuery)this.getInstance()).getBases()).orElseGet(HashSet::new);
                b.addAll(bases);
                ((RealmQuery)this.getInstance()).setBases(b);
            }
            return this;
        }
    }
}

