/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springmodules.cache.CacheModel;
import org.springmodules.cache.interceptor.MethodMatcher;

public final class MethodMapCacheModelSource {
    private final MethodMatcher matcher;
    private final Map methodMap;
    private final Map models = new HashMap();

    public MethodMapCacheModelSource() {
        this.matcher = new MethodMatcher();
        this.methodMap = new HashMap();
    }

    public void addModel(CacheModel model, String fullyQualifiedMethodName) throws IllegalArgumentException {
        Collection matches = this.matcher.matchingMethods(fullyQualifiedMethodName);
        this.notEmpty(matches, fullyQualifiedMethodName);
        this.registerMostSpecificMethod(matches, model, fullyQualifiedMethodName);
    }

    private void registerMostSpecificMethod(Collection matches, CacheModel model, String fullyQualifiedMethodName) {
        Iterator i = matches.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            if (!this.methodNotRegisteredOrMoreSpecificMethodFound(method, fullyQualifiedMethodName)) continue;
            this.addModel(model, method, fullyQualifiedMethodName);
        }
    }

    public CacheModel model(Method m) {
        return (CacheModel)this.models.get(m);
    }

    private void addModel(CacheModel c, Method m, String fullyQualifiedMethodName) {
        this.methodMap.put(m, fullyQualifiedMethodName);
        this.models.put(m, c);
    }

    private boolean methodNotRegisteredOrMoreSpecificMethodFound(Method m, String target) {
        String registered = (String)this.methodMap.get(m);
        if (registered == null) {
            return true;
        }
        return !target.equals(registered) && target.length() <= registered.length();
    }

    private void notEmpty(Collection matchingMethods, String targetMethodName) throws IllegalArgumentException {
        if (!matchingMethods.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Couldn't find any method matching '" + targetMethodName + "'");
    }
}

