/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.scriptedsql;

import net.tirasa.connid.bundles.db.commons.JNDIUtil;
import net.tirasa.connid.commons.scripted.AbstractScriptedConfiguration;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class ScriptedSQLConfiguration
extends AbstractScriptedConfiguration {
    public static final String EMPTY_STR = "";
    private String quoting = "";
    private String host = "localhost";
    private String port = "3306";
    private String user = "";
    private GuardedString password;
    private String database = "";
    private String jdbcDriver = "com.mysql.jdbc.Driver";
    private String jdbcUrlTemplate = "jdbc:mysql://%h:%p/%d";
    private boolean autoCommit = true;
    private boolean enableEmptyString = false;
    public boolean rethrowAllSQLExceptions = true;
    public boolean nativeTimestamps = false;
    public boolean allNative = false;
    private String validConnectionQuery;
    private String datasource = "";
    private String[] jndiProperties;

    @ConfigurationProperty(order=-15, displayMessageKey="QUOTING_DISPLAY", helpMessageKey="QUOTING_HELP")
    public String getQuoting() {
        return this.quoting;
    }

    public void setQuoting(String value) {
        this.quoting = value;
    }

    @ConfigurationProperty(order=-14, displayMessageKey="HOST_DISPLAY", helpMessageKey="HOST_HELP")
    public String getHost() {
        return this.host;
    }

    public void setHost(String value) {
        this.host = value;
    }

    @ConfigurationProperty(order=-13, displayMessageKey="PORT_DISPLAY", helpMessageKey="PORT_HELP")
    public String getPort() {
        return this.port;
    }

    public void setPort(String value) {
        this.port = value;
    }

    @ConfigurationProperty(order=-12, displayMessageKey="USER_DISPLAY", helpMessageKey="USER_HELP")
    public String getUser() {
        return this.user;
    }

    public void setUser(String value) {
        this.user = value;
    }

    @ConfigurationProperty(order=-11, confidential=true, displayMessageKey="PASSWORD_DISPLAY", helpMessageKey="PASSWORD_HELP")
    public GuardedString getPassword() {
        return this.password;
    }

    public void setPassword(GuardedString value) {
        this.password = value;
    }

    @ConfigurationProperty(order=-10, displayMessageKey="DATABASE_DISPLAY", helpMessageKey="DATABASE_HELP")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String value) {
        this.database = value;
    }

    @ConfigurationProperty(order=-9, displayMessageKey="JDBC_DRIVER_DISPLAY", helpMessageKey="JDBC_DRIVER_HELP")
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String value) {
        this.jdbcDriver = value;
    }

    @ConfigurationProperty(order=-8, displayMessageKey="URL_TEMPLATE_DISPLAY", helpMessageKey="URL_TEMPLATE_HELP")
    public String getJdbcUrlTemplate() {
        return this.jdbcUrlTemplate;
    }

    public void setJdbcUrlTemplate(String value) {
        this.jdbcUrlTemplate = value;
    }

    @ConfigurationProperty(order=-7, displayMessageKey="AUTO_COMMIT_DISPLAY", helpMessageKey="AUTO_COMMIT_HELP")
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @ConfigurationProperty(order=-6, displayMessageKey="ENABLE_EMPTY_STRING_DISPLAY", helpMessageKey="ENABLE_EMPTY_STRING_HELP")
    public boolean isEnableEmptyString() {
        return this.enableEmptyString;
    }

    public void setEnableEmptyString(boolean enableEmptyString) {
        this.enableEmptyString = enableEmptyString;
    }

    @ConfigurationProperty(order=-5, displayMessageKey="RETHROW_ALL_SQLEXCEPTIONS_DISPLAY", helpMessageKey="RETHROW_ALL_SQLEXCEPTIONS_HELP")
    public boolean isRethrowAllSQLExceptions() {
        return this.rethrowAllSQLExceptions;
    }

    public void setRethrowAllSQLExceptions(boolean rethrowAllSQLExceptions) {
        this.rethrowAllSQLExceptions = rethrowAllSQLExceptions;
    }

    @ConfigurationProperty(order=-4, displayMessageKey="NATIVE_TIMESTAMPS_DISPLAY", helpMessageKey="NATIVE_TIMESTAMPS_HELP")
    public boolean isNativeTimestamps() {
        return this.nativeTimestamps;
    }

    public void setNativeTimestamps(boolean nativeTimestamps) {
        this.nativeTimestamps = nativeTimestamps;
    }

    @ConfigurationProperty(order=-3, displayMessageKey="ALL_NATIVE_DISPLAY", helpMessageKey="ALL_NATIVE_HELP")
    public boolean isAllNative() {
        return this.allNative;
    }

    public void setAllNative(boolean allNative) {
        this.allNative = allNative;
    }

    @ConfigurationProperty(order=-2, displayMessageKey="VALID_CONNECTION_QUERY_DISPLAY", helpMessageKey="VALID_CONNECTION_QUERY_HELP")
    public String getValidConnectionQuery() {
        return this.validConnectionQuery;
    }

    public void setValidConnectionQuery(String value) {
        this.validConnectionQuery = value;
    }

    @ConfigurationProperty(order=-1, displayMessageKey="DATASOURCE_DISPLAY", helpMessageKey="DATASOURCE_HELP")
    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String value) {
        this.datasource = value;
    }

    @ConfigurationProperty(order=0, displayMessageKey="JNDI_PROPERTIES_DISPLAY", helpMessageKey="JNDI_PROPERTIES_HELP")
    public String[] getJndiProperties() {
        return this.jndiProperties;
    }

    public void setJndiProperties(String[] value) {
        this.jndiProperties = value;
    }

    public void validate() {
        LOG.info("Validate " + ((Object)((Object)this)).getClass().getName(), new Object[0]);
        if (StringUtil.isBlank((String)this.getJdbcUrlTemplate())) {
            throw new IllegalArgumentException(this.getMessage("jdbc.template.blank"));
        }
        if (StringUtil.isBlank((String)this.getDatasource())) {
            LOG.info("Validate driver configuration.", new Object[0]);
            if (this.getUser() == null) {
                throw new IllegalArgumentException(this.getMessage("admin.user.blank"));
            }
            if (this.getPassword() == null) {
                throw new IllegalArgumentException(this.getMessage("admin.password.blank"));
            }
            if (this.getJdbcUrlTemplate().contains("%h") && StringUtil.isBlank((String)this.getHost())) {
                throw new IllegalArgumentException(this.getMessage("host.blank"));
            }
            if (this.getJdbcUrlTemplate().contains("%p") && StringUtil.isBlank((String)this.getPort())) {
                throw new IllegalArgumentException(this.getMessage("port.blank"));
            }
            if (this.getJdbcUrlTemplate().contains("%d") && StringUtil.isBlank((String)this.getDatabase())) {
                throw new IllegalArgumentException(this.getMessage("database.blank"));
            }
            if (StringUtil.isBlank((String)this.getJdbcDriver())) {
                throw new IllegalArgumentException(this.getMessage("jdbc.driver.blank"));
            }
            try {
                Class.forName(this.getJdbcDriver());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(this.getMessage("jdbc.driver.not.found"));
            }
            LOG.ok("driver configuration is ok", new Object[0]);
        } else {
            LOG.info("Validate datasource configuration", new Object[0]);
            JNDIUtil.arrayToProperties((String[])this.getJndiProperties(), (ConnectorMessages)this.getConnectorMessages());
            LOG.ok("datasource configuration is ok", new Object[0]);
        }
        super.validate();
        LOG.ok("Configuration is valid", new Object[0]);
    }

    public String formatUrlTemplate() {
        LOG.info("format UrlTemplate", new Object[0]);
        StringBuilder b = new StringBuilder();
        String url = this.getJdbcUrlTemplate();
        int len = url.length();
        block6: for (int i = 0; i < len; ++i) {
            char ch = url.charAt(i);
            if (ch != '%') {
                b.append(ch);
                continue;
            }
            if (i + 1 >= len) continue;
            ch = url.charAt(++i);
            switch (ch) {
                case '%': {
                    b.append(ch);
                    continue block6;
                }
                case 'h': {
                    b.append(this.getHost());
                    continue block6;
                }
                case 'p': {
                    b.append(this.getPort());
                    continue block6;
                }
                case 'd': {
                    b.append(this.getDatabase());
                    continue block6;
                }
            }
        }
        String formattedURL = b.toString();
        LOG.ok("UrlTemplate is formated to {0}", new Object[]{formattedURL});
        return formattedURL;
    }

    public String getMessage(String key) {
        String fmt = this.getConnectorMessages().format(key, key, new Object[0]);
        LOG.ok("Get for a key {0} connector message {1}", new Object[]{key, fmt});
        return fmt;
    }
}

