/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;

public class GroovyConsentActivationStrategy
implements ConsentActivationStrategy,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyConsentActivationStrategy.class);
    private final ConsentEngine consentEngine;
    private final CasConfigurationProperties casProperties;
    private final transient WatchableGroovyScriptResource watchableScript;

    public GroovyConsentActivationStrategy(Resource groovyResource, ConsentEngine consentEngine, CasConfigurationProperties casProperties) {
        this.watchableScript = new WatchableGroovyScriptResource(groovyResource);
        this.consentEngine = consentEngine;
        this.casProperties = casProperties;
    }

    public boolean isConsentRequired(Service service, RegisteredService registeredService, Authentication authentication, HttpServletRequest requestContext) {
        Object[] args = new Object[]{this.consentEngine, this.casProperties, service, registeredService, authentication, requestContext, LOGGER};
        return (Boolean)this.watchableScript.execute(args, Boolean.class);
    }

    public void destroy() {
        this.watchableScript.close();
    }

    @Generated
    public GroovyConsentActivationStrategy(ConsentEngine consentEngine, CasConfigurationProperties casProperties, WatchableGroovyScriptResource watchableScript) {
        this.consentEngine = consentEngine;
        this.casProperties = casProperties;
        this.watchableScript = watchableScript;
    }
}

