/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

class FetchCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "FETCH";
    public static final String ARGS = "<message-set> <fetch-profile>";
    private static final Flags FLAGS_SEEN = new Flags(Flags.Flag.SEEN);
    private static final Pattern NUMBER_MATCHER = Pattern.compile("^\\d+$");
    private final FetchCommandParser fetchParser = new FetchCommandParser();

    FetchCommand() {
        super(NAME, ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        long lastMessageUid;
        long[] uids;
        IdRange[] idSet = this.fetchParser.parseIdRange(request);
        FetchRequest fetch = this.fetchParser.fetchRequest(request);
        this.fetchParser.endLine(request);
        if (useUids) {
            fetch.uid = true;
        }
        ImapSessionFolder mailbox = session.getSelected();
        for (long uid : uids = mailbox.getMessageUids()) {
            int msn = mailbox.getMsn(uid);
            if ((!useUids || !this.includes(idSet, uid)) && (useUids || !this.includes(idSet, msn))) continue;
            String msgData = this.getMessageData(useUids, fetch, mailbox, uid);
            response.fetchResponse(msn, msgData);
        }
        long l = lastMessageUid = uids.length > 0 ? uids[uids.length - 1] : -1L;
        if (mailbox.getMessageCount() > 0 && this.includes(idSet, Long.MAX_VALUE) && !this.includes(idSet, lastMessageUid)) {
            String msgData = this.getMessageData(useUids, fetch, mailbox, lastMessageUid);
            response.fetchResponse(mailbox.getMsn(lastMessageUid), msgData);
        }
        boolean omitExpunged = !useUids;
        session.unsolicitedResponses(response, omitExpunged);
        response.commandComplete(this);
    }

    private String getMessageData(boolean useUids, FetchRequest fetch, ImapSessionFolder mailbox, long uid) throws FolderException {
        StoredMessage storedMessage = mailbox.getMessage(uid);
        return this.outputMessage(fetch, storedMessage, mailbox, useUids);
    }

    private String outputMessage(FetchRequest fetch, StoredMessage message, ImapSessionFolder folder, boolean useUids) throws FolderException {
        boolean ensureFlagsResponse = false;
        if (fetch.isSetSeen() && !message.isSet(Flags.Flag.SEEN)) {
            folder.setFlags(FLAGS_SEEN, true, message.getUid(), folder, useUids);
            message.setFlags(FLAGS_SEEN, true);
            ensureFlagsResponse = true;
        }
        StringBuilder response = new StringBuilder();
        if (fetch.flags || ensureFlagsResponse) {
            response.append(" FLAGS ");
            response.append(MessageFlags.format(message.getFlags()));
        }
        if (fetch.internalDate) {
            response.append(" INTERNALDATE \"");
            response.append(message.getAttributes().getReceivedDateAsString());
            response.append('\"');
        }
        if (fetch.size) {
            response.append(" RFC822.SIZE ");
            response.append(message.getAttributes().getSize());
        }
        if (fetch.envelope) {
            response.append(" ENVELOPE ");
            response.append(message.getAttributes().getEnvelope());
        }
        if (fetch.body) {
            response.append(" BODY ");
            response.append(message.getAttributes().getBodyStructure(false));
        }
        if (fetch.bodyStructure) {
            response.append(" BODYSTRUCTURE ");
            response.append(message.getAttributes().getBodyStructure(true));
        }
        if (fetch.uid) {
            response.append(" UID ");
            response.append(message.getUid());
        }
        Collection<BodyFetchElement> elements = fetch.getBodyElements();
        for (BodyFetchElement fetchElement : elements) {
            response.append(" ");
            response.append(fetchElement.getResponseName());
            Partial partial = fetchElement.getPartial();
            if (null == partial) {
                response.append(" ");
            }
            String sectionSpecifier = fetchElement.getParameters();
            MimeMessage mimeMessage = message.getMimeMessage();
            try {
                this.handleBodyFetch(mimeMessage, sectionSpecifier, partial, response);
            }
            catch (Exception e) {
                throw new FolderException(e);
            }
        }
        if (response.length() > 0) {
            return response.substring(1);
        }
        return "";
    }

    private void handleBodyFetch(MimeMessage mimeMessage, String sectionSpecifier, Partial partial, StringBuilder response) throws IOException, MessagingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Fetching body part for section specifier {} and mime message (contentType={})", (Object)sectionSpecifier, (Object)mimeMessage.getContentType());
        }
        if (sectionSpecifier.length() == 0) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)bout);
            byte[] bytes = bout.toByteArray();
            bytes = this.doPartial(partial, bytes, response);
            this.addLiteral(bytes, response);
        } else if ("HEADER".equalsIgnoreCase(sectionSpecifier)) {
            Enumeration inum = mimeMessage.getAllHeaderLines();
            this.addHeaders(inum, response, partial);
        } else if (sectionSpecifier.startsWith("HEADER.FIELDS.NOT")) {
            String[] excludeNames = this.extractHeaderList(sectionSpecifier, "HEADER.FIELDS.NOT".length());
            Enumeration inum = mimeMessage.getNonMatchingHeaderLines(excludeNames);
            this.addHeaders(inum, response, partial);
        } else if (sectionSpecifier.startsWith("HEADER.FIELDS ")) {
            String[] includeNames = this.extractHeaderList(sectionSpecifier, "HEADER.FIELDS ".length());
            Enumeration inum = mimeMessage.getMatchingHeaderLines(includeNames);
            this.addHeaders(inum, response, partial);
        } else if (sectionSpecifier.endsWith("MIME")) {
            String[] strs = sectionSpecifier.trim().split("\\.");
            int partNumber = Integer.parseInt(strs[0]) - 1;
            MimeMultipart mp = (MimeMultipart)mimeMessage.getContent();
            byte[] bytes = GreenMailUtil.getHeaderAsBytes((Part)mp.getBodyPart(partNumber));
            bytes = this.doPartial(partial, bytes, response);
            this.addLiteral(bytes, response);
        } else if ("TEXT".equalsIgnoreCase(sectionSpecifier)) {
            this.handleBodyFetchForText(mimeMessage, partial, response);
        } else {
            Object content = mimeMessage.getContent();
            if (content instanceof String) {
                this.handleBodyFetchForText(mimeMessage, partial, response);
            } else {
                String pre;
                MimeMultipart mp = (MimeMultipart)content;
                BodyPart part = null;
                String spec = sectionSpecifier;
                int dotIdx = spec.indexOf(46);
                String string = pre = dotIdx < 0 ? spec : spec.substring(0, dotIdx);
                while (null != pre && NUMBER_MATCHER.matcher(pre).matches()) {
                    int partNumber = Integer.parseInt(pre) - 1;
                    part = null == part ? mp.getBodyPart(partNumber) : ((Multipart)part.getContent()).getBodyPart(partNumber);
                    dotIdx = spec.indexOf(46);
                    if (dotIdx > 0) {
                        spec = spec.substring(dotIdx + 1);
                        pre = spec.substring(0, dotIdx);
                        continue;
                    }
                    pre = null;
                }
                if (null == part) {
                    throw new IllegalStateException("Got null for " + sectionSpecifier);
                }
                if ("message/rfc822".equalsIgnoreCase(part.getContentType())) {
                    this.handleBodyFetch((MimeMessage)part.getContent(), spec, partial, response);
                } else if ("TEXT".equalsIgnoreCase(spec)) {
                    this.handleBodyFetchForText(mimeMessage, partial, response);
                } else {
                    byte[] bytes = GreenMailUtil.getBodyAsBytes(part);
                    bytes = this.doPartial(partial, bytes, response);
                    this.addLiteral(bytes, response);
                }
            }
        }
    }

    private void handleBodyFetchForText(MimeMessage mimeMessage, Partial partial, StringBuilder response) {
        byte[] bytes = GreenMailUtil.getBodyAsBytes((Part)mimeMessage);
        bytes = this.doPartial(partial, bytes, response);
        this.addLiteral(bytes, response);
    }

    private byte[] doPartial(Partial partial, byte[] bytes, StringBuilder response) {
        if (null != partial) {
            int len = partial.computeLength(bytes.length);
            int start = partial.computeStart(bytes.length);
            byte[] newBytes = new byte[len];
            System.arraycopy(bytes, start, newBytes, 0, len);
            bytes = newBytes;
            response.append('<').append(partial.start).append('>');
        }
        return bytes;
    }

    private void addLiteral(byte[] bytes, StringBuilder response) {
        response.append('{');
        response.append(bytes.length);
        response.append('}');
        response.append("\r\n");
        for (byte b : bytes) {
            char c = (char)(b & 0xFF);
            response.append(c);
        }
    }

    private String[] extractHeaderList(String headerList, int prefixLen) {
        String tmp = headerList.substring(prefixLen + 1, headerList.length() - 1);
        return this.split(tmp, " ");
    }

    private String[] split(String value, String delimiter) {
        String sub;
        int delimPos;
        ArrayList<String> strings = new ArrayList<String>();
        int startPos = 0;
        while ((delimPos = value.indexOf(delimiter, startPos)) != -1) {
            sub = value.substring(startPos, delimPos);
            strings.add(sub);
            startPos = delimPos + 1;
        }
        sub = value.substring(startPos);
        strings.add(sub);
        return strings.toArray(new String[0]);
    }

    private void addHeaders(Enumeration<?> inum, StringBuilder response, Partial partial) {
        StringBuilder buf = new StringBuilder();
        int count = 0;
        while (inum.hasMoreElements()) {
            String line = (String)inum.nextElement();
            count += line.length() + 2;
            buf.append(line).append("\r\n");
        }
        if (null != partial) {
            String partialContent = buf.toString();
            int len = partial.computeLength(partialContent.length());
            int start = partial.computeStart(partialContent.length());
            response.append('<').append(partial.start).append('>');
            response.append(" {");
            response.append(len);
            response.append('}');
            response.append("\r\n");
            response.append(partialContent, start, start + len);
        } else {
            response.append("{");
            response.append(count);
            response.append('}');
            response.append("\r\n");
            response.append((CharSequence)buf);
        }
    }

    private static class BodyFetchElement {
        private final String name;
        private final String sectionIdentifier;
        private final Partial partial;

        public BodyFetchElement(String name, String sectionIdentifier) {
            this(name, sectionIdentifier, null);
        }

        public BodyFetchElement(String name, String sectionIdentifier, Partial partial) {
            this.name = name;
            this.sectionIdentifier = sectionIdentifier;
            this.partial = partial;
        }

        public String getParameters() {
            return this.sectionIdentifier;
        }

        public String getResponseName() {
            return this.name;
        }

        public Partial getPartial() {
            return this.partial;
        }
    }

    private static class Partial {
        int start;
        int size;

        private Partial() {
        }

        int computeLength(int contentSize) {
            if (this.size > 0) {
                return Math.min(this.size, contentSize - this.start);
            }
            return contentSize;
        }

        int computeStart(int contentSize) {
            return Math.min(this.start, contentSize);
        }

        public static Partial as(int start, int size) {
            Partial p = new Partial();
            p.start = start;
            p.size = size;
            return p;
        }
    }

    private static class FetchRequest {
        boolean flags;
        boolean uid;
        boolean internalDate;
        boolean size;
        boolean envelope;
        boolean body;
        boolean bodyStructure;
        private boolean setSeen = false;
        private final Set<BodyFetchElement> bodyElements = new HashSet<BodyFetchElement>();

        private FetchRequest() {
        }

        public Collection<BodyFetchElement> getBodyElements() {
            return this.bodyElements;
        }

        public boolean isSetSeen() {
            return this.setSeen;
        }

        public void add(BodyFetchElement element, boolean peek) {
            if (!peek) {
                this.setSeen = true;
            }
            this.bodyElements.add(element);
        }
    }

    private static class FetchCommandParser
    extends CommandParser {
        private FetchCommandParser() {
        }

        FetchRequest fetchRequest(ImapRequestLineReader request) throws ProtocolException {
            boolean parenthesis;
            FetchRequest fetch = new FetchRequest();
            char next = this.nextNonSpaceChar(request);
            boolean bl = parenthesis = '(' == next;
            if (parenthesis) {
                this.consumeChar(request, '(');
                next = this.nextNonSpaceChar(request);
                while (next != ')') {
                    this.addNextElement(request, fetch);
                    next = this.nextNonSpaceChar(request);
                }
                this.consumeChar(request, ')');
            } else {
                this.addNextElement(request, fetch);
            }
            return fetch;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addNextElement(ImapRequestLineReader command, FetchRequest fetch) throws ProtocolException {
            char next = this.nextCharInLine(command);
            StringBuilder element = new StringBuilder();
            while (next != ' ' && next != '[' && next != ')' && !FetchCommandParser.isCrOrLf(next)) {
                element.append(next);
                command.consume();
                next = command.nextChar();
            }
            String name = element.toString();
            if (next == ' ' || next == ')' || FetchCommandParser.isCrOrLf(next)) {
                if ("FAST".equalsIgnoreCase(name)) {
                    fetch.flags = true;
                    fetch.internalDate = true;
                    fetch.size = true;
                    return;
                } else if ("FULL".equalsIgnoreCase(name)) {
                    fetch.flags = true;
                    fetch.internalDate = true;
                    fetch.size = true;
                    fetch.envelope = true;
                    fetch.body = true;
                    return;
                } else if ("ALL".equalsIgnoreCase(name)) {
                    fetch.flags = true;
                    fetch.internalDate = true;
                    fetch.size = true;
                    fetch.envelope = true;
                    return;
                } else if ("FLAGS".equalsIgnoreCase(name)) {
                    fetch.flags = true;
                    return;
                } else if ("RFC822.SIZE".equalsIgnoreCase(name)) {
                    fetch.size = true;
                    return;
                } else if ("ENVELOPE".equalsIgnoreCase(name)) {
                    fetch.envelope = true;
                    return;
                } else if ("INTERNALDATE".equalsIgnoreCase(name)) {
                    fetch.internalDate = true;
                    return;
                } else if ("BODY".equalsIgnoreCase(name)) {
                    fetch.body = true;
                    return;
                } else if ("BODYSTRUCTURE".equalsIgnoreCase(name)) {
                    fetch.bodyStructure = true;
                    return;
                } else if ("UID".equalsIgnoreCase(name)) {
                    fetch.uid = true;
                    return;
                } else if ("RFC822".equalsIgnoreCase(name)) {
                    fetch.add(new BodyFetchElement("RFC822", ""), false);
                    return;
                } else if ("RFC822.HEADER".equalsIgnoreCase(name)) {
                    fetch.add(new BodyFetchElement("RFC822.HEADER", "HEADER"), true);
                    return;
                } else {
                    if (!"RFC822.TEXT".equalsIgnoreCase(name)) throw new ProtocolException("Invalid fetch attribute: " + name);
                    fetch.add(new BodyFetchElement("RFC822.TEXT", "TEXT"), false);
                }
                return;
            } else {
                this.consumeChar(command, '[');
                StringBuilder sectionIdentifier = new StringBuilder();
                next = this.nextCharInLine(command);
                while (next != ']') {
                    sectionIdentifier.append(next);
                    command.consume();
                    next = this.nextCharInLine(command);
                }
                this.consumeChar(command, ']');
                String parameter = sectionIdentifier.toString();
                Partial partial = null;
                next = command.nextChar();
                if ('<' == next) {
                    partial = this.parsePartial(command);
                }
                if ("BODY".equalsIgnoreCase(name)) {
                    fetch.add(new BodyFetchElement("BODY[" + parameter + ']', parameter, partial), false);
                    return;
                } else {
                    if (!"BODY.PEEK".equalsIgnoreCase(name)) throw new ProtocolException("Invalid fetch attribute: " + name + "[]");
                    fetch.add(new BodyFetchElement("BODY[" + parameter + ']', parameter, partial), true);
                }
            }
        }

        private Partial parsePartial(ImapRequestLineReader command) throws ProtocolException {
            this.consumeChar(command, '<');
            int size = (int)this.consumeLong(command);
            int start = 0;
            if (command.nextChar() == '.') {
                this.consumeChar(command, '.');
                start = size;
                size = (int)this.consumeLong(command);
            }
            this.consumeChar(command, '>');
            return Partial.as(start, size);
        }

        private char nextCharInLine(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextChar();
            if (FetchCommandParser.isCrOrLf(next)) {
                throw new ProtocolException("Unexpected end of line (CR or LF).");
            }
            return next;
        }

        private char nextNonSpaceChar(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextChar();
            while (next == ' ') {
                request.consume();
                next = request.nextChar();
            }
            return next;
        }
    }
}

