/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineLoggingBuffer {
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private final String linePrefix;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final byte[] WRAP = "[WRAP]".getBytes(StandardCharsets.US_ASCII);

    public LineLoggingBuffer(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public void append(int b) {
        if (b > 0) {
            if (b == 10) {
                this.buf.write(92);
                this.buf.write(110);
            } else if (b == 13) {
                this.buf.write(92);
                this.buf.write(114);
            } else if (b == 9) {
                this.buf.write(92);
                this.buf.write(116);
            } else if (b < 32) {
                this.buf.write(94);
                this.buf.write(64 + b);
            } else {
                this.buf.write(b);
            }
        }
        if (b < 0 || b == 10 || this.isLineLengthExceeded()) {
            this.logLine();
        }
    }

    public void logLine() {
        if (this.buf.size() > 0) {
            try {
                if (this.isLineLengthExceeded()) {
                    this.buf.write(WRAP);
                }
                String line = this.buf.toString(StandardCharsets.UTF_8.name());
                this.log.debug(this.linePrefix + line);
                this.buf.reset();
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not log output stream", e);
            }
        }
    }

    protected boolean isLineLengthExceeded() {
        return this.buf.size() > 128;
    }
}

