/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction.sortable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.ListUtils;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.interaction.sortable.ISortableListener;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public abstract class SortableBehavior<T>
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "sortable";
    private final ISortableListener<T> listener;
    private JQueryAjaxBehavior onUpdateAjaxBehavior;
    private JQueryAjaxBehavior onReceiveAjaxBehavior = null;
    private JQueryAjaxBehavior onRemoveAjaxBehavior = null;

    public SortableBehavior(String selector, ISortableListener<T> listener) {
        this(selector, new Options(), listener);
    }

    public SortableBehavior(String selector, Options options, ISortableListener<T> listener) {
        super(selector, METHOD, options);
        this.listener = (ISortableListener)Args.notNull(listener, (String)"listener");
    }

    protected abstract List<T> getItemList();

    protected List<T> getConnectedList() {
        return Collections.emptyList();
    }

    public boolean isEnabled(Component component) {
        return component.isEnabledInHierarchy();
    }

    public void bind(Component component) {
        super.bind(component);
        this.onUpdateAjaxBehavior = this.newOnUpdateAjaxBehavior(this);
        component.add(new Behavior[]{this.onUpdateAjaxBehavior});
        if (this.listener.isOnReceiveEnabled()) {
            this.onReceiveAjaxBehavior = this.newOnReceiveAjaxBehavior(this);
            component.add(new Behavior[]{this.onReceiveAjaxBehavior});
        }
        if (this.listener.isOnRemoveEnabled()) {
            this.onRemoveAjaxBehavior = this.newOnRemoveAjaxBehavior(this);
            component.add(new Behavior[]{this.onRemoveAjaxBehavior});
        }
    }

    protected T findItem(String id, List<T> list) {
        return (T)ListUtils.fromHash((int)Integer.parseInt(id), list);
    }

    @Override
    public void onConfigure(Component component) {
        if (this.isEnabled(component)) {
            this.setOption("update", this.onUpdateAjaxBehavior.getCallbackFunction());
            if (this.onReceiveAjaxBehavior != null) {
                this.setOption("receive", this.onReceiveAjaxBehavior.getCallbackFunction());
            }
            if (this.onRemoveAjaxBehavior != null) {
                this.setOption("remove", this.onRemoveAjaxBehavior.getCallbackFunction());
            }
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SortableEvent) {
            List<T> list;
            SortableEvent ev = (SortableEvent)event;
            String hash = ev.getHash();
            int index = ev.getIndex();
            if (event instanceof UpdateEvent && (list = this.getItemList()) != null) {
                this.listener.onUpdate(target, this.findItem(hash, list), index);
            }
            if (event instanceof ReceiveEvent && !(list = this.getConnectedList()).isEmpty()) {
                this.listener.onReceive(target, this.findItem(hash, list), index);
            }
            if (event instanceof RemoveEvent && (list = this.getItemList()) != null) {
                this.listener.onRemove(target, this.findItem(hash, list));
            }
        }
    }

    protected JQueryAjaxBehavior newOnUpdateAjaxBehavior(IJQueryAjaxAware source) {
        return new OnUpdateAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnReceiveAjaxBehavior(IJQueryAjaxAware source) {
        return new OnReceiveAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnRemoveAjaxBehavior(IJQueryAjaxAware source) {
        return new OnRemoveAjaxBehavior(source);
    }

    protected static class RemoveEvent
    extends SortableEvent {
        protected RemoveEvent() {
        }
    }

    protected static class ReceiveEvent
    extends SortableEvent {
        protected ReceiveEvent() {
        }
    }

    protected static class UpdateEvent
    extends SortableEvent {
        protected UpdateEvent() {
        }
    }

    protected static class SortableEvent
    extends JQueryEvent {
        private final String hash = RequestCycleUtils.getQueryParameterValue((String)"hash").toString();
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(-1);

        public String getHash() {
            return this.hash;
        }

        public int getIndex() {
            return this.index;
        }
    }

    protected static class OnRemoveAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnRemoveAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"hash", (String)"ui.item.data('hash')")};
        }

        protected JQueryEvent newEvent() {
            return new RemoveEvent();
        }
    }

    protected static class OnReceiveAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnReceiveAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"hash", (String)"ui.item.data('hash')"), CallbackParameter.resolved((String)"index", (String)"ui.item.index()")};
        }

        protected JQueryEvent newEvent() {
            return new ReceiveEvent();
        }
    }

    protected static class OnUpdateAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnUpdateAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"hash", (String)"ui.item.data('hash')"), CallbackParameter.resolved((String)"index", (String)"ui.item.index()")};
        }

        protected JQueryEvent newEvent() {
            return new UpdateEvent();
        }
    }
}

