/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Activatable;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class BootstrapBookmarkablePageLink<T>
extends BookmarkablePageLink<T>
implements IBootstrapButton<BootstrapBookmarkablePageLink<T>>,
Activatable {
    private static final long serialVersionUID = 1L;
    private Component label;
    private Icon icon;
    private ButtonBehavior buttonBehavior;
    private Component splitter;
    private final Buttons.Type type;

    public <P extends Page> BootstrapBookmarkablePageLink(String componentId, Class<P> pageClass, Buttons.Type type) {
        this(componentId, pageClass, new PageParameters(), type);
    }

    public <P extends Page> BootstrapBookmarkablePageLink(String componentId, Class<P> pageClass, PageParameters parameters, Buttons.Type type) {
        super(componentId, pageClass, parameters);
        this.type = type;
        this.add(new Behavior[]{this.getButtonBehavior()});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.getIcon(), this.getSplitter(), this.getPageLabel()});
    }

    private ButtonBehavior getButtonBehavior() {
        if (this.buttonBehavior == null) {
            this.buttonBehavior = new ButtonBehavior(this.type, Buttons.Size.Medium);
        }
        return this.buttonBehavior;
    }

    private Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.newIcon("icon");
        }
        return this.icon;
    }

    private Component getSplitter() {
        if (this.splitter == null) {
            this.splitter = this.newSplitter("splitter");
        }
        return this.splitter;
    }

    private Component getPageLabel() {
        if (this.label == null) {
            this.label = this.newLabel("label");
        }
        return this.label;
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected Component newLabel(String markupId) {
        return new Label(markupId, (IModel)new Model((Serializable)((Object)""))).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false);
    }

    protected final IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    @Override
    public BootstrapBookmarkablePageLink<T> setSize(Buttons.Size size) {
        this.getButtonBehavior().setSize(size);
        return this;
    }

    @Override
    public BootstrapBookmarkablePageLink<T> setType(Buttons.Type type) {
        this.getButtonBehavior().setType(type);
        return this;
    }

    public BootstrapBookmarkablePageLink<T> setLabel(IModel<?> label) {
        this.getPageLabel().setDefaultModel(label);
        return this;
    }

    public BootstrapBookmarkablePageLink<T> setIconType(IconType iconType) {
        this.getIcon().setType(iconType);
        return this;
    }

    public BootstrapBookmarkablePageLink<T> setBlock(boolean block) {
        this.getButtonBehavior().setBlock(block);
        return this;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.getSplitter().setVisible(this.getIcon().hasIconType() && !Strings.isEmpty((CharSequence)this.getPageLabel().getDefaultModelObjectAsString()));
    }

    @Override
    public boolean isActive(Component button) {
        Args.notNull((Object)button, (String)"button");
        return button.getPage().getClass().equals(this.getPageClass());
    }
}

