/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import javax.persistence.CascadeType;
import javax.persistence.GenerationType;
import javax.persistence.LockModeType;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.BeanLifecycleCallbacks;
import org.apache.openjpa.event.LifecycleCallbacks;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.MethodLifecycleCallbacks;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.CFMetaDataParser;
import org.apache.openjpa.lib.meta.XMLVersionParser;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.AbstractCFMetaDataFactory;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.DelegatingMetaDataFactory;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.LifecycleMetaData;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.meta.MetaDataDefaults;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.AnnotationPersistenceMetaDataParser;
import org.apache.openjpa.persistence.MetaDataParsers;
import org.apache.openjpa.persistence.MetaDataTag;
import org.apache.openjpa.persistence.PersistenceListenerAdapter;
import org.apache.openjpa.persistence.PersistenceMetaDataDefaults;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.persistence.PersistenceStrategy;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLPersistenceMetaDataParser
extends CFMetaDataParser
implements AbstractCFMetaDataFactory.Parser {
    protected static final String ELEM_PKG = "package";
    protected static final String ELEM_ACCESS = "access";
    protected static final String ELEM_ATTRS = "attributes";
    protected static final String ELEM_LISTENER = "entity-listener";
    protected static final String ELEM_CASCADE = "cascade";
    protected static final String ELEM_CASCADE_ALL = "cascade-all";
    protected static final String ELEM_CASCADE_PER = "cascade-persist";
    protected static final String ELEM_CASCADE_MER = "cascade-merge";
    protected static final String ELEM_CASCADE_REM = "cascade-remove";
    protected static final String ELEM_CASCADE_REF = "cascade-refresh";
    protected static final String ELEM_CASCADE_DET = "cascade-detach";
    protected static final String ELEM_PU_META = "persistence-unit-metadata";
    protected static final String ELEM_PU_DEF = "persistence-unit-defaults";
    protected static final String ELEM_XML_MAP_META_COMPLETE = "xml-mapping-metadata-complete";
    protected static final String ELEM_DELIM_IDS = "delimited-identifiers";
    private static final Map<String, Object> _elems = new HashMap<String, Object>();
    private static final Map<Class<?>, ArrayList<MetaDataContext>> _embeddables = new HashMap();
    private static final Map<Class<?>, Integer> _embeddableAccess = new HashMap();
    private AnnotationPersistenceMetaDataParser.FetchGroupImpl[] _fgs = null;
    private List<AnnotationPersistenceMetaDataParser.FetchGroupImpl> _fgList = null;
    private List<String> _referencedFgList = null;
    private AnnotationPersistenceMetaDataParser.FetchGroupImpl _currentFg = null;
    private List<AnnotationPersistenceMetaDataParser.FetchAttributeImpl> _fetchAttrList = null;
    private static final Localizer _loc;
    private final OpenJPAConfiguration _conf;
    private MetaDataRepository _repos = null;
    private AnnotationPersistenceMetaDataParser _parser = null;
    private ClassLoader _envLoader = null;
    private int _mode = 0;
    private boolean _override = false;
    private final Stack<Object> _elements = new Stack();
    private final Stack<Object> _parents = new Stack();
    private StringBuffer _externalValues = null;
    protected Class<?> _cls = null;
    private ArrayList<Class<?>> _parseList = new ArrayList();
    private int _fieldPos = 0;
    private int _clsPos = 0;
    private int _access = AccessCode.UNKNOWN;
    private PersistenceStrategy _strategy = null;
    private Set<CascadeType> _cascades = null;
    private Set<CascadeType> _pkgCascades = null;
    private Class<?> _listener = null;
    private Collection<LifecycleCallbacks>[] _callbacks = null;
    private Collection<Class<?>> _listeners = null;
    private int[] _highs = null;
    private boolean _isXMLMappingMetaDataComplete = false;
    private String _ormVersion;
    private String _schemaLocation;
    private static final String ORM_XSD_1_0 = "orm_1_0.xsd";
    private static final String ORM_XSD_2_0 = "orm_2_0.xsd";
    private static final String ORM_XSD_2_1 = "orm_2_1.xsd";
    private static final String ORM_XSD_2_2 = "orm_2_2.xsd";

    public XMLPersistenceMetaDataParser(OpenJPAConfiguration conf) {
        this._conf = conf;
        this.setValidating(true);
        this.setLog(conf.getLog("openjpa.MetaData"));
        this.setParseComments(true);
        this.setMode(7);
        this.setParseText(true);
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public AnnotationPersistenceMetaDataParser getAnnotationParser() {
        return this._parser;
    }

    public void setAnnotationParser(AnnotationPersistenceMetaDataParser parser) {
        this._parser = parser;
    }

    public MetaDataRepository getRepository() {
        if (this._repos == null) {
            MetaDataRepository repos = this._conf.newMetaDataRepositoryInstance();
            MetaDataFactory mdf = repos.getMetaDataFactory();
            if (mdf instanceof DelegatingMetaDataFactory) {
                mdf = ((DelegatingMetaDataFactory)mdf).getInnermostDelegate();
            }
            if (mdf instanceof PersistenceMetaDataFactory) {
                ((PersistenceMetaDataFactory)mdf).setXMLParser(this);
            }
            this._repos = repos;
        }
        return this._repos;
    }

    public void setRepository(MetaDataRepository repos) {
        this._repos = repos;
        if (repos != null && (repos.getValidate() & 8) != 0) {
            this.setParseComments(false);
        }
        if (repos != null) {
            this.setOverrideContextClassloader(repos.getConfiguration().getCompatibilityInstance().getOverrideContextClassloader());
        }
    }

    public ClassLoader getEnvClassLoader() {
        return this._envLoader;
    }

    public void setEnvClassLoader(ClassLoader loader) {
        this._envLoader = loader;
    }

    public boolean getMappingOverride() {
        return this._override;
    }

    public void setMappingOverride(boolean override) {
        this._override = override;
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int mode, boolean on) {
        if (mode == 0) {
            this.setMode(0);
        } else if (on) {
            this.setMode(this._mode | mode);
        } else {
            this.setMode(this._mode & ~mode);
        }
    }

    public void setMode(int mode) {
        this._mode = mode;
        if (this._parser != null) {
            this._parser.setMode(mode);
        }
    }

    public void parse(URL url) throws IOException {
        block2: {
            XMLVersionParser vp = new XMLVersionParser("entity-mappings");
            try {
                vp.parse(url);
                this._ormVersion = vp.getVersion();
                this._schemaLocation = vp.getSchemaLocation();
            }
            catch (Throwable t) {
                Log log = this.getLog();
                if (!log.isInfoEnabled()) break block2;
                log.trace((Object)_loc.get("version-check-error", (Object)url.toString()));
            }
        }
        super.parse(url);
    }

    public void parse(File file) throws IOException {
        block2: {
            XMLVersionParser vp = new XMLVersionParser("entity-mappings");
            try {
                vp.parse(file);
                this._ormVersion = vp.getVersion();
                this._schemaLocation = vp.getSchemaLocation();
            }
            catch (Throwable t) {
                Log log = this.getLog();
                if (!log.isInfoEnabled()) break block2;
                log.trace((Object)_loc.get("version-check-error", (Object)file.toString()));
            }
        }
        super.parse(file);
    }

    protected boolean isMetaDataMode() {
        return (this._mode & 1) != 0;
    }

    protected boolean isQueryMode() {
        return (this._mode & 4) != 0;
    }

    protected boolean isMappingMode() {
        return (this._mode & 2) != 0;
    }

    protected boolean isMappingOverrideMode() {
        return this.isMappingMode() || this._override && this.isMetaDataMode();
    }

    protected void pushElement(Object elem) {
        this._elements.push(elem);
    }

    protected Object popElement() {
        return this._elements.pop();
    }

    protected Object peekElement() {
        return this._elements.peek();
    }

    protected Object currentElement() {
        if (this._elements.isEmpty()) {
            return null;
        }
        return this._elements.peek();
    }

    protected PersistenceStrategy currentStrategy() {
        return this._strategy;
    }

    protected Object currentParent() {
        if (this._parents.isEmpty()) {
            return null;
        }
        return this._parents.peek();
    }

    protected boolean isRuntime() {
        return (this.getRepository().getValidate() & 8) != 0;
    }

    protected Object getSchemaSource() {
        String ormxsd = "orm_2_0-xsd.rsrc";
        boolean useExtendedSchema = true;
        if ("1.0".equals(this._ormVersion) || this._schemaLocation != null && this._schemaLocation.indexOf(ORM_XSD_1_0) > -1) {
            ormxsd = "orm-xsd.rsrc";
            useExtendedSchema = false;
        } else if ("2.0".equals(this._ormVersion) || this._schemaLocation != null && this._schemaLocation.indexOf(ORM_XSD_2_0) > -1) {
            ormxsd = "orm_2_0-xsd.rsrc";
        } else if ("2.1".equals(this._ormVersion) || this._schemaLocation != null && this._schemaLocation.indexOf(ORM_XSD_2_1) > -1) {
            ormxsd = "orm_2_1.xsd.rsrc";
        } else if ("2.2".equals(this._ormVersion) || this._schemaLocation != null && this._schemaLocation.indexOf(ORM_XSD_2_2) > -1) {
            ormxsd = "orm_2_2.xsd.rsrc";
        }
        ArrayList<InputStream> schema = new ArrayList<InputStream>();
        schema.add(XMLPersistenceMetaDataParser.class.getResourceAsStream(ormxsd));
        if (useExtendedSchema) {
            InputStream openjpaXSDIS;
            InputStream extendableXSDIS = XMLPersistenceMetaDataParser.class.getResourceAsStream("extendable-orm.xsd");
            if (extendableXSDIS != null) {
                schema.add(extendableXSDIS);
            }
            if ((openjpaXSDIS = XMLPersistenceMetaDataParser.class.getResourceAsStream("openjpa-orm.xsd")) != null) {
                schema.add(openjpaXSDIS);
            }
        }
        return schema.toArray();
    }

    protected String getPackageAttributeName() {
        return null;
    }

    protected String getClassAttributeName() {
        return "class";
    }

    protected int getClassElementDepth() {
        return 1;
    }

    protected boolean isClassElementName(String name) {
        return "entity".equals(name) || "embeddable".equals(name) || "mapped-superclass".equals(name);
    }

    protected void reset() {
        this.addDeferredEmbeddableMetaData();
        super.reset();
        this._elements.clear();
        this._parents.clear();
        this._cls = null;
        this._parseList.clear();
        this._fieldPos = 0;
        this._clsPos = 0;
        this._access = AccessCode.UNKNOWN;
        this._strategy = null;
        this._listener = null;
        this._callbacks = null;
        this._highs = null;
        this._cascades = null;
        this._pkgCascades = null;
    }

    protected boolean startSystemElement(String name, Attributes attrs) throws SAXException {
        Object tag = _elems.get(name);
        boolean ret = false;
        if (tag == null) {
            if (this.isMappingOverrideMode()) {
                tag = this.startSystemMappingElement(name, attrs);
            }
            ret = tag != null;
        } else if (tag instanceof MetaDataTag) {
            switch ((MetaDataTag)((Object)tag)) {
                case QUERY: {
                    ret = this.startNamedQuery(attrs);
                    break;
                }
                case QUERY_HINT: {
                    ret = this.startQueryHint(attrs);
                    break;
                }
                case NATIVE_QUERY: {
                    ret = this.startNamedNativeQuery(attrs);
                    break;
                }
                case QUERY_STRING: {
                    ret = this.startQueryString(attrs);
                    break;
                }
                case SEQ_GENERATOR: {
                    ret = this.startSequenceGenerator(attrs);
                    break;
                }
                case FLUSH_MODE: {
                    ret = this.startFlushMode(attrs);
                    break;
                }
                case ENTITY_LISTENERS: {
                    ret = this.startEntityListeners(attrs);
                    break;
                }
                case PRE_PERSIST: 
                case POST_PERSIST: 
                case PRE_REMOVE: 
                case POST_REMOVE: 
                case PRE_UPDATE: 
                case POST_UPDATE: 
                case POST_LOAD: {
                    ret = this.startCallback((MetaDataTag)((Object)tag), attrs);
                    break;
                }
                default: {
                    this.warnUnsupportedTag(name);
                    break;
                }
            }
        } else if (tag == ELEM_PU_META || tag == ELEM_PU_DEF) {
            ret = this.isMetaDataMode();
        } else if (tag == ELEM_XML_MAP_META_COMPLETE) {
            this.setAnnotationParser(null);
            this._isXMLMappingMetaDataComplete = true;
        } else if (tag == ELEM_ACCESS) {
            ret = this._mode != 4;
        } else if (tag == ELEM_LISTENER) {
            ret = this.startEntityListener(attrs);
        } else if (tag == ELEM_DELIM_IDS) {
            ret = this.startDelimitedIdentifiers();
        } else if (tag == ELEM_CASCADE) {
            ret = this.isMetaDataMode();
        } else if (tag == ELEM_CASCADE_ALL || tag == ELEM_CASCADE_PER || tag == ELEM_CASCADE_MER || tag == ELEM_CASCADE_REM || tag == ELEM_CASCADE_REF || tag == ELEM_CASCADE_DET) {
            ret = this.startCascade(tag, attrs);
        }
        if (ret) {
            this._parents.push(tag);
        }
        return ret;
    }

    protected void endSystemElement(String name) throws SAXException {
        Object tag = _elems.get(name);
        if (tag == null && this.isMappingOverrideMode()) {
            this.endSystemMappingElement(name);
        } else if (tag instanceof MetaDataTag) {
            switch ((MetaDataTag)((Object)tag)) {
                case QUERY: {
                    this.endNamedQuery();
                    break;
                }
                case QUERY_HINT: {
                    this.endQueryHint();
                    break;
                }
                case NATIVE_QUERY: {
                    this.endNamedNativeQuery();
                    break;
                }
                case QUERY_STRING: {
                    this.endQueryString();
                    break;
                }
                case SEQ_GENERATOR: {
                    this.endSequenceGenerator();
                }
            }
        } else if (tag == ELEM_ACCESS) {
            this.endAccess();
        } else if (tag == ELEM_LISTENER) {
            this.endEntityListener();
        }
        this._parents.pop();
    }

    protected Object startSystemMappingElement(String name, Attributes attrs) throws SAXException {
        return null;
    }

    protected void endSystemMappingElement(String name) throws SAXException {
    }

    protected boolean startClassElement(String name, Attributes attrs) throws SAXException {
        Object tag = _elems.get(name);
        boolean ret = false;
        if (tag == null) {
            if (this.isMappingOverrideMode()) {
                tag = this.startClassMappingElement(name, attrs);
            }
            ret = tag != null;
        } else if (tag instanceof MetaDataTag) {
            switch ((MetaDataTag)((Object)tag)) {
                case GENERATED_VALUE: {
                    ret = this.startGeneratedValue(attrs);
                    break;
                }
                case ID: {
                    ret = this.startId(attrs);
                    break;
                }
                case EMBEDDED_ID: {
                    ret = this.startEmbeddedId(attrs);
                    break;
                }
                case ID_CLASS: {
                    ret = this.startIdClass(attrs);
                    break;
                }
                case LOB: {
                    ret = this.startLob(attrs);
                    break;
                }
                case QUERY: {
                    ret = this.startNamedQuery(attrs);
                    break;
                }
                case QUERY_HINT: {
                    ret = this.startQueryHint(attrs);
                    break;
                }
                case NATIVE_QUERY: {
                    ret = this.startNamedNativeQuery(attrs);
                    break;
                }
                case QUERY_STRING: {
                    ret = this.startQueryString(attrs);
                    break;
                }
                case SEQ_GENERATOR: {
                    ret = this.startSequenceGenerator(attrs);
                    break;
                }
                case VERSION: {
                    ret = this.startVersion(attrs);
                    break;
                }
                case MAP_KEY: {
                    ret = this.startMapKey(attrs);
                    break;
                }
                case MAP_KEY_CLASS: {
                    ret = this.startMapKeyClass(attrs);
                    break;
                }
                case FLUSH_MODE: {
                    ret = this.startFlushMode(attrs);
                    break;
                }
                case ORDER_COLUMN: {
                    ret = this.startOrderColumn(attrs);
                    break;
                }
                case ENTITY_LISTENERS: 
                case ORDER_BY: {
                    ret = this.isMetaDataMode();
                    break;
                }
                case EXCLUDE_DEFAULT_LISTENERS: {
                    ret = this.startExcludeDefaultListeners(attrs);
                    break;
                }
                case EXCLUDE_SUPERCLASS_LISTENERS: {
                    ret = this.startExcludeSuperclassListeners(attrs);
                    break;
                }
                case PRE_PERSIST: 
                case POST_PERSIST: 
                case PRE_REMOVE: 
                case POST_REMOVE: 
                case PRE_UPDATE: 
                case POST_UPDATE: 
                case POST_LOAD: {
                    ret = this.startCallback((MetaDataTag)((Object)tag), attrs);
                    break;
                }
                case DATASTORE_ID: {
                    ret = this.startDatastoreId(attrs);
                    break;
                }
                case DATA_CACHE: {
                    ret = this.startDataCache(attrs);
                    break;
                }
                case READ_ONLY: {
                    ret = this.startReadOnly(attrs);
                    break;
                }
                case EXTERNAL_VALS: {
                    ret = this.startExternalValues(attrs);
                    break;
                }
                case EXTERNAL_VAL: {
                    ret = this.startExternalValue(attrs);
                    break;
                }
                case EXTERNALIZER: {
                    ret = this.startExternalizer(attrs);
                    break;
                }
                case FACTORY: {
                    ret = this.startFactory(attrs);
                    break;
                }
                case FETCH_GROUPS: {
                    ret = this.startFetchGroups(attrs);
                    break;
                }
                case FETCH_GROUP: {
                    ret = this.startFetchGroup(attrs);
                    break;
                }
                case FETCH_ATTRIBUTE: {
                    ret = this.startFetchAttribute(attrs);
                    break;
                }
                case REFERENCED_FETCH_GROUP: {
                    ret = this.startReferencedFetchGroup(attrs);
                    break;
                }
                case OPENJPA_VERSION: {
                    ret = true;
                    break;
                }
                default: {
                    this.warnUnsupportedTag(name);
                    break;
                }
            }
        } else if (tag instanceof PersistenceStrategy) {
            PersistenceStrategy ps = (PersistenceStrategy)((Object)tag);
            ret = this._openjpaNamespace > 0 ? (ps == PersistenceStrategy.PERS || ps == PersistenceStrategy.PERS_COLL || ps == PersistenceStrategy.PERS_MAP ? this.startStrategy(ps, attrs) : this.startExtendedStrategy(ps, attrs)) : this.startStrategy(ps, attrs);
            if (ret) {
                this._strategy = ps;
            }
        } else if (tag == ELEM_LISTENER) {
            ret = this.startEntityListener(attrs);
        } else if (tag == ELEM_ATTRS) {
            ret = this._mode != 4;
        } else if (tag == ELEM_CASCADE) {
            ret = this.isMetaDataMode();
        } else if (tag == ELEM_CASCADE_ALL || tag == ELEM_CASCADE_PER || tag == ELEM_CASCADE_MER || tag == ELEM_CASCADE_REM || tag == ELEM_CASCADE_REF || tag == ELEM_CASCADE_DET) {
            ret = this.startCascade(tag, attrs);
        }
        if (ret) {
            this._parents.push(tag);
        }
        return ret;
    }

    protected void endClassElement(String name) throws SAXException {
        Object tag = _elems.get(name);
        if (tag == null && this.isMappingOverrideMode()) {
            this.endClassMappingElement(name);
        } else if (tag instanceof MetaDataTag) {
            switch ((MetaDataTag)((Object)tag)) {
                case GENERATED_VALUE: {
                    this.endGeneratedValue();
                    break;
                }
                case ID: {
                    this.endId();
                    break;
                }
                case EMBEDDED_ID: {
                    this.endEmbeddedId();
                    break;
                }
                case ID_CLASS: {
                    this.endIdClass();
                    break;
                }
                case LOB: {
                    this.endLob();
                    break;
                }
                case QUERY: {
                    this.endNamedQuery();
                    break;
                }
                case QUERY_HINT: {
                    this.endQueryHint();
                    break;
                }
                case NATIVE_QUERY: {
                    this.endNamedNativeQuery();
                    break;
                }
                case QUERY_STRING: {
                    this.endQueryString();
                    break;
                }
                case SEQ_GENERATOR: {
                    this.endSequenceGenerator();
                    break;
                }
                case VERSION: {
                    this.endVersion();
                    break;
                }
                case ORDER_BY: {
                    this.endOrderBy();
                    break;
                }
                case EXTERNAL_VALS: {
                    this.endExternalValues();
                    break;
                }
                case EXTERNALIZER: {
                    this.endExternalizer();
                    break;
                }
                case FACTORY: {
                    this.endFactory();
                    break;
                }
                case FETCH_GROUP: {
                    this.endFetchGroup();
                    break;
                }
                case REFERENCED_FETCH_GROUP: {
                    this.endReferencedFetchGroup();
                }
            }
        } else if (tag instanceof PersistenceStrategy) {
            PersistenceStrategy ps = (PersistenceStrategy)((Object)tag);
            if (this._openjpaNamespace > 0) {
                this.endExtendedStrategy(ps);
            } else {
                this.endStrategy(ps);
            }
        } else if (tag == ELEM_ACCESS) {
            this.endAccess();
        } else if (tag == ELEM_LISTENER) {
            this.endEntityListener();
        }
        this._parents.pop();
    }

    private void warnUnsupportedTag(String name) {
        Log log = this.getLog();
        if (log.isInfoEnabled()) {
            log.trace((Object)_loc.get("unsupported-tag", (Object)name));
        }
    }

    protected Object startClassMappingElement(String name, Attributes attrs) throws SAXException {
        return null;
    }

    protected void endClassMappingElement(String name) throws SAXException {
    }

    boolean isMetaDataComplete(Attributes attrs) {
        return attrs != null && "true".equals(attrs.getValue("metadata-complete"));
    }

    void resetAnnotationParser() {
        this.setAnnotationParser(((PersistenceMetaDataFactory)this.getRepository().getMetaDataFactory()).getAnnotationParser());
    }

    protected boolean startClass(String elem, Attributes attrs) throws SAXException {
        MetaDataRepository repos;
        ClassMetaData meta;
        boolean metaDataComplete = false;
        super.startClass(elem, attrs);
        if (this.isMetaDataComplete(attrs)) {
            metaDataComplete = true;
            this.setAnnotationParser(null);
        } else if (!this._isXMLMappingMetaDataComplete) {
            this.resetAnnotationParser();
        }
        this._cls = this.classForName(this.currentClassName());
        if (this.parseListContains(this._cls)) {
            return false;
        }
        if (this._mode == 4) {
            if (this._conf.getCompatibilityInstance().getParseAnnotationsForQueryMode() && this._parser != null) {
                this._parser.parse(this._cls);
            }
            return true;
        }
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)_loc.get("parse-class", (Object)this._cls.getName()));
        }
        if ((meta = (repos = this.getRepository()).getCachedMetaData(this._cls)) != null && (this.isMetaDataMode() && (meta.getSourceMode() & 1) != 0 || this.isMappingMode() && (meta.getSourceMode() & 2) != 0)) {
            if (this.isDuplicateClass(meta)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)_loc.get("dup-metadata", this._cls, (Object)this.getSourceName()));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("MetaData originally obtained from source: %s under mode: %d with scope: %s, and type: %d", meta.getSourceName(), meta.getSourceMode(), meta.getSourceScope(), meta.getSourceType()));
                }
            }
            this._cls = null;
            return false;
        }
        int access = AccessCode.UNKNOWN;
        if (meta == null) {
            int accessCode = this.toAccessType(attrs.getValue(ELEM_ACCESS));
            if (accessCode == AccessCode.UNKNOWN) {
                accessCode = this._access;
            }
            meta = repos.addMetaData(this._cls, accessCode, metaDataComplete);
            FieldMetaData[] fmds = meta.getFields();
            if (metaDataComplete) {
                for (FieldMetaData fmd : fmds) {
                    fmd.setExplicit(true);
                }
            }
            meta.setEnvClassLoader(this._envLoader);
            meta.setSourceMode(0);
            if (this._parser != null) {
                this._parser.parse(this._cls);
            }
        }
        access = meta.getAccessType();
        boolean mappedSuper = "mapped-superclass".equals(elem);
        boolean embeddable = "embeddable".equals(elem);
        if (this.isMetaDataMode()) {
            Locator locator = this.getLocation().getLocator();
            meta.setSource(this.getSourceFile(), 2, locator != null ? locator.getSystemId() : "");
            meta.setSourceMode(1, true);
            if (locator != null) {
                meta.setLineNumber(locator.getLineNumber());
                meta.setColNumber(locator.getColumnNumber());
            }
            meta.setListingIndex(this._clsPos);
            String name = attrs.getValue("name");
            if (!StringUtil.isEmpty((String)name)) {
                meta.setTypeAlias(name);
            }
            meta.setAbstract(mappedSuper);
            meta.setEmbeddedOnly(mappedSuper || embeddable);
            if (embeddable) {
                meta.setEmbeddable();
                this.setDeferredEmbeddableAccessType(this._cls, access);
            }
        }
        if (attrs.getValue("cacheable") != null) {
            meta.setCacheEnabled(Boolean.valueOf(attrs.getValue("cacheable")).booleanValue());
        }
        if (this.isMappingMode()) {
            meta.setSourceMode(2, true);
        }
        if (this.isMappingOverrideMode()) {
            this.startClassMapping(meta, mappedSuper, attrs);
        }
        if (this.isQueryMode()) {
            meta.setSourceMode(4, true);
        }
        ++this._clsPos;
        this._fieldPos = 0;
        this.addComments(meta);
        this.pushElement(meta);
        return true;
    }

    protected void endClass(String elem) throws SAXException {
        if (this._mode != 4) {
            ClassMetaData meta = (ClassMetaData)this.popElement();
            this.storeCallbacks(meta);
            if (this.isMappingOverrideMode()) {
                this.endClassMapping(meta);
            }
        }
        this._cls = null;
        super.endClass(elem);
    }

    protected void startClassMapping(ClassMetaData mapping, boolean mappedSuper, Attributes attrs) throws SAXException {
    }

    protected void endClassMapping(ClassMetaData mapping) throws SAXException {
    }

    private void endAccess() {
        this._access = this.toAccessType(this.currentText());
    }

    private int toAccessType(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return AccessCode.UNKNOWN;
        }
        if ("PROPERTY".equals(str)) {
            return AccessCode.EXPLICIT | AccessCode.PROPERTY;
        }
        return AccessCode.EXPLICIT | AccessCode.FIELD;
    }

    private boolean startFlushMode(Attributes attrs) throws SAXException {
        Log log = this.getLog();
        if (log.isWarnEnabled()) {
            log.warn((Object)_loc.get("unsupported", (Object)"flush-mode", (Object)this.getSourceName()));
        }
        return false;
    }

    protected boolean startSequenceGenerator(Attributes attrs) {
        String props;
        String clsName;
        String val;
        SequenceMetaData meta;
        if (!this.isMappingOverrideMode()) {
            return false;
        }
        String name = attrs.getValue("name");
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)_loc.get("parse-sequence", (Object)name));
        }
        if ((meta = this.getRepository().getCachedSequenceMetaData(name)) != null && log.isWarnEnabled()) {
            log.warn((Object)_loc.get("override-sequence", (Object)name));
        }
        meta = this.getRepository().addSequenceMetaData(name);
        String seq = attrs.getValue("sequence-name");
        if (seq.indexOf(40) == -1) {
            seq = this.normalizeSequenceName(seq);
        }
        int initial = (val = attrs.getValue("initial-value")) == null ? 1 : Integer.parseInt(val);
        val = attrs.getValue("allocation-size");
        int allocate = val == null ? 50 : Integer.parseInt(val);
        String schema = this.normalizeSchemaName(attrs.getValue("schema"));
        String catalog = this.normalizeCatalogName(attrs.getValue("catalog"));
        if (seq == null || seq.indexOf(40) == -1) {
            clsName = "native";
            props = null;
        } else {
            clsName = Configurations.getClassName((String)seq);
            props = Configurations.getProperties((String)seq);
            seq = null;
        }
        meta.setSequencePlugin(Configurations.getPlugin((String)clsName, props));
        meta.setSequence(seq);
        meta.setInitialValue(initial);
        meta.setAllocate(allocate);
        meta.setSchema(schema);
        meta.setCatalog(catalog);
        Object cur = this.currentElement();
        Class scope = cur instanceof ClassMetaData ? ((ClassMetaData)cur).getDescribedType() : null;
        meta.setSource(this.getSourceFile(), (Object)scope, 2);
        Locator locator = this.getLocation().getLocator();
        if (locator != null) {
            meta.setLineNumber(locator.getLineNumber());
            meta.setColNumber(locator.getColumnNumber());
        }
        return true;
    }

    protected void endSequenceGenerator() {
    }

    protected boolean startId(Attributes attrs) throws SAXException {
        FieldMetaData fmd = this.parseField(attrs);
        fmd.setExplicit(true);
        fmd.setPrimaryKey(true);
        return true;
    }

    protected void endId() throws SAXException {
        this.finishField();
    }

    protected boolean startEmbeddedId(Attributes attrs) throws SAXException {
        FieldMetaData fmd = this.parseField(attrs);
        fmd.setExplicit(true);
        fmd.setPrimaryKey(true);
        fmd.setEmbedded(true);
        fmd.setSerialized(false);
        if (fmd.getEmbeddedMetaData() == null) {
            this.deferEmbeddable(fmd.getDeclaredType(), (MetaDataContext)fmd);
        }
        return true;
    }

    protected void endEmbeddedId() throws SAXException {
        this.finishField();
    }

    protected boolean startIdClass(Attributes attrs) throws SAXException {
        if (!this.isMetaDataMode()) {
            return false;
        }
        ClassMetaData meta = (ClassMetaData)this.currentElement();
        String cls = attrs.getValue("class");
        Class<?> idCls = null;
        try {
            idCls = this.classForName(cls);
        }
        catch (Throwable t) {
            throw this.getException(_loc.get("invalid-id-class", (Object)meta, (Object)cls), t);
        }
        if (!Serializable.class.isAssignableFrom(idCls)) {
            this._conf.getConfigurationLog().warn((Object)_loc.get("id-class-not-serializable", idCls, this._cls));
        }
        meta.setObjectIdType(idCls, true);
        return true;
    }

    protected void endIdClass() throws SAXException {
    }

    protected boolean startLob(Attributes attrs) throws SAXException {
        Class type;
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        int typeCode = fmd.isElementCollection() ? fmd.getElement().getDeclaredTypeCode() : fmd.getDeclaredTypeCode();
        Class clazz = type = fmd.isElementCollection() ? fmd.getElement().getDeclaredType() : fmd.getDeclaredType();
        if (typeCode != 9 && type != char[].class && type != Character[].class && type != byte[].class && type != Byte[].class) {
            fmd.setSerialized(true);
        }
        return true;
    }

    protected void endLob() throws SAXException {
    }

    protected boolean startGeneratedValue(Attributes attrs) throws SAXException {
        if (!this.isMappingOverrideMode()) {
            return false;
        }
        String strategy = attrs.getValue("strategy");
        String generator = attrs.getValue("generator");
        GenerationType type = StringUtil.isEmpty((String)strategy) ? GenerationType.AUTO : GenerationType.valueOf((String)strategy);
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        AnnotationPersistenceMetaDataParser.parseGeneratedValue(fmd, type, generator);
        return true;
    }

    protected void endGeneratedValue() throws SAXException {
    }

    protected boolean startCascade(Object tag, Attributes attrs) throws SAXException {
        boolean all;
        if (!this.isMetaDataMode()) {
            return false;
        }
        boolean puDefault = false;
        Set<CascadeType> cascades = null;
        if (this.currentElement() instanceof FieldMetaData) {
            if (this._cascades == null) {
                this._cascades = EnumSet.noneOf(CascadeType.class);
            }
            cascades = this._cascades;
        } else {
            if (this._pkgCascades == null) {
                this._pkgCascades = EnumSet.noneOf(CascadeType.class);
            }
            cascades = this._pkgCascades;
            puDefault = true;
        }
        boolean bl = all = ELEM_CASCADE_ALL == tag;
        if (all || ELEM_CASCADE_PER == tag) {
            cascades.add(CascadeType.PERSIST);
            if (puDefault) {
                MetaDataDefaults mdd = this._repos.getMetaDataFactory().getDefaults();
                mdd.setDefaultCascadePersistEnabled(Boolean.valueOf(true));
            }
        }
        if (all || ELEM_CASCADE_REM == tag) {
            cascades.add(CascadeType.REMOVE);
        }
        if (all || ELEM_CASCADE_MER == tag) {
            cascades.add(CascadeType.MERGE);
        }
        if (all || ELEM_CASCADE_REF == tag) {
            cascades.add(CascadeType.REFRESH);
        }
        if (all || ELEM_CASCADE_DET == tag) {
            cascades.add(CascadeType.DETACH);
        }
        return true;
    }

    protected void setCascades(FieldMetaData fmd) {
        Set<CascadeType> cascades = this._cascades;
        if (this._cascades == null) {
            cascades = this._pkgCascades;
        }
        if (cascades == null) {
            return;
        }
        FieldMetaData vmd = fmd;
        if (this._strategy == PersistenceStrategy.ONE_MANY || this._strategy == PersistenceStrategy.MANY_MANY) {
            vmd = fmd.getElement();
        }
        for (CascadeType cascade : cascades) {
            switch (cascade) {
                case PERSIST: {
                    vmd.setCascadePersist(1, false);
                    break;
                }
                case MERGE: {
                    vmd.setCascadeAttach(1);
                    break;
                }
                case DETACH: {
                    vmd.setCascadeDetach(1);
                    break;
                }
                case REMOVE: {
                    vmd.setCascadeDelete(1);
                    break;
                }
                case REFRESH: {
                    vmd.setCascadeRefresh(1);
                }
            }
        }
        this._cascades = null;
    }

    private FieldMetaData parseField(Attributes attrs) throws SAXException {
        ClassMetaData meta = (ClassMetaData)this.currentElement();
        String name = attrs.getValue("name");
        FieldMetaData field = meta.getDeclaredField(name);
        int fldAccess = this.getFieldAccess(field, attrs);
        if ((field == null || field.getDeclaredType() == Object.class || field.getAccessType() != fldAccess) && meta.getDescribedType() != Object.class) {
            Class<?> type;
            Member member = this._repos.getMetaDataFactory().getDefaults().getMemberByProperty(meta, name, fldAccess, false);
            Class<?> clazz = type = Field.class.isInstance(member) ? ((Field)member).getType() : ((Method)member).getReturnType();
            if (field == null) {
                field = meta.addDeclaredField(name, type);
                PersistenceMetaDataDefaults.setCascadeNone((ValueMetaData)field);
                PersistenceMetaDataDefaults.setCascadeNone(field.getKey());
                PersistenceMetaDataDefaults.setCascadeNone(field.getElement());
            }
            field.backingMember(member);
        } else if (field == null) {
            field = meta.addDeclaredField(name, Object.class);
            PersistenceMetaDataDefaults.setCascadeNone((ValueMetaData)field);
            PersistenceMetaDataDefaults.setCascadeNone(field.getKey());
            PersistenceMetaDataDefaults.setCascadeNone(field.getElement());
        }
        if (this.isMetaDataMode()) {
            field.setListingIndex(this._fieldPos);
        }
        ++this._fieldPos;
        this.pushElement(field);
        this.addComments(field);
        if (this.isMappingOverrideMode()) {
            this.startFieldMapping(field, attrs);
        }
        return field;
    }

    private void finishField() throws SAXException {
        FieldMetaData field = (FieldMetaData)this.popElement();
        this.setCascades(field);
        if (this.isMappingOverrideMode()) {
            this.endFieldMapping(field);
        }
        this._strategy = null;
    }

    private int getFieldAccess(FieldMetaData field, Attributes attrs) {
        if (attrs != null) {
            String access = attrs.getValue(ELEM_ACCESS);
            if ("PROPERTY".equals(access)) {
                return AccessCode.EXPLICIT | AccessCode.PROPERTY;
            }
            if ("FIELD".equals(access)) {
                return AccessCode.EXPLICIT | AccessCode.FIELD;
            }
        }
        if (field != null) {
            return field.getAccessType();
        }
        ClassMetaData meta = (ClassMetaData)this.currentElement();
        if (meta != null) {
            return AccessCode.toFieldCode((int)meta.getAccessType());
        }
        return AccessCode.UNKNOWN;
    }

    protected void startFieldMapping(FieldMetaData field, Attributes attrs) throws SAXException {
    }

    protected void endFieldMapping(FieldMetaData field) throws SAXException {
    }

    protected boolean startVersion(Attributes attrs) throws SAXException {
        FieldMetaData fmd = this.parseField(attrs);
        fmd.setExplicit(true);
        fmd.setVersion(true);
        return true;
    }

    protected void endVersion() throws SAXException {
        this.finishField();
    }

    private boolean startStrategy(PersistenceStrategy strategy, Attributes attrs) throws SAXException {
        FieldMetaData fmd = this.parseField(attrs);
        fmd.setExplicit(true);
        fmd.setManagement(3);
        String val = attrs.getValue("optional");
        if ("false".equals(val)) {
            fmd.setNullValue(2);
        } else if ("true".equals(val) && fmd.getNullValue() == 2) {
            fmd.setNullValue(-1);
        }
        if (this.isMappingOverrideMode() && (val = attrs.getValue("mapped-by")) != null) {
            fmd.setMappedBy(val);
        }
        this.parseStrategy(fmd, strategy, attrs);
        return true;
    }

    private void endStrategy(PersistenceStrategy strategy) throws SAXException {
        this.finishField();
    }

    private void parseStrategy(FieldMetaData fmd, PersistenceStrategy strategy, Attributes attrs) throws SAXException {
        switch (strategy) {
            case BASIC: {
                this.parseBasic(fmd, attrs);
                break;
            }
            case EMBEDDED: {
                this.parseEmbedded(fmd, attrs);
                break;
            }
            case ONE_ONE: {
                this.parseOneToOne(fmd, attrs);
                break;
            }
            case MANY_ONE: {
                this.parseManyToOne(fmd, attrs);
                break;
            }
            case MANY_MANY: {
                this.parseManyToMany(fmd, attrs);
                break;
            }
            case ONE_MANY: {
                this.parseOneToMany(fmd, attrs);
                break;
            }
            case TRANSIENT: {
                String val = attrs.getValue("fetch");
                if (val != null) {
                    fmd.setInDefaultFetchGroup("EAGER".equals(val));
                }
                fmd.setManagement(0);
                break;
            }
            case ELEM_COLL: {
                this.parseElementCollection(fmd, attrs);
                break;
            }
            case PERS: {
                this.parsePersistent(fmd, attrs);
                break;
            }
            case PERS_COLL: {
                this.parsePersistentCollection(fmd, attrs);
                break;
            }
            case PERS_MAP: {
                this.parsePersistentMap(fmd, attrs);
            }
        }
    }

    protected void parseBasic(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String val = attrs.getValue("fetch");
        if (val != null) {
            fmd.setInDefaultFetchGroup("EAGER".equals(val));
        }
    }

    protected void parseEmbedded(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.assertPC(fmd, "Embedded");
        fmd.setInDefaultFetchGroup(true);
        fmd.setEmbedded(true);
        fmd.setSerialized(false);
        if (fmd.getEmbeddedMetaData() == null) {
            this.deferEmbeddable(fmd.getDeclaredType(), (MetaDataContext)fmd);
        }
    }

    private void assertPC(FieldMetaData fmd, String attr) throws SAXException {
        if (!JavaTypes.maybePC((FieldMetaData)fmd)) {
            throw this.getException(_loc.get("bad-meta-anno", (Object)fmd, (Object)attr));
        }
    }

    protected void parseOneToOne(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String val = attrs.getValue("fetch");
        boolean dfg = val == null || !val.equals("LAZY");
        fmd.setDefaultFetchGroupExplicit(true);
        fmd.setInDefaultFetchGroup(dfg);
        fmd.setDefaultFetchGroupExplicit(false);
        val = attrs.getValue("target-entity");
        if (val != null) {
            fmd.setTypeOverride(AnnotationPersistenceMetaDataParser.toOverrideType(this.classForName(val)));
        }
        this.assertPC(fmd, "OneToOne");
        fmd.setSerialized(false);
        boolean orphanRemoval = Boolean.valueOf(attrs.getValue("orphan-removal"));
        this.setOrphanRemoval((ValueMetaData)fmd, orphanRemoval);
        String mapsId = attrs.getValue("maps-id");
        if (mapsId != null) {
            fmd.setMappedByIdValue(mapsId);
        }
    }

    protected void parseManyToOne(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String val = attrs.getValue("fetch");
        boolean dfg = val == null || !val.equals("LAZY");
        fmd.setDefaultFetchGroupExplicit(true);
        fmd.setInDefaultFetchGroup(dfg);
        fmd.setDefaultFetchGroupExplicit(false);
        val = attrs.getValue("target-entity");
        if (val != null) {
            fmd.setTypeOverride(AnnotationPersistenceMetaDataParser.toOverrideType(this.classForName(val)));
        }
        this.assertPC(fmd, "ManyToOne");
        fmd.setSerialized(false);
        String mapsId = attrs.getValue("maps-id");
        if (mapsId != null) {
            fmd.setMappedByIdValue(mapsId);
        }
    }

    protected void parseManyToMany(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String val = attrs.getValue("fetch");
        if (val != null) {
            fmd.setInDefaultFetchGroup("EAGER".equals(val));
        }
        if ((val = attrs.getValue("target-entity")) != null) {
            fmd.getElement().setDeclaredType(this.classForName(val));
        }
        this.assertPCCollection(fmd, "ManyToMany");
        fmd.setSerialized(false);
    }

    private void assertPCCollection(FieldMetaData fmd, String attr) throws SAXException {
        switch (fmd.getDeclaredTypeCode()) {
            case 11: 
            case 12: 
            case 13: {
                if (JavaTypes.maybePC((ValueMetaData)fmd.getElement())) break;
            }
            default: {
                throw this.getException(_loc.get("bad-meta-anno", (Object)fmd, (Object)attr));
            }
        }
    }

    protected void parseOneToMany(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String val = attrs.getValue("fetch");
        if (val != null) {
            fmd.setInDefaultFetchGroup("EAGER".equals(val));
        }
        if ((val = attrs.getValue("target-entity")) != null) {
            fmd.getElement().setDeclaredType(this.classForName(val));
        }
        this.assertPCCollection(fmd, "OneToMany");
        fmd.setSerialized(false);
        boolean orphanRemoval = Boolean.valueOf(attrs.getValue("orphan-removal"));
        this.setOrphanRemoval(fmd.getElement(), orphanRemoval);
    }

    protected void setOrphanRemoval(ValueMetaData vmd, boolean orphanRemoval) {
        if (orphanRemoval) {
            vmd.setCascadeDelete(2);
        }
    }

    protected void parseElementCollection(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String val = attrs.getValue("target-class");
        if (val != null) {
            fmd.getElement().setDeclaredType(this.classForName(val));
        }
        if (fmd.getDeclaredTypeCode() != 12 && fmd.getDeclaredTypeCode() != 13) {
            throw this.getException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"ElementCollection"));
        }
        val = attrs.getValue("fetch");
        if (val != null) {
            fmd.setInDefaultFetchGroup("EAGER".equals(val));
        }
        fmd.setElementCollection(true);
        fmd.setSerialized(false);
        if (JavaTypes.maybePC((ValueMetaData)fmd.getElement()) && !fmd.getElement().getDeclaredType().isEnum()) {
            fmd.getElement().setEmbedded(true);
            if (fmd.getElement().getEmbeddedMetaData() == null) {
                this.deferEmbeddable(fmd.getElement().getDeclaredType(), (MetaDataContext)fmd.getElement());
            }
        }
    }

    private boolean startMapKey(Attributes attrs) throws SAXException {
        if (!this.isMappingOverrideMode()) {
            return false;
        }
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        String mapKey = attrs.getValue("name");
        if (mapKey == null) {
            fmd.getKey().setValueMappedBy("`pk`");
        } else {
            fmd.getKey().setValueMappedBy(mapKey);
        }
        return true;
    }

    private boolean startMapKeyClass(Attributes attrs) throws SAXException {
        if (!this.isMappingOverrideMode()) {
            return false;
        }
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        String mapKeyClass = attrs.getValue("class");
        if (mapKeyClass != null) {
            try {
                fmd.getKey().setDeclaredType(Class.forName(mapKeyClass));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class not found");
            }
        } else {
            throw new IllegalArgumentException("The value of the MapKeyClass cannot be null");
        }
        return true;
    }

    private void endOrderBy() throws SAXException {
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        String dec = this.currentText();
        if ((fmd.isElementCollection() && fmd.getElement().getEmbeddedMetaData() != null || this.isDeferredEmbeddable(fmd.getElement().getDeclaredType(), (MetaDataContext)fmd.getElement())) && (dec.length() == 0 || dec.equals("ASC") || dec.equals("DESC"))) {
            throw new MetaDataException(_loc.get("invalid-orderBy", (Object)fmd));
        }
        if (StringUtil.isEmpty((String)dec) || dec.equals("ASC")) {
            dec = "#element asc";
        } else if (dec.equals("DESC")) {
            dec = "#element desc";
        }
        fmd.setOrderDeclaration(dec);
    }

    protected boolean startNamedQuery(Attributes attrs) throws SAXException {
        Object cur;
        Locator locator;
        QueryMetaData meta;
        if (!this.isQueryMode()) {
            return false;
        }
        String name = attrs.getValue("name");
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)_loc.get("parse-query", (Object)name));
        }
        if ((meta = this.getRepository().searchQueryMetaDataByName(name)) != null) {
            Class defType = meta.getDefiningType();
            if (defType != this._cls && log.isWarnEnabled()) {
                log.warn((Object)_loc.get("dup-query", (Object)name, (Object)this.currentLocation(), (Object)defType));
            }
            this.pushElement(meta);
            return true;
        }
        meta = this.getRepository().addQueryMetaData(null, name);
        meta.setDefiningType(this._cls);
        meta.setLanguage("javax.persistence.JPQL");
        meta.setQueryString(attrs.getValue("query"));
        String lockModeStr = attrs.getValue("lock-mode");
        LockModeType lmt = this.processNamedQueryLockModeType(log, lockModeStr, name);
        if (lmt != null && lmt != LockModeType.NONE) {
            meta.addHint("openjpa.FetchPlan.ReadLockMode", (Object)lmt);
        }
        if ((locator = this.getLocation().getLocator()) != null) {
            meta.setLineNumber(locator.getLineNumber());
            meta.setColNumber(locator.getColumnNumber());
        }
        Class scope = (cur = this.currentElement()) instanceof ClassMetaData ? ((ClassMetaData)cur).getDescribedType() : null;
        meta.setSource(this.getSourceFile(), (Object)scope, 2, locator == null ? "" : locator.getSystemId());
        if (this.isMetaDataMode()) {
            meta.setSourceMode(1);
        } else if (this.isMappingMode()) {
            meta.setSourceMode(2);
        } else {
            meta.setSourceMode(4);
        }
        this.pushElement(meta);
        return true;
    }

    private LockModeType processNamedQueryLockModeType(Log log, String lockModeString, String queryName) {
        if (lockModeString == null) {
            return null;
        }
        LockModeType lmt = LockModeType.valueOf((String)lockModeString);
        String lm = this._conf.getLockManager();
        boolean optimistic = this._conf.getOptimistic();
        if (lm != null && (lm = lm.toLowerCase()).contains("pessimistic") && lmt == LockModeType.NONE && !optimistic) {
            if (log != null && log.isWarnEnabled()) {
                log.warn((Object)_loc.get("override-named-query-lock-mode", (Object[])new String[]{"xml", queryName, this._cls.getName()}));
            }
            lmt = LockModeType.READ;
        }
        return lmt;
    }

    protected void endNamedQuery() throws SAXException {
        this.popElement();
    }

    protected boolean startQueryString(Attributes attrs) throws SAXException {
        return true;
    }

    protected void endQueryString() throws SAXException {
        QueryMetaData meta = (QueryMetaData)this.currentElement();
        meta.setQueryString(this.currentText());
    }

    protected boolean startQueryHint(Attributes attrs) throws SAXException {
        QueryMetaData meta = (QueryMetaData)this.currentElement();
        meta.addHint(attrs.getValue("name"), (Object)attrs.getValue("value"));
        return true;
    }

    protected void endQueryHint() throws SAXException {
    }

    protected boolean startNamedNativeQuery(Attributes attrs) throws SAXException {
        Object cur;
        QueryMetaData meta;
        if (!this.isQueryMode()) {
            return false;
        }
        String name = attrs.getValue("name");
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)_loc.get("parse-native-query", (Object)name));
        }
        if ((meta = this.getRepository().getCachedQueryMetaData(name)) != null && this.isDuplicateQuery(meta)) {
            log.warn((Object)_loc.get("override-query", (Object)name, (Object)this.currentLocation()));
        }
        meta = this.getRepository().addQueryMetaData(null, name);
        meta.setDefiningType(this._cls);
        meta.setLanguage("openjpa.SQL");
        meta.setQueryString(attrs.getValue("query"));
        String val = attrs.getValue("result-class");
        if (val != null) {
            Class<?> type = this.classForName(val);
            if (ImplHelper.isManagedType((OpenJPAConfiguration)this.getConfiguration(), type)) {
                meta.setCandidateType(type);
            } else {
                meta.setResultType(type);
            }
        }
        if ((val = attrs.getValue("result-set-mapping")) != null) {
            meta.setResultSetMappingName(val);
        }
        Class scope = (cur = this.currentElement()) instanceof ClassMetaData ? ((ClassMetaData)cur).getDescribedType() : null;
        Locator locator = this.getLocation().getLocator();
        meta.setSource(this.getSourceFile(), (Object)scope, 2, locator == null ? "" : locator.getSystemId());
        if (locator != null) {
            meta.setLineNumber(locator.getLineNumber());
            meta.setColNumber(locator.getColumnNumber());
        }
        if (this.isMetaDataMode()) {
            meta.setSourceMode(1);
        } else if (this.isMappingMode()) {
            meta.setSourceMode(2);
        } else {
            meta.setSourceMode(4);
        }
        this.pushElement(meta);
        return true;
    }

    protected void endNamedNativeQuery() throws SAXException {
        this.popElement();
    }

    private boolean startEntityListeners(Attributes attrs) throws SAXException {
        if (!this.isMetaDataMode()) {
            return false;
        }
        if (this.currentElement() == null) {
            return true;
        }
        LifecycleMetaData meta = ((ClassMetaData)this.currentElement()).getLifecycleMetaData();
        for (int i = 0; i < LifecycleEvent.ALL_EVENTS.length; ++i) {
            meta.setDeclaredCallbacks(i, null, 0);
        }
        return true;
    }

    private boolean startExcludeDefaultListeners(Attributes attrs) throws SAXException {
        if (!this.isMetaDataMode()) {
            return false;
        }
        ClassMetaData meta = (ClassMetaData)this.currentElement();
        meta.getLifecycleMetaData().setIgnoreSystemListeners(true);
        return true;
    }

    private boolean startExcludeSuperclassListeners(Attributes attrs) throws SAXException {
        if (!this.isMetaDataMode()) {
            return false;
        }
        ClassMetaData meta = (ClassMetaData)this.currentElement();
        meta.getLifecycleMetaData().setIgnoreSuperclassCallbacks(2);
        return true;
    }

    private boolean startEntityListener(Attributes attrs) throws SAXException {
        this._listener = this.classForName(attrs.getValue("class"));
        if (!this._conf.getCallbackOptionsInstance().getAllowsDuplicateListener()) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            if (this._listeners.contains(this._listener)) {
                return true;
            }
            this._listeners.add(this._listener);
        }
        boolean system = this.currentElement() == null;
        Collection<LifecycleCallbacks>[] parsed = AnnotationPersistenceMetaDataParser.parseCallbackMethods(this._listener, null, true, true, this._repos);
        if (parsed == null) {
            return true;
        }
        if (this._callbacks == null) {
            this._callbacks = new Collection[LifecycleEvent.ALL_EVENTS.length];
            if (!system) {
                this._highs = new int[LifecycleEvent.ALL_EVENTS.length];
            }
        }
        for (int i = 0; i < parsed.length; ++i) {
            if (parsed[i] == null) continue;
            if (this._callbacks[i] == null) {
                this._callbacks[i] = parsed[i];
            } else {
                this._callbacks[i].addAll(parsed[i]);
            }
            if (system) continue;
            int n = i;
            this._highs[n] = this._highs[n] + parsed[i].size();
        }
        return true;
    }

    private void endEntityListener() throws SAXException {
        if (this.currentElement() == null && this._callbacks != null) {
            this._repos.addSystemListener((Object)new PersistenceListenerAdapter(this._callbacks));
            this._callbacks = null;
        }
        this._listener = null;
    }

    private boolean startCallback(MetaDataTag callback, Attributes attrs) throws SAXException {
        Class<Object> type;
        boolean system;
        if (!this.isMetaDataMode()) {
            return false;
        }
        int[] events = MetaDataParsers.getEventTypes(callback, this._conf);
        if (events == null) {
            return false;
        }
        boolean bl = system = this.currentElement() == null;
        if (system && this._parseList != null && this._parseList.size() > 0) {
            return false;
        }
        Class<Object> clazz = type = this.currentElement() == null ? null : ((ClassMetaData)this.currentElement()).getDescribedType();
        if (type == null) {
            type = Object.class;
        }
        if (this._callbacks == null) {
            this._callbacks = new Collection[LifecycleEvent.ALL_EVENTS.length];
            if (!system) {
                this._highs = new int[LifecycleEvent.ALL_EVENTS.length];
            }
        }
        Object adapter = this._listener != null ? new BeanLifecycleCallbacks(this._listener, attrs.getValue("method-name"), false, type) : new MethodLifecycleCallbacks(this._cls, attrs.getValue("method-name"), false);
        for (int event : events) {
            if (this._listener != null) {
                MetaDataParsers.validateMethodsForSameCallback(this._listener, this._callbacks[event], ((BeanLifecycleCallbacks)adapter).getCallbackMethod(), callback, this._conf, this.getLog());
            } else {
                MetaDataParsers.validateMethodsForSameCallback(this._cls, this._callbacks[event], adapter.getCallbackMethod(), callback, this._conf, this.getLog());
            }
            if (this._callbacks[event] == null) {
                this._callbacks[event] = new ArrayList<LifecycleCallbacks>(3);
            }
            this._callbacks[event].add((LifecycleCallbacks)adapter);
            if (system || this._listener == null) continue;
            int n = event;
            this._highs[n] = this._highs[n] + 1;
        }
        return true;
    }

    private void storeCallbacks(ClassMetaData cls) {
        LifecycleMetaData meta = cls.getLifecycleMetaData();
        Class supCls = cls.getDescribedType().getSuperclass();
        Collection<LifecycleCallbacks>[] supCalls = null;
        if (!Object.class.equals(supCls)) {
            supCalls = AnnotationPersistenceMetaDataParser.parseCallbackMethods(supCls, null, true, false, this._repos);
        }
        if (supCalls != null) {
            for (int event : LifecycleEvent.ALL_EVENTS) {
                if (supCalls[event] == null) continue;
                meta.setNonPCSuperclassCallbacks(event, supCalls[event].toArray(new LifecycleCallbacks[supCalls[event].size()]), 0);
            }
        }
        if (this._callbacks == null) {
            return;
        }
        for (int event : LifecycleEvent.ALL_EVENTS) {
            if (this._callbacks[event] == null) continue;
            meta.setDeclaredCallbacks(event, this._callbacks[event].toArray(new LifecycleCallbacks[this._callbacks[event].size()]), this._highs[event]);
        }
        this._callbacks = null;
        this._highs = null;
    }

    protected boolean startOrderColumn(Attributes attrs) throws SAXException {
        return true;
    }

    protected Class<?> classForName(String name) throws SAXException {
        if ("Entity".equals(name)) {
            return PersistenceCapable.class;
        }
        return super.classForName(name, this.isRuntime());
    }

    protected void addDeferredEmbeddableMetaData() {
        if (_embeddables != null && _embeddables.size() > 0) {
            Class[] classes = _embeddables.keySet().toArray(new Class[_embeddables.size()]);
            for (int i = classes.length - 1; i >= 0; --i) {
                try {
                    Integer access = _embeddableAccess.get(classes[i]);
                    if (access == null) {
                        access = AccessCode.UNKNOWN;
                    }
                    this.addDeferredEmbeddableMetaData(classes[i], access);
                    continue;
                }
                catch (Exception e) {
                    throw new MetaDataException(_loc.get("no-embeddable-metadata", (Object)classes[i].getName()), (Throwable)e);
                }
            }
        }
    }

    protected void addDeferredEmbeddableMetaData(Class<?> embedType, int access) throws SAXException {
        ArrayList<MetaDataContext> fmds = _embeddables.get(embedType);
        if (fmds != null && fmds.size() > 0) {
            for (MetaDataContext md : fmds) {
                if (md instanceof FieldMetaData) {
                    FieldMetaData fmd = (FieldMetaData)md;
                    fmd.addEmbeddedMetaData(access);
                    continue;
                }
                if (!(md instanceof ValueMetaData)) continue;
                ValueMetaData vmd = (ValueMetaData)md;
                vmd.addEmbeddedMetaData(access);
            }
            this.applyDeferredEmbeddableOverrides(embedType);
            fmds.clear();
            _embeddables.remove(embedType);
        }
    }

    protected void setDeferredEmbeddableAccessType(Class<?> embedType, int access) {
        _embeddableAccess.put(embedType, access);
    }

    protected void clearDeferredMetaData() {
        _embeddables.clear();
        _embeddableAccess.clear();
    }

    protected boolean isDeferredEmbeddable(Class<?> embedType, MetaDataContext fmd) {
        ArrayList<MetaDataContext> fmds = _embeddables.get(embedType);
        if (fmds != null) {
            return fmds.contains(fmd);
        }
        return false;
    }

    protected void deferEmbeddable(Class<?> embedType, MetaDataContext fmd) {
        ArrayList fmds = _embeddables.computeIfAbsent(embedType, k -> new ArrayList());
        fmds.add(fmd);
    }

    protected void applyDeferredEmbeddableOverrides(Class<?> cls) throws SAXException {
    }

    public void addToParseList(ArrayList<Class<?>> parseList) {
        if (parseList == null) {
            return;
        }
        this._parseList.addAll(parseList);
    }

    public void addToParseList(Class<?> parentCls) {
        if (parentCls == null) {
            return;
        }
        this._parseList.add(parentCls);
    }

    public boolean parseListContains(Class<?> cls) {
        if (this._parseList.size() == 0) {
            return false;
        }
        return this._parseList.contains(cls);
    }

    public ArrayList<Class<?>> getParseList() {
        return this._parseList;
    }

    public Class<?> getParseClass() {
        return this._cls;
    }

    protected boolean startDelimitedIdentifiers() {
        return false;
    }

    protected String normalizeSequenceName(String seqName) {
        return seqName;
    }

    protected String normalizeSchemaName(String schName) {
        return schName;
    }

    protected String normalizeCatalogName(String catName) {
        return catName;
    }

    protected boolean isDuplicateClass(ClassMetaData meta) {
        if (!Objects.equals(this.getSourceName(), meta.getSourceName())) {
            return true;
        }
        return this.getLineNum() != meta.getLineNumber();
    }

    protected boolean isDuplicateQuery(QueryMetaData meta) {
        if (!Objects.equals(this.getSourceName(), meta.getSourceName())) {
            return true;
        }
        return this.getLineNum() != meta.getLineNumber();
    }

    private int getLineNum() {
        int lineNum = 0;
        Locator loc = this.getLocation().getLocator();
        if (loc != null) {
            lineNum = loc.getLineNumber();
        }
        return lineNum;
    }

    private boolean startDatastoreId(Attributes attrs) throws SAXException {
        MetaDataRepository repos = this.getRepository();
        ClassMetaData meta = repos.getCachedMetaData(this._cls);
        String strategy = attrs.getValue("strategy");
        if (StringUtil.isEmpty((String)strategy)) {
            strategy = "AUTO";
        }
        GenerationType stratType = GenerationType.valueOf((String)strategy);
        AnnotationPersistenceMetaDataParser.parseDataStoreId(meta, stratType, attrs.getValue("generator"));
        return true;
    }

    private boolean startDataCache(Attributes attrs) throws SAXException {
        String enabledStr = attrs.getValue("enabled");
        boolean enabled = StringUtil.isEmpty((String)enabledStr) ? true : Boolean.parseBoolean(enabledStr);
        String timeoutStr = attrs.getValue("timeout");
        int timeout = StringUtil.isEmpty((String)timeoutStr) ? Integer.MIN_VALUE : Integer.parseInt(timeoutStr);
        String name = attrs.getValue("name");
        name = StringUtil.isEmpty((String)name) ? "" : name;
        AnnotationPersistenceMetaDataParser.parseDataCache(this.getRepository().getCachedMetaData(this._cls), enabled, name, timeout);
        return true;
    }

    private boolean startExtendedStrategy(PersistenceStrategy ps, Attributes attrs) throws SAXException {
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        this.parseExtendedStrategy(fmd, ps, attrs);
        return true;
    }

    private void endExtendedStrategy(PersistenceStrategy ps) throws SAXException {
        if (ps == PersistenceStrategy.PERS || ps == PersistenceStrategy.PERS_COLL || ps == PersistenceStrategy.PERS_MAP) {
            this.finishField();
        }
    }

    private void parseExtendedStrategy(FieldMetaData fmd, PersistenceStrategy strategy, Attributes attrs) throws SAXException {
        this.parseTypeAttr(fmd, attrs);
        this.parseElementTypeAttr(fmd, attrs);
        this.parseKeyTypeAttr(fmd, attrs);
        this.parseDependentAttr(fmd, attrs);
        this.parseElementDependentAttr(fmd, attrs);
        this.parseKeyDependentAttr(fmd, attrs);
        this.parseElementClassCriteriaAttr(fmd, attrs);
        this.parseLRSAttr(fmd, attrs);
        this.parseInverseLogicalAttr(fmd, attrs);
        this.parseEagerFetchModeAttr(fmd, attrs);
        switch (strategy) {
            case BASIC: {
                this.parseExtendedBasic(fmd, attrs);
                break;
            }
            case EMBEDDED: {
                this.parseExtendedEmbedded(fmd, attrs);
                break;
            }
            case ONE_ONE: {
                this.parseExtendedOneToOne(fmd, attrs);
                break;
            }
            case MANY_ONE: {
                this.parseExtendedManyToOne(fmd, attrs);
                break;
            }
            case MANY_MANY: {
                this.parseExtendedManyToMany(fmd, attrs);
                break;
            }
            case ONE_MANY: {
                this.parseExtendedOneToMany(fmd, attrs);
                break;
            }
            case ELEM_COLL: {
                this.parseExtendedElementCollection(fmd, attrs);
            }
        }
    }

    private void parseExtendedBasic(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
    }

    private void parseExtendedEmbedded(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
    }

    private void parseExtendedOneToOne(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
    }

    private void parseExtendedManyToOne(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
    }

    private void parseExtendedManyToMany(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
    }

    private void parseExtendedOneToMany(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
    }

    private void parseExtendedElementCollection(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
    }

    private void parsePersistent(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
        this.parseTypeAttr(fmd, attrs);
        String val = attrs.getValue("fetch");
        if (val != null) {
            fmd.setInDefaultFetchGroup("EAGER".equals(val));
        }
        switch (fmd.getDeclaredTypeCode()) {
            case 11: {
                if (fmd.getDeclaredType() == byte[].class || fmd.getDeclaredType() == Byte[].class || fmd.getDeclaredType() == char[].class || fmd.getDeclaredType() == Character[].class) break;
            }
            case 12: 
            case 13: {
                throw new MetaDataException(_loc.get("bad-meta-anno", (Object)fmd, (Object)"Persistent"));
            }
        }
    }

    private void parsePersistentCollection(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
        this.parseElementTypeAttr(fmd, attrs);
    }

    private void parsePersistentMap(FieldMetaData fmd, Attributes attrs) throws SAXException {
        this.parseCommonExtendedAttributes(fmd, attrs);
        this.parseElementTypeAttr(fmd, attrs);
        this.parseKeyTypeAttr(fmd, attrs);
    }

    private void parseCommonExtendedAttributes(FieldMetaData fmd, Attributes attrs) {
        String factory;
        String externalizer;
        String loadFetchGroup = attrs.getValue("load-fetch-group");
        if (!StringUtil.isEmpty((String)loadFetchGroup)) {
            fmd.setLoadFetchGroup(loadFetchGroup);
        }
        if (!StringUtil.isEmpty((String)(externalizer = attrs.getValue("externalizer")))) {
            fmd.setExternalizer(externalizer);
        }
        if (!StringUtil.isEmpty((String)(factory = attrs.getValue("factory")))) {
            fmd.setFactory(factory);
        }
        this.parseStrategy(fmd, attrs);
    }

    protected void parseStrategy(FieldMetaData fmd, Attributes attrs) {
    }

    private boolean startReadOnly(Attributes attrs) throws SAXException {
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        String updateAction = attrs.getValue("update-action");
        if (updateAction.equalsIgnoreCase("RESTRICT")) {
            fmd.setUpdateStrategy(2);
        } else if (updateAction.equalsIgnoreCase("IGNORE")) {
            fmd.setUpdateStrategy(1);
        } else {
            throw new InternalException();
        }
        return true;
    }

    private void parseDependentAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String dependentStr = attrs.getValue("dependent");
        if (!StringUtil.isEmpty((String)dependentStr)) {
            boolean dependent = Boolean.parseBoolean(dependentStr);
            if (dependent) {
                fmd.setCascadeDelete(2);
            } else {
                fmd.setCascadeDelete(0);
            }
        }
    }

    private void parseElementDependentAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String elementDependentStr = attrs.getValue("element-dependent");
        if (!StringUtil.isEmpty((String)elementDependentStr)) {
            boolean elementDependent = Boolean.parseBoolean(elementDependentStr);
            if (elementDependent) {
                fmd.getElement().setCascadeDelete(2);
            } else {
                fmd.getElement().setCascadeDelete(0);
            }
        }
    }

    private void parseKeyDependentAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String keyDependentStr = attrs.getValue("key-dependent");
        if (!StringUtil.isEmpty((String)keyDependentStr)) {
            boolean keyDependent = Boolean.parseBoolean(keyDependentStr);
            if (keyDependent) {
                fmd.getKey().setCascadeDelete(2);
            } else {
                fmd.getKey().setCascadeDelete(0);
            }
        }
    }

    protected void parseElementClassCriteriaAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
    }

    private void parseTypeAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String typeStr = attrs.getValue("type");
        if (!StringUtil.isEmpty((String)typeStr)) {
            if (StringUtil.endsWithIgnoreCase((String)typeStr, (String)".class")) {
                typeStr = typeStr.substring(0, typeStr.lastIndexOf(46));
            }
            Class<?> typeCls = this.parseTypeStr(typeStr);
            fmd.setTypeOverride(typeCls);
        }
    }

    private void parseLRSAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String lrsStr = attrs.getValue("lrs");
        if (!StringUtil.isEmpty((String)lrsStr)) {
            boolean lrs = Boolean.parseBoolean(lrsStr);
            fmd.setLRS(lrs);
        }
    }

    private void parseElementTypeAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String typeStr = attrs.getValue("element-type");
        if (!StringUtil.isEmpty((String)typeStr)) {
            if (StringUtil.endsWithIgnoreCase((String)typeStr, (String)".class")) {
                typeStr = typeStr.substring(0, typeStr.lastIndexOf(46));
            }
            Class<?> typeCls = this.parseTypeStr(typeStr);
            fmd.setTypeOverride(typeCls);
        }
    }

    private void parseKeyTypeAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String typeStr = attrs.getValue("key-type");
        if (!StringUtil.isEmpty((String)typeStr)) {
            if (StringUtil.endsWithIgnoreCase((String)typeStr, (String)".class")) {
                typeStr = typeStr.substring(0, typeStr.lastIndexOf(46));
            }
            Class<?> typeCls = this.parseTypeStr(typeStr);
            fmd.setTypeOverride(typeCls);
        }
    }

    private Class<?> parseTypeStr(String typeStr) throws SAXException {
        Class<Comparable<Integer>> typeCls = null;
        try {
            typeCls = typeStr.equalsIgnoreCase("int") ? Integer.TYPE : (typeStr.equalsIgnoreCase("byte") ? Byte.TYPE : (typeStr.equalsIgnoreCase("short") ? Short.TYPE : (typeStr.equalsIgnoreCase("long") ? Long.TYPE : (typeStr.equalsIgnoreCase("float") ? Float.TYPE : (typeStr.equalsIgnoreCase("double") ? Double.TYPE : (typeStr.equalsIgnoreCase("boolean") ? Boolean.TYPE : (typeStr.equalsIgnoreCase("char") ? Character.TYPE : Class.forName(typeStr))))))));
        }
        catch (ClassNotFoundException e) {
            throw new SAXException(e);
        }
        return typeCls;
    }

    private void parseInverseLogicalAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String inverseLogical = attrs.getValue("inverse-logical");
        if (!StringUtil.isEmpty((String)inverseLogical)) {
            fmd.setInverse(inverseLogical);
        }
    }

    protected void parseEagerFetchModeAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
    }

    private boolean startExternalValues(Attributes attrs) throws SAXException {
        this._externalValues = new StringBuffer(10);
        return true;
    }

    private void endExternalValues() throws SAXException {
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        fmd.setExternalValues(this._externalValues.toString());
        this._externalValues = null;
    }

    private boolean startExternalValue(Attributes attrs) throws SAXException {
        if (this._externalValues.length() > 0) {
            this._externalValues.append(',');
        }
        this._externalValues.append(attrs.getValue("java-value"));
        this._externalValues.append('=');
        this._externalValues.append(attrs.getValue("datastore-value"));
        return true;
    }

    private boolean startExternalizer(Attributes attrs) throws SAXException {
        return true;
    }

    private void endExternalizer() throws SAXException {
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        String externalizer = this.currentText();
        fmd.setExternalizer(externalizer);
    }

    private boolean startFactory(Attributes attrs) throws SAXException {
        return true;
    }

    private void endFactory() throws SAXException {
        FieldMetaData fmd = (FieldMetaData)this.currentElement();
        String factory = this.currentText();
        fmd.setFactory(factory);
    }

    private boolean startFetchGroups(Attributes attrs) throws SAXException {
        if (this._fgList == null) {
            this._fgList = new ArrayList<AnnotationPersistenceMetaDataParser.FetchGroupImpl>();
        }
        return true;
    }

    private boolean startFetchGroup(Attributes attrs) throws SAXException {
        if (this._fgList == null) {
            this._fgList = new ArrayList<AnnotationPersistenceMetaDataParser.FetchGroupImpl>();
        }
        this._currentFg = new AnnotationPersistenceMetaDataParser.FetchGroupImpl(attrs.getValue("name"), Boolean.parseBoolean(attrs.getValue("post-load")));
        return true;
    }

    private void endFetchGroup() throws SAXException {
        String[] referencedFetchGroups = new String[]{};
        if (this._referencedFgList != null && this._referencedFgList.size() > 0) {
            referencedFetchGroups = this._referencedFgList.toArray(referencedFetchGroups);
        }
        this._currentFg.setFetchGroups(referencedFetchGroups);
        AnnotationPersistenceMetaDataParser.FetchAttributeImpl[] fetchAttrs = new AnnotationPersistenceMetaDataParser.FetchAttributeImpl[]{};
        if (this._fetchAttrList != null && this._fetchAttrList.size() > 0) {
            fetchAttrs = this._fetchAttrList.toArray(fetchAttrs);
        }
        this._currentFg.setAttributes(fetchAttrs);
        this._fgList.add(this._currentFg);
        this._currentFg = null;
        this._referencedFgList = null;
        this._fetchAttrList = null;
    }

    private boolean startFetchAttribute(Attributes attrs) throws SAXException {
        if (this._fetchAttrList == null) {
            this._fetchAttrList = new ArrayList<AnnotationPersistenceMetaDataParser.FetchAttributeImpl>();
        }
        AnnotationPersistenceMetaDataParser.FetchAttributeImpl fetchAttribute = new AnnotationPersistenceMetaDataParser.FetchAttributeImpl(attrs.getValue("name"), Integer.parseInt(attrs.getValue("recursion-depth")));
        this._fetchAttrList.add(fetchAttribute);
        return true;
    }

    private boolean startReferencedFetchGroup(Attributes attrs) throws SAXException {
        if (this._referencedFgList == null) {
            this._referencedFgList = new ArrayList<String>();
        }
        return true;
    }

    private void endReferencedFetchGroup() throws SAXException {
        this._referencedFgList.add(this.currentText());
    }

    protected void endExtendedClass(String elem) throws SAXException {
        ClassMetaData meta = (ClassMetaData)this.peekElement();
        if (this._fgList != null) {
            this._fgs = new AnnotationPersistenceMetaDataParser.FetchGroupImpl[0];
            this._fgs = this._fgList.toArray(this._fgs);
            AnnotationPersistenceMetaDataParser.parseFetchGroups(meta, this._fgs);
            this._fgList = null;
            this._fgs = null;
        }
    }

    static {
        _elems.put(ELEM_PKG, ELEM_PKG);
        _elems.put(ELEM_ACCESS, ELEM_ACCESS);
        _elems.put(ELEM_ATTRS, ELEM_ATTRS);
        _elems.put(ELEM_LISTENER, ELEM_LISTENER);
        _elems.put(ELEM_CASCADE, ELEM_CASCADE);
        _elems.put(ELEM_CASCADE_ALL, ELEM_CASCADE_ALL);
        _elems.put(ELEM_CASCADE_PER, ELEM_CASCADE_PER);
        _elems.put(ELEM_CASCADE_REM, ELEM_CASCADE_REM);
        _elems.put(ELEM_CASCADE_MER, ELEM_CASCADE_MER);
        _elems.put(ELEM_CASCADE_REF, ELEM_CASCADE_REF);
        _elems.put(ELEM_CASCADE_DET, ELEM_CASCADE_DET);
        _elems.put(ELEM_PU_META, ELEM_PU_META);
        _elems.put(ELEM_PU_DEF, ELEM_PU_DEF);
        _elems.put(ELEM_XML_MAP_META_COMPLETE, ELEM_XML_MAP_META_COMPLETE);
        _elems.put(ELEM_DELIM_IDS, ELEM_DELIM_IDS);
        _elems.put("entity-listeners", (Object)MetaDataTag.ENTITY_LISTENERS);
        _elems.put("pre-persist", (Object)MetaDataTag.PRE_PERSIST);
        _elems.put("post-persist", (Object)MetaDataTag.POST_PERSIST);
        _elems.put("pre-remove", (Object)MetaDataTag.PRE_REMOVE);
        _elems.put("post-remove", (Object)MetaDataTag.POST_REMOVE);
        _elems.put("pre-update", (Object)MetaDataTag.PRE_UPDATE);
        _elems.put("post-update", (Object)MetaDataTag.POST_UPDATE);
        _elems.put("post-load", (Object)MetaDataTag.POST_LOAD);
        _elems.put("exclude-default-listeners", (Object)MetaDataTag.EXCLUDE_DEFAULT_LISTENERS);
        _elems.put("exclude-superclass-listeners", (Object)MetaDataTag.EXCLUDE_SUPERCLASS_LISTENERS);
        _elems.put("named-query", (Object)MetaDataTag.QUERY);
        _elems.put("named-native-query", (Object)MetaDataTag.NATIVE_QUERY);
        _elems.put("hint", (Object)MetaDataTag.QUERY_HINT);
        _elems.put("query", (Object)MetaDataTag.QUERY_STRING);
        _elems.put("flush-mode", (Object)MetaDataTag.FLUSH_MODE);
        _elems.put("sequence-generator", (Object)MetaDataTag.SEQ_GENERATOR);
        _elems.put("id", (Object)MetaDataTag.ID);
        _elems.put("id-class", (Object)MetaDataTag.ID_CLASS);
        _elems.put("embedded-id", (Object)MetaDataTag.EMBEDDED_ID);
        _elems.put("maps-id", (Object)MetaDataTag.MAPPED_BY_ID);
        _elems.put("version", (Object)MetaDataTag.VERSION);
        _elems.put("generated-value", (Object)MetaDataTag.GENERATED_VALUE);
        _elems.put("map-key", (Object)MetaDataTag.MAP_KEY);
        _elems.put("order-by", (Object)MetaDataTag.ORDER_BY);
        _elems.put("order-column", (Object)MetaDataTag.ORDER_COLUMN);
        _elems.put("lob", (Object)MetaDataTag.LOB);
        _elems.put("data-store-id", (Object)MetaDataTag.DATASTORE_ID);
        _elems.put("data-cache", (Object)MetaDataTag.DATA_CACHE);
        _elems.put("basic", (Object)PersistenceStrategy.BASIC);
        _elems.put("many-to-one", (Object)PersistenceStrategy.MANY_ONE);
        _elems.put("one-to-one", (Object)PersistenceStrategy.ONE_ONE);
        _elems.put("embedded", (Object)PersistenceStrategy.EMBEDDED);
        _elems.put("one-to-many", (Object)PersistenceStrategy.ONE_MANY);
        _elems.put("many-to-many", (Object)PersistenceStrategy.MANY_MANY);
        _elems.put("transient", (Object)PersistenceStrategy.TRANSIENT);
        _elems.put("element-collection", (Object)PersistenceStrategy.ELEM_COLL);
        _elems.put("persistent", (Object)PersistenceStrategy.PERS);
        _elems.put("persistent-collection", (Object)PersistenceStrategy.PERS_COLL);
        _elems.put("persistent-map", (Object)PersistenceStrategy.PERS_MAP);
        _elems.put("map-key-class", (Object)MetaDataTag.MAP_KEY_CLASS);
        _elems.put("read-only", (Object)MetaDataTag.READ_ONLY);
        _elems.put("external-values", (Object)MetaDataTag.EXTERNAL_VALS);
        _elems.put("external-value", (Object)MetaDataTag.EXTERNAL_VAL);
        _elems.put("externalizer", (Object)MetaDataTag.EXTERNALIZER);
        _elems.put("factory", (Object)MetaDataTag.FACTORY);
        _elems.put("fetch-groups", (Object)MetaDataTag.FETCH_GROUPS);
        _elems.put("fetch-group", (Object)MetaDataTag.FETCH_GROUP);
        _elems.put("fetch-attribute", (Object)MetaDataTag.FETCH_ATTRIBUTE);
        _elems.put("referenced-fetch-group", (Object)MetaDataTag.REFERENCED_FETCH_GROUP);
        _elems.put("openjpa-version", (Object)MetaDataTag.OPENJPA_VERSION);
        _loc = Localizer.forPackage(XMLPersistenceMetaDataParser.class);
    }

    protected static enum localDBIdentifiers {
        SEQUENCE_GEN_SEQ_NAME,
        SEQUENCE_GEN_SCHEMA;

    }
}

