/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net;

import com.tc.util.concurrent.ThreadUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressChecker {
    private static Logger LOGGER = LoggerFactory.getLogger(AddressChecker.class);
    private final Set<InetAddress> allLocalAddresses = this.findAllLocalAddresses();
    private static final int NTTL;

    public Set<InetAddress> getAllLocalAddresses() {
        return this.allLocalAddresses;
    }

    public static InetAddress getByName(String hostname, int retry) throws UnknownHostException {
        for (int x = 0; x <= retry; ++x) {
            try {
                return InetAddress.getByName(hostname);
            }
            catch (UnknownHostException unknown) {
                if (x == retry) continue;
                LOGGER.warn("Unable to resolve the hostname provided, waiting for {} seconds and retrying", (Object)NTTL);
                ThreadUtil.reallySleep(NTTL * 1000);
                continue;
            }
        }
        throw new UnknownHostException(hostname);
    }

    public boolean isLegalBindAddress(InetAddress bindAddress) {
        if (bindAddress.isAnyLocalAddress()) {
            return true;
        }
        if (bindAddress.isLoopbackAddress()) {
            return true;
        }
        return this.allLocalAddresses.contains(bindAddress);
    }

    private Set<InetAddress> findAllLocalAddresses() {
        Enumeration<NetworkInterface> nics;
        HashSet<InetAddress> rv = new HashSet<InetAddress>();
        try {
            nics = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        while (nics.hasMoreElements()) {
            NetworkInterface nic = nics.nextElement();
            Enumeration<InetAddress> ips = nic.getInetAddresses();
            while (ips.hasMoreElements()) {
                rv.add(ips.nextElement());
            }
        }
        return Collections.unmodifiableSet(rv);
    }

    static {
        String nTTLProp = Security.getProperty("networkaddress.cache.negative.ttl");
        if (nTTLProp == null) {
            nTTLProp = "10";
        }
        NTTL = Integer.parseInt(nTTLProp);
    }
}

