/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import java.io.IOException;

public class EntityID
implements TCSerializable<EntityID> {
    public static final EntityID NULL_ID = new EntityID("UNKNOWN", "UNKNOWN");
    private final String className;
    private final String entityName;

    public EntityID(String className, String entityName) {
        this.entityName = entityName;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityID that = (EntityID)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        return this.entityName.equals(that.entityName);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.entityName.hashCode();
        return result;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeString(this.className);
        serialOutput.writeString(this.entityName);
    }

    @Override
    public EntityID deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        return EntityID.readFrom(serialInput);
    }

    public static EntityID readFrom(TCByteBufferInput serialInput) throws IOException {
        return new EntityID(serialInput.readString(), serialInput.readString());
    }

    public String toString() {
        return "EntityID{className='" + this.className + '\'' + ", entityName='" + this.entityName + '\'' + '}';
    }
}

