/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.sequence;

import com.tc.util.sequence.Sequence;
import com.tc.util.sequence.SimpleSequence;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SequenceGenerator {
    private final Map<Object, Sequence> map = new ConcurrentHashMap<Object, Sequence>();
    private final SequenceGeneratorListener listener;

    public SequenceGenerator() {
        this(null);
    }

    public SequenceGenerator(SequenceGeneratorListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSequence(Object key) throws SequenceGeneratorException {
        Sequence seq = this.map.get(key);
        if (seq != null) {
            return seq.next();
        }
        Map<Object, Sequence> map = this.map;
        synchronized (map) {
            if (!this.map.containsKey(key)) {
                if (this.listener != null) {
                    this.listener.sequenceCreatedFor(key);
                }
                seq = new SimpleSequence();
                this.map.put(key, seq);
            } else {
                seq = this.map.get(key);
            }
        }
        return seq.next();
    }

    public void clearSequenceFor(Object key) {
        if (this.map.remove(key) != null && this.listener != null) {
            this.listener.sequenceDestroyedFor(key);
        }
    }

    public static interface SequenceGeneratorListener {
        public void sequenceCreatedFor(Object var1) throws SequenceGeneratorException;

        public void sequenceDestroyedFor(Object var1);
    }

    public static class SequenceGeneratorException
    extends Exception {
        public SequenceGeneratorException(Exception e) {
            super(e);
        }
    }
}

