/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import org.terracotta.lease.LeaseResponse;
import org.terracotta.lease.LeaseResponseType;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class LeaseRequestResult
implements LeaseResponse {
    private final boolean connectionGood;
    private final boolean leaseGranted;
    private final long leaseLength;

    public static LeaseRequestResult leaseNotGranted() {
        return new LeaseRequestResult(true, false, -1L);
    }

    public static LeaseRequestResult leaseGranted(long leaseLength) {
        if (leaseLength <= 0L) {
            throw new IllegalArgumentException("Granting a non-positive length lease is not allowed: " + leaseLength);
        }
        return new LeaseRequestResult(true, true, leaseLength);
    }

    public static LeaseRequestResult oldConnection() {
        return new LeaseRequestResult(false, false, -1L);
    }

    private LeaseRequestResult(boolean connectionGood, boolean leaseGranted, long leaseLength) {
        this.connectionGood = connectionGood;
        this.leaseGranted = leaseGranted;
        this.leaseLength = leaseLength;
    }

    public boolean isConnectionGood() {
        return this.connectionGood;
    }

    public boolean isLeaseGranted() {
        return this.leaseGranted;
    }

    public long getLeaseLength() {
        if (this.leaseLength <= 0L) {
            throw new IllegalStateException("Attempt to get the lease length when the lease was not granted");
        }
        return this.leaseLength;
    }

    @Override
    public LeaseResponseType getType() {
        return LeaseResponseType.LEASE_REQUEST_RESULT;
    }

    public static void addStruct(StructBuilder parentBuilder, int index) {
        StructBuilder builder = StructBuilder.newStructBuilder();
        builder.bool("connectionGood", 10);
        builder.bool("leaseGranted", 20);
        builder.int64("leaseLength", 30);
        Struct struct = builder.build();
        parentBuilder.struct("leaseRequestResult", index, struct);
    }

    @Override
    public void encode(StructEncoder<Void> parentEncoder) {
        StructEncoder<StructEncoder<Void>> encoder = parentEncoder.struct("leaseRequestResult");
        encoder.bool("connectionGood", this.connectionGood);
        encoder.bool("leaseGranted", this.leaseGranted);
        encoder.int64("leaseLength", this.leaseLength);
        encoder.end();
    }

    public static LeaseResponse decode(StructDecoder<Void> parentDecoder) {
        StructDecoder<StructDecoder<Void>> decoder = parentDecoder.struct("leaseRequestResult");
        boolean connectionGood = decoder.bool("connectionGood");
        boolean leaseGranted = decoder.bool("leaseGranted");
        long leaseLength = decoder.int64("leaseLength");
        return new LeaseRequestResult(connectionGood, leaseGranted, leaseLength);
    }
}

