/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;

public enum AnyTypeKind {
    USER(UserTO.class, UserCR.class, UserUR.class),
    GROUP(GroupTO.class, GroupCR.class, GroupUR.class),
    ANY_OBJECT(AnyObjectTO.class, AnyObjectCR.class, AnyObjectUR.class);

    private final Class<? extends AnyTO> toClass;
    private final Class<? extends AnyCR> crClass;
    private final Class<? extends AnyUR> urClass;

    private AnyTypeKind(Class<? extends AnyTO> toClass, Class<? extends AnyCR> crClass, Class<? extends AnyUR> urClass) {
        this.toClass = toClass;
        this.crClass = crClass;
        this.urClass = urClass;
    }

    public Class<? extends AnyTO> getTOClass() {
        return this.toClass;
    }

    public Class<? extends AnyCR> getCRClass() {
        return this.crClass;
    }

    public Class<? extends AnyUR> getURClass() {
        return this.urClass;
    }

    public static AnyTypeKind fromTOClass(Class<? extends AnyTO> clazz) {
        return UserTO.class.isAssignableFrom(clazz) ? USER : (GroupTO.class.isAssignableFrom(clazz) ? GROUP : ANY_OBJECT);
    }
}

