/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20AccessTokenAuthenticator;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAccessTokenAuthenticator
extends OAuth20AccessTokenAuthenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAccessTokenAuthenticator.class);
    private final OAuth20TokenSigningAndEncryptionService idTokenSigningAndEncryptionService;
    private final ServicesManager servicesManager;

    public OidcAccessTokenAuthenticator(TicketRegistry ticketRegistry, OAuth20TokenSigningAndEncryptionService signingAndEncryptionService, ServicesManager servicesManager, JwtBuilder accessTokenJwtBuilder, OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy) {
        super(ticketRegistry, accessTokenJwtBuilder, profileScopeToAttributesFilter, authenticationAttributeReleasePolicy);
        this.idTokenSigningAndEncryptionService = signingAndEncryptionService;
        this.servicesManager = servicesManager;
    }

    protected CommonProfile buildUserProfile(TokenCredentials tokenCredentials, WebContext webContext, OAuth20AccessToken accessToken) {
        try {
            CommonProfile profile = super.buildUserProfile(tokenCredentials, webContext, accessToken);
            this.validateIdTokenIfAny(accessToken, profile);
            return profile;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    protected void validateIdTokenIfAny(OAuth20AccessToken accessToken, CommonProfile profile) throws MalformedClaimException {
        if (StringUtils.isNotBlank((CharSequence)accessToken.getIdToken())) {
            OAuthRegisteredService service = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)accessToken.getClientId());
            JwtClaims idTokenResult = this.idTokenSigningAndEncryptionService.decode(accessToken.getIdToken(), Optional.ofNullable(service));
            profile.setId(idTokenResult.getSubject());
            profile.addAttributes(idTokenResult.getClaimsMap());
        }
    }
}

