/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.scopes;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcOpenIdScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;

public class DefaultOidcAttributeReleasePolicyFactory
implements OidcAttributeReleasePolicyFactory {
    private final CasConfigurationProperties casProperties;

    @Override
    public BaseOidcScopeAttributeReleasePolicy get(OidcConstants.StandardScopes scope) {
        switch (scope) {
            case EMAIL: {
                return new OidcEmailScopeAttributeReleasePolicy();
            }
            case ADDRESS: {
                return new OidcAddressScopeAttributeReleasePolicy();
            }
            case OPENID: {
                return new OidcOpenIdScopeAttributeReleasePolicy();
            }
            case PHONE: {
                return new OidcPhoneScopeAttributeReleasePolicy();
            }
            case PROFILE: {
                return new OidcProfileScopeAttributeReleasePolicy();
            }
        }
        return null;
    }

    @Override
    public OidcCustomScopeAttributeReleasePolicy custom(String name, List<String> allowedAttributes) {
        return new OidcCustomScopeAttributeReleasePolicy(name, allowedAttributes);
    }

    @Override
    public Collection<OidcCustomScopeAttributeReleasePolicy> getUserDefinedScopes() {
        return this.from(this.casProperties.getAuthn().getOidc().getCore().getUserDefinedScopes());
    }

    @Generated
    public DefaultOidcAttributeReleasePolicyFactory(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

