/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcClientRegistrationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.credentials.password.SpringSecurityPasswordEncoder;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.service.InMemoryProfileService;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class OidcInitialAccessTokenController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcInitialAccessTokenController.class);
    private final BaseClient accessTokenClient = new HeaderClient();

    public OidcInitialAccessTokenController(OidcConfigurationContext configurationContext) {
        super(configurationContext);
        CasConfigurationProperties casProperties = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties();
        OidcProperties oidcProperties = casProperties.getAuthn().getOidc();
        if (oidcProperties.getRegistration().getDynamicClientRegistrationMode().isProtected()) {
            CommonProfile authProfile = new CommonProfile();
            OidcClientRegistrationProperties registration = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc().getRegistration();
            authProfile.setId((String)StringUtils.defaultIfBlank((CharSequence)registration.getInitialAccessTokenUser(), (CharSequence)RandomUtils.randomAlphabetic((int)8)));
            authProfile.addAttribute("username", (Object)authProfile.getId());
            this.accessTokenClient.setCredentialsExtractor((CredentialsExtractor)new BasicAuthExtractor());
            InMemoryProfileService authenticator = new InMemoryProfileService(objects -> authProfile);
            authenticator.setPasswordEncoder((PasswordEncoder)new SpringSecurityPasswordEncoder(NoOpPasswordEncoder.getInstance()));
            authenticator.create(authProfile, (String)StringUtils.defaultIfBlank((CharSequence)registration.getInitialAccessTokenPassword(), (CharSequence)RandomUtils.randomAlphabetic((int)8)));
            this.accessTokenClient.setAuthenticator((Authenticator)authenticator);
            this.accessTokenClient.setName(UUID.randomUUID().toString());
            this.accessTokenClient.init();
        }
    }

    @GetMapping(value={"/oidc/initToken", "/**/initToken"}, produces={"application/json"})
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "initToken")) {
            Map body = OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer");
            ModelAndView mv = new ModelAndView((View)new MappingJackson2JsonView(), body);
            mv.setStatus(HttpStatus.BAD_REQUEST);
            return mv;
        }
        CasConfigurationProperties casProperties = ((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties();
        OidcProperties oidcProperties = casProperties.getAuthn().getOidc();
        if (!oidcProperties.getRegistration().getDynamicClientRegistrationMode().isProtected()) {
            LOGGER.warn("Dynamic client registration mode is not configured as protected.");
            return this.getBadRequestResponseEntity(HttpStatus.NOT_ACCEPTABLE);
        }
        Optional results = this.accessTokenClient.getCredentials((WebContext)webContext, ((OidcConfigurationContext)this.getConfigurationContext()).getSessionStore());
        return results.map(profile -> {
            Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(profile.getUserProfile().getId());
            WebApplicationService service = (WebApplicationService)((OidcConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(casProperties.getServer().getPrefix());
            AccessTokenRequestContext holder = AccessTokenRequestContext.builder().authentication(DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).build()).service((Service)service).grantType(OAuth20GrantTypes.NONE).responseType(OAuth20ResponseTypes.NONE).scopes(Set.of(OidcConstants.StandardScopes.OPENID.getScope(), "client_registration_scope")).build();
            return this.generateInitialAccessToken(holder).map(accessToken -> {
                OAuth20TokenGeneratedResult accessTokenResult = OAuth20TokenGeneratedResult.builder().registeredService((RegisteredService)holder.getRegisteredService()).accessToken(accessToken).grantType(holder.getGrantType()).responseType(holder.getResponseType()).build();
                OAuth20AccessTokenResponseResult tokenResult = OAuth20AccessTokenResponseResult.builder().registeredService((RegisteredService)holder.getRegisteredService()).service(holder.getService()).accessTokenTimeout(accessToken.getExpiresIn()).responseType(accessToken.getResponseType()).casProperties(((OidcConfigurationContext)this.getConfigurationContext()).getCasProperties()).generatedToken(accessTokenResult).grantType(accessToken.getGrantType()).userProfile(profile.getUserProfile()).build();
                return ((OidcConfigurationContext)this.getConfigurationContext()).getAccessTokenResponseGenerator().generate(tokenResult);
            }).orElseGet(() -> this.getBadRequestResponseEntity(HttpStatus.BAD_REQUEST));
        }).orElseGet(() -> this.getBadRequestResponseEntity(HttpStatus.UNAUTHORIZED));
    }

    protected ModelAndView getBadRequestResponseEntity(HttpStatus status) {
        ModelAndView mv = new ModelAndView((View)new MappingJackson2JsonView());
        mv.setStatus(status);
        return mv;
    }

    protected Optional<OAuth20AccessToken> generateInitialAccessToken(AccessTokenRequestContext holder) {
        return (Optional)FunctionUtils.doAndHandle(() -> {
            OAuth20TokenGeneratedResult accessTokenResult = ((OidcConfigurationContext)this.getConfigurationContext()).getAccessTokenGenerator().generate(holder);
            OAuth20AccessToken accessToken = (OAuth20AccessToken)accessTokenResult.getAccessToken().get();
            ((OidcConfigurationContext)this.getConfigurationContext()).getTicketRegistry().addTicket((Ticket)accessToken);
            return Optional.of(accessToken);
        }, e -> Optional.empty()).get();
    }
}

