/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.persistence.entity;

import java.io.Serializable;
import org.flowable.common.engine.api.management.TablePage;
import org.flowable.common.engine.api.management.TablePageQuery;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;

public class TablePageQueryImpl
implements TablePageQuery,
Command<TablePage>,
Serializable {
    private static final long serialVersionUID = 1L;
    transient CommandExecutor commandExecutor;
    transient AbstractEngineConfiguration engineConfiguration;
    protected String tableName;
    protected String order;
    protected int firstResult;
    protected int maxResults;

    public TablePageQueryImpl() {
    }

    public TablePageQueryImpl(CommandExecutor commandExecutor, AbstractEngineConfiguration engineConfiguration) {
        this.commandExecutor = commandExecutor;
        this.engineConfiguration = engineConfiguration;
    }

    public TablePageQueryImpl tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TablePageQueryImpl orderAsc(String column) {
        this.addOrder(column, "asc");
        return this;
    }

    public TablePageQueryImpl orderDesc(String column) {
        this.addOrder(column, "desc");
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected void addOrder(String column, String sortOrder) {
        this.order = this.order == null ? "" : this.order + ", ";
        this.order = this.order + column + " " + sortOrder;
    }

    public TablePage listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this.commandExecutor.execute(this);
    }

    @Override
    public TablePage execute(CommandContext commandContext) {
        return this.engineConfiguration.getTableDataManager().getTablePage(this, this.firstResult, this.maxResults);
    }

    public String getOrder() {
        return this.order;
    }
}

