/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.ticket.AuthenticatedServicesAwareTicketGrantingTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.ISOStandardDateFormat;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@RestControllerEndpoint(id="ssoSessions", enableByDefault=false)
public class SingleSignOnSessionsEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleSignOnSessionsEndpoint.class);
    private static final String STATUS = "status";
    private static final String TICKET_GRANTING_TICKET = "ticketGrantingTicket";
    private final TicketRegistry ticketRegistry;
    private final ObjectProvider<SingleLogoutRequestExecutor> singleLogoutRequestExecutor;

    public SingleSignOnSessionsEndpoint(TicketRegistry ticketRegistry, CasConfigurationProperties casProperties, ObjectProvider<SingleLogoutRequestExecutor> singleLogoutRequestExecutor) {
        super(casProperties);
        this.ticketRegistry = ticketRegistry;
        this.singleLogoutRequestExecutor = singleLogoutRequestExecutor;
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Get all single sign-on sessions with the given type. The functionality provided here requires that the underlying ticket registry and store is able to store, maintain and return a collection tickets that represent the single sign-on session. You will not be able to collect and review sessions, if the ticket registry does not have this capability")
    public Map<String, Object> getSsoSessions(@Nullable @RequestParam(name="type", required=false) String type, @Nullable @RequestParam(name="username", required=false) String username, @RequestParam(name="from", required=false, defaultValue="0") long from, @RequestParam(name="count", required=false, defaultValue="1000") long count) {
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>();
        SsoSessionReportOptions option = Optional.ofNullable(type).map(SsoSessionReportOptions::valueOf).orElse(SsoSessionReportOptions.ALL);
        Collection<Map<String, Object>> activeSsoSessions = this.getActiveSsoSessions(option, username, from, count);
        sessionsMap.put("activeSsoSessions", activeSsoSessions);
        AtomicLong totalTicketGrantingTickets = new AtomicLong();
        AtomicLong totalProxyGrantingTickets = new AtomicLong();
        AtomicLong totalUsageCount = new AtomicLong();
        HashSet<String> uniquePrincipals = new HashSet<String>(activeSsoSessions.size());
        for (Map<String, Object> activeSsoSession : activeSsoSessions) {
            if (activeSsoSession.containsKey(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey())) {
                Boolean isProxied = Boolean.valueOf(activeSsoSession.get(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey()).toString());
                if (isProxied.booleanValue()) {
                    totalProxyGrantingTickets.incrementAndGet();
                } else {
                    totalTicketGrantingTickets.incrementAndGet();
                    String principal = activeSsoSession.get(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.getAttributeKey()).toString();
                    uniquePrincipals.add(principal);
                }
            } else {
                totalTicketGrantingTickets.incrementAndGet();
                String principal = activeSsoSession.get(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.getAttributeKey()).toString();
                uniquePrincipals.add(principal);
            }
            long uses = Long.parseLong(activeSsoSession.get(SsoSessionAttributeKeys.NUMBER_OF_USES.getAttributeKey()).toString());
            totalUsageCount.getAndAdd(uses);
        }
        sessionsMap.put("totalProxyGrantingTickets", totalProxyGrantingTickets);
        sessionsMap.put("totalTicketGrantingTickets", totalTicketGrantingTickets);
        sessionsMap.put("totalTickets", totalTicketGrantingTickets.longValue() + totalProxyGrantingTickets.longValue());
        sessionsMap.put("totalPrincipals", uniquePrincipals.size());
        sessionsMap.put("totalUsageCount", totalUsageCount);
        return sessionsMap;
    }

    @DeleteMapping(path={"/{ticketGrantingTicket}"}, produces={"application/json"})
    @Operation(summary="Remove single sign-on session for ticket id")
    public Map<String, Object> destroySsoSession(@PathVariable String ticketGrantingTicket, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
        try {
            List sloRequests = ((SingleLogoutRequestExecutor)this.singleLogoutRequestExecutor.getObject()).execute(ticketGrantingTicket, request, response);
            sessionsMap.put(STATUS, 200);
            sessionsMap.put(TICKET_GRANTING_TICKET, ticketGrantingTicket);
            sessionsMap.put("singleLogoutRequests", sloRequests);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            sessionsMap.put(STATUS, 500);
            sessionsMap.put(TICKET_GRANTING_TICKET, ticketGrantingTicket);
            sessionsMap.put("message", e.getMessage());
        }
        return sessionsMap;
    }

    @Operation(summary="Remove single sign-on session for type and user")
    @DeleteMapping(produces={"application/json"})
    public Map<String, Object> destroySsoSessions(@Nullable @RequestParam(name="type", required=false) String type, @Nullable @RequestParam(name="username", required=false) String username, @RequestParam(name="from", required=false, defaultValue="0") long from, @RequestParam(name="count", required=false, defaultValue="1000") long count, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)type)) {
            return Map.of(STATUS, 400);
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
            Stream<Ticket> tickets = this.ticketRegistry.getSessionsFor(username);
            if (from >= 0L) {
                tickets = tickets.skip(from);
            }
            if (count >= 0L) {
                tickets = tickets.limit(count);
            }
            tickets.forEach(ticket -> sessionsMap.put(ticket.getId(), this.destroySsoSession(ticket.getId(), request, response)));
            return sessionsMap;
        }
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>();
        SsoSessionReportOptions option = SsoSessionReportOptions.valueOf(type);
        Collection<Map<String, Object>> collection = this.getActiveSsoSessions(option, username, from, count);
        collection.stream().map(sso -> sso.get(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET.getAttributeKey()).toString()).forEach(ticketGrantingTicket -> this.destroySsoSession((String)ticketGrantingTicket, request, response));
        sessionsMap.put(STATUS, 200);
        return sessionsMap;
    }

    private Collection<Map<String, Object>> getActiveSsoSessions(SsoSessionReportOptions option, String username, long from, long count) {
        ISOStandardDateFormat dateFormat = new ISOStandardDateFormat();
        return this.getNonExpiredTicketGrantingTickets(from, count).map(TicketGrantingTicket.class::cast).filter(tgt -> option != SsoSessionReportOptions.DIRECT || tgt.getProxiedBy() == null).filter(tgt -> StringUtils.isBlank((CharSequence)username) || StringUtils.equalsIgnoreCase((CharSequence)username, (CharSequence)tgt.getAuthentication().getPrincipal().getId())).map(tgt -> {
            Authentication authentication = tgt.getAuthentication();
            Principal principal = authentication.getPrincipal();
            HashMap<String, Object> sso = new HashMap<String, Object>(SsoSessionAttributeKeys.values().length);
            sso.put(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.getAttributeKey(), principal.getId());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE.getAttributeKey(), authentication.getAuthenticationDate());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE_FORMATTED.getAttributeKey(), dateFormat.format(DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate())));
            sso.put(SsoSessionAttributeKeys.NUMBER_OF_USES.getAttributeKey(), tgt.getCountOfUses());
            sso.put(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET.getAttributeKey(), tgt.getId());
            sso.put(SsoSessionAttributeKeys.PRINCIPAL_ATTRIBUTES.getAttributeKey(), principal.getAttributes());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_ATTRIBUTES.getAttributeKey(), authentication.getAttributes());
            LinkedHashMap<String, Object> policy = new LinkedHashMap<String, Object>();
            policy.put("timeToIdle", tgt.getExpirationPolicy().getTimeToIdle());
            policy.put("timeToLive", tgt.getExpirationPolicy().getTimeToLive());
            policy.put("clock", tgt.getExpirationPolicy().getClock().toString());
            policy.put("name", tgt.getExpirationPolicy().getName());
            sso.put(SsoSessionAttributeKeys.EXPIRATION_POLICY.getAttributeKey(), policy);
            sso.put(SsoSessionAttributeKeys.REMEMBER_ME.getAttributeKey(), CoreAuthenticationUtils.isRememberMeAuthentication((Authentication)authentication));
            if (option != SsoSessionReportOptions.DIRECT) {
                if (tgt.getProxiedBy() != null) {
                    sso.put(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey(), Boolean.TRUE);
                    sso.put(SsoSessionAttributeKeys.PROXIED_BY.getAttributeKey(), tgt.getProxiedBy().getId());
                } else {
                    sso.put(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey(), Boolean.FALSE);
                }
            }
            if (tgt instanceof AuthenticatedServicesAwareTicketGrantingTicket) {
                Map services = ((AuthenticatedServicesAwareTicketGrantingTicket)tgt).getServices();
                sso.put(SsoSessionAttributeKeys.AUTHENTICATED_SERVICES.getAttributeKey(), services);
            }
            return sso;
        }).collect(Collectors.toList());
    }

    private Stream<? extends Ticket> getNonExpiredTicketGrantingTickets(long from, long count) {
        Stream tickets = this.ticketRegistry.getTickets(ticket -> ticket instanceof TicketGrantingTicket && !ticket.isExpired());
        if (from >= 0L) {
            tickets = tickets.skip(from);
        }
        if (count >= 0L) {
            tickets = tickets.limit(count);
        }
        return tickets;
    }

    @Generated
    public String toString() {
        return "SingleSignOnSessionsEndpoint(ticketRegistry=" + this.ticketRegistry + ", singleLogoutRequestExecutor=" + this.singleLogoutRequestExecutor + ")";
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public ObjectProvider<SingleLogoutRequestExecutor> getSingleLogoutRequestExecutor() {
        return this.singleLogoutRequestExecutor;
    }

    static enum SsoSessionAttributeKeys {
        AUTHENTICATED_PRINCIPAL("authenticated_principal"),
        PRINCIPAL_ATTRIBUTES("principal_attributes"),
        AUTHENTICATION_DATE("authentication_date"),
        AUTHENTICATION_DATE_FORMATTED("authentication_date_formatted"),
        TICKET_GRANTING_TICKET("ticket_granting_ticket"),
        AUTHENTICATION_ATTRIBUTES("authentication_attributes"),
        PROXIED_BY("proxied_by"),
        AUTHENTICATED_SERVICES("authenticated_services"),
        IS_PROXIED("is_proxied"),
        REMEMBER_ME("remember_me"),
        EXPIRATION_POLICY("expiration_policy"),
        NUMBER_OF_USES("number_of_uses");

        private final String attributeKey;

        private SsoSessionAttributeKeys(String attributeKey) {
            this.attributeKey = attributeKey;
        }

        @Generated
        public String getAttributeKey() {
            return this.attributeKey;
        }
    }

    static enum SsoSessionReportOptions {
        ALL("ALL"),
        PROXIED("PROXIED"),
        DIRECT("DIRECT");

        private final String type;

        @Generated
        private SsoSessionReportOptions(String type) {
            this.type = type;
        }

        @Generated
        public String getType() {
            return this.type;
        }
    }
}

