/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

public abstract class EnumeratingWhitelist
extends Whitelist {
    protected final ConcurrentHashMap<String, Boolean> permittedCache = new ConcurrentHashMap();

    protected abstract List<MethodSignature> methodSignatures();

    protected abstract List<NewSignature> newSignatures();

    protected abstract List<MethodSignature> staticMethodSignatures();

    protected abstract List<FieldSignature> fieldSignatures();

    protected abstract List<FieldSignature> staticFieldSignatures();

    @Override
    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        String key = EnumeratingWhitelist.canonicalMethodSig(method);
        Boolean b = this.permittedCache.get(key);
        if (b != null) {
            return b;
        }
        boolean output = false;
        for (MethodSignature s : this.methodSignatures()) {
            if (!s.matches(method)) continue;
            output = true;
            break;
        }
        this.permittedCache.put(key, output);
        return output;
    }

    @Override
    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        String key = EnumeratingWhitelist.canonicalConstructorSig(constructor);
        Boolean b = this.permittedCache.get(key);
        if (b != null) {
            return b;
        }
        boolean output = false;
        for (NewSignature s : this.newSignatures()) {
            if (!s.matches(constructor)) continue;
            output = true;
            break;
        }
        this.permittedCache.put(key, output);
        return output;
    }

    @Override
    public boolean permitsStaticMethod(Method method, Object[] args) {
        String key = EnumeratingWhitelist.canonicalStaticMethodSig(method);
        Boolean b = this.permittedCache.get(key);
        if (b != null) {
            return b;
        }
        boolean output = false;
        for (MethodSignature s : this.staticMethodSignatures()) {
            if (!s.matches(method)) continue;
            output = true;
            break;
        }
        this.permittedCache.put(key, output);
        return output;
    }

    @Override
    public boolean permitsFieldGet(Field field, Object receiver) {
        String key = EnumeratingWhitelist.canonicalFieldSig(field);
        Boolean b = this.permittedCache.get(key);
        if (b != null) {
            return b;
        }
        boolean output = false;
        for (FieldSignature s : this.fieldSignatures()) {
            if (!s.matches(field)) continue;
            output = true;
            break;
        }
        this.permittedCache.put(key, output);
        return output;
    }

    @Override
    public boolean permitsFieldSet(Field field, Object receiver, Object value) {
        return this.permitsFieldGet(field, receiver);
    }

    @Override
    public boolean permitsStaticFieldGet(Field field) {
        String key = EnumeratingWhitelist.canonicalStaticFieldSig(field);
        Boolean b = this.permittedCache.get(key);
        if (b != null) {
            return b;
        }
        boolean output = false;
        for (FieldSignature s : this.staticFieldSignatures()) {
            if (!s.matches(field)) continue;
            output = true;
            break;
        }
        this.permittedCache.put(key, output);
        return output;
    }

    @Override
    public boolean permitsStaticFieldSet(Field field, Object value) {
        return this.permitsStaticFieldGet(field);
    }

    public static String getName(Class<?> c) {
        Class<?> e = c.getComponentType();
        if (e == null) {
            return c.getName();
        }
        return EnumeratingWhitelist.getName(e) + "[]";
    }

    public static String getName(Object o) {
        return o == null ? "null" : EnumeratingWhitelist.getName(o.getClass());
    }

    private static boolean is(String thisIdentifier, String identifier) {
        return thisIdentifier.equals("*") || identifier.equals(thisIdentifier);
    }

    static final StringBuilder joinWithSpaces(StringBuilder b, String[] types) {
        for (String type : types) {
            b.append(' ').append(type);
        }
        return b;
    }

    static String[] argumentTypes(Class<?>[] argumentTypes) {
        String[] s = new String[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            s[i] = EnumeratingWhitelist.getName(argumentTypes[i]);
        }
        return s;
    }

    static String canonicalFieldString(Field field) {
        return EnumeratingWhitelist.getName(field.getDeclaringClass()) + ' ' + field.getName();
    }

    static String canonicalMethodString(Method method) {
        return EnumeratingWhitelist.joinWithSpaces(new StringBuilder(EnumeratingWhitelist.getName(method.getDeclaringClass())).append(' ').append(method.getName()), EnumeratingWhitelist.argumentTypes(method.getParameterTypes())).toString();
    }

    static String canonicalConstructorString(Constructor<?> cons) {
        return EnumeratingWhitelist.joinWithSpaces(new StringBuilder(EnumeratingWhitelist.getName(cons.getDeclaringClass())), EnumeratingWhitelist.argumentTypes(cons.getParameterTypes())).toString();
    }

    static String canonicalMethodSig(Method method) {
        return "method " + EnumeratingWhitelist.canonicalMethodString(method);
    }

    static String canonicalStaticMethodSig(Method method) {
        return "staticMethod " + EnumeratingWhitelist.canonicalMethodString(method);
    }

    static String canonicalConstructorSig(Constructor<?> cons) {
        return "new " + EnumeratingWhitelist.canonicalConstructorString(cons);
    }

    static String canonicalFieldSig(Field field) {
        return "field " + EnumeratingWhitelist.canonicalFieldString(field);
    }

    static String canonicalStaticFieldSig(Field field) {
        return "staticField " + EnumeratingWhitelist.canonicalFieldString(field);
    }

    public static class StaticFieldSignature
    extends FieldSignature {
        public StaticFieldSignature(String type, String field) {
            super(type, field);
        }

        @Override
        public String toString() {
            return "staticField " + this.signaturePart();
        }
    }

    public static class FieldSignature
    extends Signature {
        private final String type;
        private final String field;

        public FieldSignature(String type, String field) {
            this.type = type;
            this.field = field;
        }

        public FieldSignature(Class<?> type, String field) {
            this(EnumeratingWhitelist.getName(type), field);
        }

        boolean matches(Field f) {
            return EnumeratingWhitelist.is(this.field, f.getName()) && EnumeratingWhitelist.getName(f.getDeclaringClass()).equals(this.type);
        }

        @Override
        protected String signaturePart() {
            return this.type + ' ' + this.field;
        }

        @Override
        public String toString() {
            return "field " + this.signaturePart();
        }

        @Override
        protected boolean exists() throws Exception {
            try {
                this.type(this.type).getField(this.field);
                return true;
            }
            catch (NoSuchFieldException x) {
                return false;
            }
        }

        @Override
        public boolean isWildcard() {
            return "*".equals(this.field);
        }
    }

    public static final class NewSignature
    extends Signature {
        private final String type;
        private final String[] argumentTypes;

        public NewSignature(String type, String[] argumentTypes) {
            this.type = type;
            this.argumentTypes = (String[])argumentTypes.clone();
        }

        public NewSignature(Class<?> type, Class<?> ... argumentTypes) {
            this(EnumeratingWhitelist.getName(type), EnumeratingWhitelist.argumentTypes(argumentTypes));
        }

        protected boolean matches(Constructor<?> c) {
            return EnumeratingWhitelist.getName(c.getDeclaringClass()).equals(this.type) && Arrays.equals(EnumeratingWhitelist.argumentTypes(c.getParameterTypes()), this.argumentTypes);
        }

        @Override
        protected String signaturePart() {
            return EnumeratingWhitelist.joinWithSpaces(new StringBuilder(this.type), this.argumentTypes).toString();
        }

        @Override
        public String toString() {
            return "new " + this.signaturePart();
        }

        @Override
        protected boolean exists() throws Exception {
            try {
                this.type(this.type).getDeclaredConstructor(this.types(this.argumentTypes));
                return true;
            }
            catch (NoSuchMethodException x) {
                return false;
            }
        }
    }

    public static class StaticMethodSignature
    extends MethodSignature {
        StaticMethodSignature(String receiverType, String method, String[] argumentTypes) {
            super(receiverType, method, argumentTypes);
        }

        @Override
        public String toString() {
            return "staticMethod " + this.signaturePart();
        }

        @Override
        protected boolean exists() throws Exception {
            try {
                return Modifier.isStatic(this.type(this.receiverType).getDeclaredMethod(this.method, this.types(this.argumentTypes)).getModifiers());
            }
            catch (NoSuchMethodException x) {
                return false;
            }
        }
    }

    public static class MethodSignature
    extends Signature {
        protected final String receiverType;
        protected final String method;
        protected final String[] argumentTypes;

        public MethodSignature(Class<?> receiverType, String method, Class<?> ... argumentTypes) {
            this(EnumeratingWhitelist.getName(receiverType), method, EnumeratingWhitelist.argumentTypes(argumentTypes));
        }

        public MethodSignature(String receiverType, String method, String[] argumentTypes) {
            this.receiverType = receiverType;
            this.method = method;
            this.argumentTypes = (String[])argumentTypes.clone();
        }

        protected boolean matches(Method m) {
            return EnumeratingWhitelist.is(this.method, m.getName()) && EnumeratingWhitelist.getName(m.getDeclaringClass()).equals(this.receiverType) && Arrays.equals(EnumeratingWhitelist.argumentTypes(m.getParameterTypes()), this.argumentTypes);
        }

        @Override
        public String toString() {
            return "method " + this.signaturePart();
        }

        @Override
        protected String signaturePart() {
            return EnumeratingWhitelist.joinWithSpaces(new StringBuilder(this.receiverType).append(' ').append(this.method), this.argumentTypes).toString();
        }

        @Override
        protected boolean exists() throws Exception {
            return this.exists(this.type(this.receiverType), true);
        }

        private boolean exists(Class<?> c, boolean start) throws Exception {
            Class<?> s = c.getSuperclass();
            if (s != null && this.exists(s, false)) {
                return !start;
            }
            for (Class<?> i : c.getInterfaces()) {
                if (!this.exists(i, false)) continue;
                return !start;
            }
            try {
                return !Modifier.isStatic(c.getDeclaredMethod(this.method, this.types(this.argumentTypes)).getModifiers());
            }
            catch (NoSuchMethodException x) {
                return false;
            }
        }

        @Override
        public boolean isWildcard() {
            return "*".equals(this.method);
        }
    }

    public static abstract class Signature
    implements Comparable<Signature> {
        public abstract String toString();

        protected abstract String signaturePart();

        @Override
        public int compareTo(Signature signature) {
            int r = this.signaturePart().compareTo(signature.signaturePart());
            return r != 0 ? r : this.toString().compareTo(signature.toString());
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass() && this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        protected abstract boolean exists() throws Exception;

        final Class<?> type(String name) throws Exception {
            return ClassUtils.getClass((String)name);
        }

        final Class<?>[] types(String[] names) throws Exception {
            Class[] r = new Class[names.length];
            for (int i = 0; i < names.length; ++i) {
                r[i] = this.type(names[i]);
            }
            return r;
        }

        public boolean isWildcard() {
            return false;
        }
    }
}

