/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.database;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnection;
import net.tirasa.connid.bundles.csvdir.database.FileSystem;
import net.tirasa.connid.bundles.csvdir.utilities.Utilities;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;

public class FileToDB {
    public static final String DEFAULT_PREFIX = "DEFAULT";
    private final CSVDirConfiguration conf;
    private final CSVDirConnection conn;
    private final FileSystem fileSystem;
    private static final Log LOG = Log.getLog(FileToDB.class);

    public FileToDB(CSVDirConnection conn) {
        this.conn = conn;
        this.conf = conn.getConf();
        this.fileSystem = new FileSystem(this.conf);
    }

    public String createDbForCreate() {
        File file = this.fileSystem.getLastModifiedCsvFile();
        if (file == null) {
            file = new File(DEFAULT_PREFIX + Utilities.randomNumber() + ".csv");
        }
        return this.bindFileTable(file);
    }

    public String createDbForUpdate(File file) {
        return this.bindFileTable(file);
    }

    public List<String> createDbForSync(File[] fileToProcess) {
        return this.bindFileTables(fileToProcess);
    }

    private StringBuilder createTableHeader(String tableName) {
        StringBuilder tableHeader = new StringBuilder();
        for (String field : this.conf.getFields()) {
            tableHeader.append(field.trim()).append(" ").append("VARCHAR(255), ");
        }
        tableHeader.append("CONSTRAINT ").append(tableName).append("_SYS_PK_").append(Utilities.randomNumber()).append(" PRIMARY KEY (");
        if (!StringUtil.isBlank((String)this.conf.getObjectClassColumn())) {
            tableHeader.append(this.conf.getObjectClassColumn()).append(",");
        }
        String[] keys = this.conf.getKeyColumnNames();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                tableHeader.append(",");
            }
            tableHeader.append(keys[i]);
        }
        tableHeader.append(")");
        return tableHeader;
    }

    private List<String> bindFileTables(File[] files) {
        StringBuilder view = new StringBuilder();
        ArrayList<String> tables = new ArrayList<String>();
        for (File file : files) {
            String tableName = this.bindFileTable(file);
            if (tableName == null) continue;
            tables.add(tableName);
            if (view.length() != 0) {
                view.append(" UNION ");
            }
            view.append("SELECT * FROM ").append(tableName);
        }
        if (view.length() == 0) {
            try {
                LOG.ok("Execute: CREATE TEXT TABLE NOENTRIES", new Object[0]);
                StringBuilder tableHeader = this.createTableHeader("NOENTRIES");
                StringBuilder createTable = new StringBuilder();
                createTable.delete(0, createTable.length());
                createTable.append("CREATE TEXT TABLE NOENTRIES");
                createTable.append(" (").append((CharSequence)tableHeader).append(") ");
                this.conn.getConn().createStatement().execute("DROP TABLE NOENTRIES IF EXISTS CASCADE");
                this.conn.getConn().createStatement().execute(createTable.toString());
                tables.add("NOENTRIES");
                this.conn.getConn().createStatement().execute("CREATE VIEW " + this.conn.getViewname() + " AS SELECT * FROM NOENTRIES");
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "While creating table NOENTRIES", new Object[0]);
            }
        } else {
            try {
                view.insert(0, "CREATE VIEW " + this.conn.getViewname() + " AS ");
                LOG.ok("Execute: {0}", new Object[]{view.toString()});
                this.conn.getConn().createStatement().execute(view.toString());
            }
            catch (SQLException e) {
                LOG.error((Throwable)e, "While creating view {0}", new Object[]{this.conn.getViewname()});
            }
        }
        return tables;
    }

    private String bindFileTable(File file) {
        LOG.ok("File to load {0}", new Object[]{file.getAbsolutePath()});
        String tableName = "CSV_TABLE" + Utilities.randomNumber();
        try {
            this.conn.getConn().createStatement().execute("DROP TABLE " + tableName + " IF EXISTS CASCADE");
            StringBuilder tableHeader = this.createTableHeader(tableName);
            StringBuilder createTable = new StringBuilder();
            StringBuilder linkTable = new StringBuilder();
            createTable.delete(0, createTable.length());
            createTable.append("CREATE TEXT TABLE ").append(tableName);
            createTable.append(" (").append((CharSequence)tableHeader).append(") ");
            linkTable.delete(0, createTable.length());
            linkTable.append("SET TABLE ").append(tableName).append(" SOURCE ").append("\"").append(file.getName()).append(";ignore_first=").append(this.conf.getIgnoreHeader()).append(";all_quoted=").append(this.conf.getQuotationRequired()).append(";fs=").append(this.conf.getEscapedFieldDelimiter()).append(";lvs=").append(this.conf.getTextQualifier() == '\"' ? "\\quote" : Character.valueOf(this.conf.getTextQualifier())).append(";encoding=").append(this.conf.getEncoding()).append("\"");
            LOG.ok("Execute: {0}", new Object[]{createTable.toString()});
            this.conn.getConn().createStatement().execute(createTable.toString());
            LOG.ok("Execute: {0}", new Object[]{linkTable.toString()});
            this.conn.getConn().createStatement().execute(linkTable.toString());
            return tableName;
        }
        catch (SQLException e) {
            LOG.error((Throwable)e, "While creating text table", new Object[0]);
            return null;
        }
    }
}

