/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf;

import java.io.IOException;
import java.time.OffsetDateTime;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.ext.scimv2.api.data.SCIMGroup;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;

@Provider
public class AddETagFilter
implements ContainerResponseFilter {
    public void filter(ContainerRequestContext reqCtx, ContainerResponseContext resCtx) throws IOException {
        if (resCtx.getEntityTag() == null && resCtx.getEntity() instanceof SCIMUser) {
            String etagValue;
            OffsetDateTime lastModified = ((SCIMUser)resCtx.getEntity()).getMeta().getLastModified();
            if (resCtx.getEntity() instanceof SCIMGroup) {
                lastModified = ((SCIMGroup)resCtx.getEntity()).getMeta().getLastModified();
            }
            if (lastModified != null && StringUtils.isNotBlank((CharSequence)(etagValue = String.valueOf(lastModified.toInstant().toEpochMilli())))) {
                resCtx.getHeaders().add((Object)"ETag", (Object)new EntityTag(etagValue, true).toString());
            }
        }
    }
}

