/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.idm.api.PasswordEncoder;
import org.flowable.idm.api.PasswordSalt;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.persistence.entity.UserEntity;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class SaveUserCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected IdmEngineConfiguration idmEngineConfiguration;
    protected User user;

    public SaveUserCmd(User user, IdmEngineConfiguration idmEngineConfiguration) {
        this.user = user;
        this.idmEngineConfiguration = idmEngineConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        if (this.user == null) {
            throw new FlowableIllegalArgumentException("user is null");
        }
        if (this.idmEngineConfiguration.getUserEntityManager().isNewUser(this.user)) {
            if (this.user.getPassword() != null) {
                PasswordEncoder passwordEncoder = this.idmEngineConfiguration.getPasswordEncoder();
                PasswordSalt passwordSalt = this.idmEngineConfiguration.getPasswordSalt();
                this.user.setPassword(passwordEncoder.encode((CharSequence)this.user.getPassword(), passwordSalt));
            }
            if (this.user instanceof UserEntity) {
                this.idmEngineConfiguration.getUserEntityManager().insert((UserEntity)this.user, true);
            } else {
                CommandContextUtil.getDbSqlSession(commandContext).insert((Entity)this.user, this.idmEngineConfiguration.getIdGenerator());
            }
        } else {
            UserEntity dbUser = (UserEntity)this.idmEngineConfiguration.getUserEntityManager().findById(this.user.getId());
            this.user.setPassword(dbUser.getPassword());
            this.idmEngineConfiguration.getUserEntityManager().updateUser(this.user);
        }
        return null;
    }
}

