/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.am.CASSPClientApp;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.jpa.dao.AbstractClientAppDAO;
import org.apache.syncope.core.persistence.jpa.entity.am.JPACASSPClientApp;
import org.springframework.transaction.annotation.Transactional;

public class JPACASSPClientAppDAO
extends AbstractClientAppDAO<CASSPClientApp>
implements CASSPClientAppDAO {
    public CASSPClientApp find(String key) {
        return (CASSPClientApp)this.entityManager().find(JPACASSPClientApp.class, (Object)key);
    }

    private CASSPClientApp find(String column, Object value) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPACASSPClientApp.class.getSimpleName() + " e WHERE e." + column + "=:value", CASSPClientApp.class);
        query.setParameter("value", value);
        CASSPClientApp result = null;
        try {
            result = (CASSPClientApp)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No OIDCRP found with " + column + " {}", value, (Object)e);
        }
        return result;
    }

    public CASSPClientApp findByClientAppId(Long clientAppId) {
        return this.find("clientAppId", clientAppId);
    }

    public CASSPClientApp findByName(String name) {
        return this.find("name", name);
    }

    public List<CASSPClientApp> findByPolicy(Policy policy) {
        return this.findByPolicy(policy, CASSPClientApp.class, JPACASSPClientApp.class);
    }

    public List<CASSPClientApp> findByRealm(Realm realm) {
        return this.findByRealm(realm, CASSPClientApp.class, JPACASSPClientApp.class);
    }

    @Transactional(readOnly=true)
    public List<CASSPClientApp> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPACASSPClientApp.class.getSimpleName() + " e", CASSPClientApp.class);
        return query.getResultList();
    }

    public CASSPClientApp save(CASSPClientApp clientApp) {
        return (CASSPClientApp)this.entityManager().merge((Object)clientApp);
    }

    public void delete(String key) {
        CASSPClientApp rpTO = this.find(key);
        if (rpTO == null) {
            return;
        }
        this.delete(rpTO);
    }

    public void delete(CASSPClientApp clientApp) {
        this.entityManager().remove((Object)clientApp);
    }
}

