/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Query;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Exec;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTaskExec;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

public class JPATaskExecDAO
extends AbstractDAO<TaskExec<?>>
implements TaskExecDAO {
    protected final TaskDAO taskDAO;
    protected final TaskUtilsFactory taskUtilsFactory;

    public JPATaskExecDAO(TaskDAO taskDAO, TaskUtilsFactory taskUtilsFactory) {
        this.taskDAO = taskDAO;
        this.taskUtilsFactory = taskUtilsFactory;
    }

    public <T extends Task<T>> TaskExec<T> find(TaskType type, String key) {
        return (TaskExec)this.entityManager().find(this.taskUtilsFactory.getInstance(type).getTaskExecEntity(), (Object)key);
    }

    public Optional<TaskExec<?>> find(String key) {
        TaskExec task = this.find(TaskType.SCHEDULED, key);
        if (task == null) {
            task = this.find(TaskType.PULL, key);
        }
        if (task == null) {
            task = this.find(TaskType.PUSH, key);
        }
        if (task == null) {
            task = this.find(TaskType.MACRO, key);
        }
        if (task == null) {
            task = this.find(TaskType.PROPAGATION, key);
        }
        if (task == null) {
            task = this.find(TaskType.NOTIFICATION, key);
        }
        return Optional.ofNullable(task);
    }

    protected <T extends Task<T>> List<TaskExec<T>> findRecent(TaskType type, int max) {
        Query query = this.entityManager().createQuery("SELECT e FROM " + this.taskUtilsFactory.getInstance(type).getTaskExecEntity().getSimpleName() + " e WHERE e.end IS NOT NULL ORDER BY e.end DESC");
        query.setMaxResults(max);
        List result = query.getResultList();
        return result.stream().map(e -> (TaskExec)e).collect(Collectors.toList());
    }

    public List<TaskExec<?>> findRecent(int max) {
        ArrayList recent = new ArrayList();
        for (TaskType taskType : TaskType.values()) {
            recent.addAll(this.findRecent(taskType, max));
        }
        return recent.stream().sorted(Comparator.comparing(Exec::getEnd).reversed()).limit(max).collect(Collectors.toList());
    }

    protected TaskExec<?> findLatest(TaskType type, Task<?> task, String field) {
        Query query = this.entityManager().createQuery("SELECT e FROM " + this.taskUtilsFactory.getInstance(type).getTaskExecEntity().getSimpleName() + " e WHERE e.task=:task ORDER BY e." + field + " DESC");
        query.setParameter("task", task);
        query.setMaxResults(1);
        List result = query.getResultList();
        return result == null || result.isEmpty() ? null : (TaskExec)result.get(0);
    }

    public TaskExec<?> findLatestStarted(TaskType type, Task<?> task) {
        return this.findLatest(type, task, "start");
    }

    public TaskExec<?> findLatestEnded(TaskType type, Task<?> task) {
        return this.findLatest(type, task, "end");
    }

    protected StringBuilder query(StringBuilder select, Task<?> task, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder query = select.append(this.taskUtilsFactory.getInstance(task).getTaskExecEntity().getSimpleName()).append(" e WHERE e.task=:task ");
        if (before != null) {
            query.append("AND e.start <= :before ");
        }
        if (after != null) {
            query.append("AND e.start >= :after ");
        }
        return query;
    }

    public int count(Task<?> task, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT COUNT(e) FROM "), task, before, after);
        Query query = this.entityManager().createQuery(queryString.toString());
        query.setParameter("task", task);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    protected String toOrderByStatement(List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        orderByClauses.forEach(clause -> {
            String field = clause.getField().trim();
            if (ReflectionUtils.findField(AbstractTaskExec.class, (String)field) != null) {
                statement.append("e.").append(field).append(' ').append(clause.getDirection().name());
            }
        });
        if (statement.length() == 0) {
            statement.append(" ORDER BY e.id DESC");
        } else {
            statement.insert(0, " ORDER BY ");
        }
        return statement.toString();
    }

    public List<TaskExec<?>> findAll(Task<?> task, OffsetDateTime before, OffsetDateTime after, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT e FROM "), task, before, after).append(this.toOrderByStatement(orderByClauses));
        Query query = this.entityManager().createQuery(queryString.toString());
        query.setParameter("task", task);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        List result = query.getResultList();
        return result.stream().map(e -> (TaskExec)e).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task<T>> TaskExec<T> save(TaskExec<T> execution) {
        return (TaskExec)this.entityManager().merge(execution);
    }

    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task<T>> void saveAndAdd(TaskType taskType, String taskKey, TaskExec<T> execution) {
        Task task = this.taskDAO.find(taskType, taskKey);
        task.add(execution);
        this.taskDAO.save(task);
    }

    public <T extends Task<T>> void delete(TaskType taskType, String key) {
        TaskExec<T> execution = this.find(taskType, key);
        if (execution == null) {
            return;
        }
        this.delete(execution);
    }

    public <T extends Task<T>> void delete(TaskExec<T> execution) {
        if (execution.getTask() != null) {
            execution.getTask().getExecs().remove(execution);
        }
        this.entityManager().remove(execution);
    }
}

