/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class Whitelist {
    private static final Logger LOG = Logger.getLogger(Whitelist.class.getName());
    private List<String> getEnvWhitelistRegex = new ArrayList<String>();
    private Method getenvMethod;

    public Whitelist() {
        try {
            this.getenvMethod = System.class.getMethod("getenv", String.class);
        }
        catch (NoSuchMethodException e) {
            LOG.log(Level.WARNING, "No such method 'getenv' in class 'System'.", e);
        }
    }

    public void setGetEnvWhitelistRegex(List<String> getEnvWhitelistRegex) {
        this.getEnvWhitelistRegex = getEnvWhitelistRegex;
    }

    public boolean isAllowedGetEnvSystemMethod(Method m, Object[] args) {
        if (m.equals(this.getenvMethod)) {
            String envName = (String)args[0];
            for (String regex : this.getEnvWhitelistRegex) {
                if (!Pattern.matches(regex, envName)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract boolean permitsMethod(Method var1, Object var2, Object[] var3);

    public abstract boolean permitsConstructor(Constructor<?> var1, Object[] var2);

    public abstract boolean permitsStaticMethod(Method var1, Object[] var2);

    public abstract boolean permitsFieldGet(Field var1, Object var2);

    public abstract boolean permitsFieldSet(Field var1, Object var2, Object var3);

    public abstract boolean permitsStaticFieldGet(Field var1);

    public abstract boolean permitsStaticFieldSet(Field var1, Object var2);
}

