/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogatePrincipalBuilder;
import org.apereo.cas.authentication.SurrogateUsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogatePrincipalResolver
extends PersonDirectoryPrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogatePrincipalResolver.class);
    private SurrogatePrincipalBuilder surrogatePrincipalBuilder;

    public SurrogatePrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    public boolean supports(Credential credential) {
        return super.supports(credential) && SurrogateUsernamePasswordCredential.class.isAssignableFrom(credential.getClass());
    }

    protected Principal buildResolvedPrincipal(String id, Map<String, List<Object>> attributes, Credential credential, Optional<Principal> currentPrincipal, Optional<AuthenticationHandler> handler) {
        if (!this.supports(credential)) {
            return super.buildResolvedPrincipal(id, attributes, credential, currentPrincipal, handler);
        }
        if (currentPrincipal.isEmpty()) {
            throw new IllegalArgumentException("Current principal resolved cannot be empty");
        }
        return this.surrogatePrincipalBuilder.buildSurrogatePrincipal(id, currentPrincipal.get());
    }

    protected String extractPrincipalId(Credential credential, Optional<Principal> currentPrincipal) {
        LOGGER.debug("Attempting to extract principal id for principal [{}]", currentPrincipal);
        if (!this.supports(credential)) {
            LOGGER.trace("Provided credential is not one of [{}]", (Object)SurrogateUsernamePasswordCredential.class.getName());
            return super.extractPrincipalId(credential, currentPrincipal);
        }
        if (currentPrincipal.isEmpty()) {
            throw new IllegalArgumentException("Current principal resolved cannot be null");
        }
        String id = ((SurrogateUsernamePasswordCredential)((Object)SurrogateUsernamePasswordCredential.class.cast(credential))).getSurrogateUsername();
        LOGGER.debug("Resolving principal id for surrogate authentication as [{}]", (Object)id);
        return id;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Generated
    public SurrogatePrincipalResolver setSurrogatePrincipalBuilder(SurrogatePrincipalBuilder surrogatePrincipalBuilder) {
        this.surrogatePrincipalBuilder = surrogatePrincipalBuilder;
        return this;
    }
}

