/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;
import org.apache.cxf.jaxrs.model.doc.JavaDocProvider;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;
import org.apache.cxf.jaxrs.openapi.OpenApiFeature;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.DomainWatcher;
import org.apache.syncope.common.keymaster.client.api.KeymasterProperties;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.rest.api.service.ConfParamService;
import org.apache.syncope.common.keymaster.rest.api.service.DomainService;
import org.apache.syncope.common.keymaster.rest.api.service.NetworkServiceService;
import org.apache.syncope.core.keymaster.internal.InternalConfParamHelper;
import org.apache.syncope.core.keymaster.internal.SelfKeymasterInternalConfParamOps;
import org.apache.syncope.core.keymaster.internal.SelfKeymasterInternalDomainOps;
import org.apache.syncope.core.keymaster.internal.SelfKeymasterInternalServiceOps;
import org.apache.syncope.core.keymaster.rest.cxf.service.ConfParamServiceImpl;
import org.apache.syncope.core.keymaster.rest.cxf.service.DomainServiceImpl;
import org.apache.syncope.core.keymaster.rest.cxf.service.NetworkServiceServiceImpl;
import org.apache.syncope.core.keymaster.rest.security.SelfKeymasterUsernamePasswordAuthenticationProvider;
import org.apache.syncope.core.logic.ConfParamLogic;
import org.apache.syncope.core.logic.DomainLogic;
import org.apache.syncope.core.logic.NetworkServiceLogic;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.ConfParamDAO;
import org.apache.syncope.core.persistence.api.dao.DomainDAO;
import org.apache.syncope.core.persistence.api.dao.NetworkServiceDAO;
import org.apache.syncope.core.persistence.api.entity.SelfKeymasterEntityFactory;
import org.apache.syncope.core.persistence.jpa.dao.JPAConfParamDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPADomainDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPANetworkServiceDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPASelfKeymasterEntityFactory;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.rest.cxf.JavaDocUtils;
import org.apache.syncope.core.rest.cxf.RestServiceExceptionMapper;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.UsernamePasswordAuthenticationProvider;
import org.apache.syncope.core.spring.security.WebSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@EnableConfigurationProperties(value={KeymasterProperties.class})
@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={WebSecurityContext.class})
@Conditional(value={SelfKeymasterCondition.class})
public class SelfKeymasterContext {
    private static final Logger LOG = LoggerFactory.getLogger(SelfKeymasterContext.class);
    private static final Pattern HTTP = Pattern.compile("^http.+");

    @Bean
    public Server selfKeymasterContainer(final DomainHolder domainHolder, ConfParamService confParamService, NetworkServiceService networkServiceService, DomainService domainService, JacksonJsonProvider jsonProvider, GZIPInInterceptor gzipInInterceptor, GZIPOutInterceptor gzipOutInterceptor, JAXRSBeanValidationInInterceptor validationInInterceptor, RestServiceExceptionMapper restServiceExceptionMapper, Bus bus, Environment env) {
        JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean selfKeymasterContainer = new JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean();
        selfKeymasterContainer.setBus(bus);
        selfKeymasterContainer.setAddress("/keymaster");
        selfKeymasterContainer.setStaticSubresourceResolution(true);
        selfKeymasterContainer.setProperties(Map.of("convert.wadl.resources.to.dom", "false"));
        selfKeymasterContainer.setServiceBeans(List.of(confParamService, networkServiceService, domainService));
        selfKeymasterContainer.setInInterceptors(List.of(gzipInInterceptor, validationInInterceptor));
        selfKeymasterContainer.setOutInterceptors(List.of(gzipOutInterceptor));
        selfKeymasterContainer.setProviders(List.of(restServiceExceptionMapper, jsonProvider));
        JavaDocProvider javaDocProvider = JavaDocUtils.getJavaDocURLs().map(JavaDocProvider::new).orElseGet(() -> JavaDocUtils.getJavaDocPaths((Environment)env).map(javaDocPaths -> {
            try {
                return new JavaDocProvider(javaDocPaths);
            }
            catch (Exception e) {
                LOG.error("Could not set javadoc paths from {}", List.of(javaDocPaths), (Object)e);
                return null;
            }
        }).orElse(null));
        OpenApiCustomizer openApiCustomizer = new OpenApiCustomizer(){

            public OpenAPIConfiguration customize(OpenAPIConfiguration configuration) {
                super.customize(configuration);
                MessageContext ctx = (MessageContext)JAXRSUtils.createContextValue((Message)JAXRSUtils.getCurrentMessage(), null, MessageContext.class);
                String url = StringUtils.substringBeforeLast((String)ctx.getUriInfo().getRequestUri().getRawPath(), (String)"/");
                configuration.getOpenAPI().setServers(List.of(new io.swagger.v3.oas.models.servers.Server().url(url)));
                return configuration;
            }

            protected void addParameters(List<Parameter> parameters) {
                Optional<Parameter> domainHeaderParameter = parameters.stream().filter(p -> p instanceof HeaderParameter && "X-Syncope-Domain".equals(p.getName())).findFirst();
                if (domainHeaderParameter.isEmpty()) {
                    HeaderParameter parameter = new HeaderParameter();
                    parameter.setName("X-Syncope-Domain");
                    parameter.setRequired(Boolean.valueOf(true));
                    ExternalDocumentation extDoc = new ExternalDocumentation();
                    extDoc.setDescription("Apache Syncope Reference Guide");
                    extDoc.setUrl("https://syncope.apache.org/docs/3.0/reference-guide.html#domains");
                    Schema schema = new Schema();
                    schema.setDescription("Domains are built to facilitate multitenancy.");
                    schema.setExternalDocs(extDoc);
                    schema.setEnum(domainHolder.getDomains().keySet().stream().sorted().collect(Collectors.toList()));
                    schema.setDefault((Object)"Master");
                    parameter.setSchema(schema);
                    parameters.add((Parameter)parameter);
                }
            }
        };
        openApiCustomizer.setDynamicBasePath(false);
        openApiCustomizer.setReplaceTags(false);
        openApiCustomizer.setJavadocProvider((DocumentationProvider)javaDocProvider);
        String version = env.getProperty("version");
        OpenApiFeature openapiFeature = new OpenApiFeature();
        openapiFeature.setUseContextBasedConfig(true);
        openapiFeature.setTitle("Apache Syncope Self Keymaster");
        openapiFeature.setVersion(version);
        openapiFeature.setDescription("Apache Syncope Self Keymaster" + version);
        openapiFeature.setContactName("The Apache Syncope community");
        openapiFeature.setContactEmail("dev@syncope.apache.org");
        openapiFeature.setContactUrl("https://syncope.apache.org");
        openapiFeature.setScan(false);
        openapiFeature.setResourcePackages(Set.of("org.apache.syncope.common.keymaster.rest.api.service"));
        openapiFeature.setSecurityDefinitions(Map.of("BasicAuthentication", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic")));
        openapiFeature.setCustomizer(openApiCustomizer);
        selfKeymasterContainer.setFeatures(List.of(openapiFeature));
        return selfKeymasterContainer.create();
    }

    @Bean
    public UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider(DomainOps domainOps, AuthDataAccessor dataAccessor, UserProvisioningManager provisioningManager, DefaultCredentialChecker credentialChecker, SecurityProperties securityProperties, KeymasterProperties keymasterProperties) {
        return new SelfKeymasterUsernamePasswordAuthenticationProvider(domainOps, dataAccessor, provisioningManager, credentialChecker, securityProperties, keymasterProperties);
    }

    @Bean
    public InternalConfParamHelper internalConfParamHelper(ConfParamDAO confParamDAO, SelfKeymasterEntityFactory entityFactory) {
        return new InternalConfParamHelper(confParamDAO, entityFactory);
    }

    @Bean
    public ConfParamOps internalConfParamOps(InternalConfParamHelper helper) {
        return new SelfKeymasterInternalConfParamOps(helper);
    }

    @Bean
    public ServiceOps internalServiceOps(NetworkServiceLogic networkServiceLogic, KeymasterProperties props) {
        return new SelfKeymasterInternalServiceOps(networkServiceLogic, props);
    }

    @Bean
    public DomainOps domainOps(DomainLogic domainLogic, KeymasterProperties props) {
        return new SelfKeymasterInternalDomainOps(domainLogic, props);
    }

    @Bean
    public ConfParamLogic confParamLogic(InternalConfParamHelper helper) {
        return new ConfParamLogic(helper);
    }

    @Bean
    public DomainLogic domainLogic(DomainDAO domainDAO, SelfKeymasterEntityFactory selfKeymasterEntityFactory, DomainWatcher domainWatcher) {
        return new DomainLogic(domainDAO, selfKeymasterEntityFactory, domainWatcher);
    }

    @Bean
    public NetworkServiceLogic networkServiceLogic(NetworkServiceDAO serviceDAO, SelfKeymasterEntityFactory selfKeymasterEntityFactory) {
        return new NetworkServiceLogic(serviceDAO, selfKeymasterEntityFactory);
    }

    @Bean
    public SelfKeymasterEntityFactory selfKeymasterEntityFactory() {
        return new JPASelfKeymasterEntityFactory();
    }

    @Bean
    public ConfParamDAO confParamDAO() {
        return new JPAConfParamDAO();
    }

    @Bean
    public DomainDAO domainDAO() {
        return new JPADomainDAO();
    }

    @Bean
    public NetworkServiceDAO networkServiceDAO() {
        return new JPANetworkServiceDAO();
    }

    @Bean
    public ConfParamService confParamService(ConfParamLogic confParamLogic) {
        return new ConfParamServiceImpl(confParamLogic);
    }

    @Bean
    public DomainService domainService(DomainLogic domainLogic) {
        return new DomainServiceImpl(domainLogic);
    }

    @Bean
    public NetworkServiceService networkServiceService(NetworkServiceLogic networkServiceLogic) {
        return new NetworkServiceServiceImpl(networkServiceLogic);
    }

    static class SelfKeymasterCondition
    extends SpringBootCondition {
        SelfKeymasterCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String keymasterAddress = context.getEnvironment().getProperty("keymaster.address");
            return new ConditionOutcome(keymasterAddress != null && HTTP.matcher(keymasterAddress).matches(), "Keymaster address not set for Self: " + keymasterAddress);
        }
    }
}

