/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.task;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.core.flowable.task.FlowableServiceTask;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.flowable.engine.delegate.DelegateExecution;

public class Update
extends FlowableServiceTask {
    protected final UserDataBinder dataBinder;
    protected final UserDAO userDAO;

    public Update(UserDataBinder dataBinder, UserDAO userDAO) {
        this.dataBinder = dataBinder;
        this.userDAO = userDAO;
    }

    @Override
    protected void doExecute(DelegateExecution execution) {
        UserUR req = (UserUR)execution.getVariable("userUR", UserUR.class);
        if (req == null || req.isEmpty()) {
            LOG.warn("No actual update is to be performed: empty or null request");
        } else {
            User user = (User)execution.getVariable("user", User.class);
            user = (User)this.userDAO.save((Any)user);
            Pair propInfo = this.dataBinder.update(user, req);
            execution.setVariable("user", (Object)user);
            execution.setVariable("propByResource", propInfo.getLeft());
            execution.setVariable("propByLinkedAccount", propInfo.getRight());
        }
    }
}

