/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;

public class SortableAnyProviderComparator<T extends AnyTO>
extends SortableDataProviderComparator<T> {
    private static final long serialVersionUID = 1775967163571699258L;
    private static final Set<String> INLINE_PROPS = Set.of("key", "status", "token", "username", "name");

    public SortableAnyProviderComparator(SortableDataProvider<T, String> provider) {
        super(provider);
    }

    @Override
    public int compare(T any1, T any2) {
        if (INLINE_PROPS.contains(this.provider.getSort().getProperty())) {
            return super.compare(any1, any2);
        }
        return super.compare(new AttrModel((AnyTO)any1), new AttrModel((AnyTO)any2));
    }

    private class AttrModel
    implements IModel<Comparable> {
        private static final long serialVersionUID = -7856686374020091808L;
        private final AnyTO anyTO;

        AttrModel(AnyTO anyTO) {
            this.anyTO = anyTO;
        }

        public Comparable getObject() {
            Attr attr;
            String schema;
            int hashPos = ((String)SortableAnyProviderComparator.this.provider.getSort().getProperty()).indexOf(35);
            SchemaType schemaType = null;
            if (hashPos == -1) {
                schema = (String)SortableAnyProviderComparator.this.provider.getSort().getProperty();
            } else {
                String[] splitted = ((String)SortableAnyProviderComparator.this.provider.getSort().getProperty()).split("#");
                try {
                    schemaType = SchemaType.valueOf((String)splitted[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                schema = ((String)SortableAnyProviderComparator.this.provider.getSort().getProperty()).substring(hashPos + 1);
            }
            if (schemaType == null) {
                attr = this.anyTO.getPlainAttr(schema).orElse(null);
            } else {
                switch (schemaType) {
                    default: {
                        attr = this.anyTO.getPlainAttr(schema).orElse(null);
                        break;
                    }
                    case DERIVED: {
                        attr = this.anyTO.getDerAttr(schema).orElse(null);
                        break;
                    }
                    case VIRTUAL: {
                        attr = this.anyTO.getVirAttr(schema).orElse(null);
                    }
                }
            }
            Comparable result = null;
            List values = Optional.ofNullable(attr).map(Attr::getValues).orElse(null);
            if (values != null && !values.isEmpty()) {
                result = (Comparable)values.iterator().next();
            }
            return result;
        }
    }
}

