/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.List;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class AnyTypeClassDetailsPanel
extends Panel {
    private static final long serialVersionUID = 3321861543207340469L;
    protected static final List<String> LAYOUT_PARAMETERS = List.of("enduser.anylayout");
    protected final AnyTypeClassTO anyTypeClassTO;
    protected final List<String> availablePlainSchemas;
    protected final List<String> availableDerSchemas;
    protected final List<String> availableVirSchemas;
    protected final AnyTypeClassRestClient anyTypeClassRestClient;

    public AnyTypeClassDetailsPanel(String id, AnyTypeClassTO anyTypeClassTO, SchemaRestClient schemaRestClient, AnyTypeClassRestClient anyTypeClassRestClient) {
        super(id);
        this.anyTypeClassTO = anyTypeClassTO;
        this.availablePlainSchemas = schemaRestClient.getSchemaNames(SchemaType.PLAIN);
        this.availableDerSchemas = schemaRestClient.getSchemaNames(SchemaType.DERIVED);
        this.availableVirSchemas = schemaRestClient.getSchemaNames(SchemaType.VIRTUAL);
        this.anyTypeClassRestClient = anyTypeClassRestClient;
        this.buildAvailableSchemas(anyTypeClassTO.getKey());
        Form antTypeClassForm = new Form("form");
        antTypeClassForm.setModel((IModel)new CompoundPropertyModel((Object)anyTypeClassTO));
        antTypeClassForm.setOutputMarkupId(true);
        this.add(new Component[]{antTypeClassForm});
        AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", this.getString("key"), (IModel)new PropertyModel((Object)this.anyTypeClassTO, "key"));
        key.addRequiredLabel();
        key.setEnabled(anyTypeClassTO.getKey() == null || this.anyTypeClassTO.getKey().isEmpty());
        antTypeClassForm.add(new Component[]{key});
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        antTypeClassForm.add(new Component[]{container});
        AjaxPalettePanel plainSchema = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("plainSchemas", (IModel)new PropertyModel((Object)this.anyTypeClassTO, "plainSchemas"), (IModel)new ListModel(this.availablePlainSchemas));
        plainSchema.hideLabel();
        plainSchema.setOutputMarkupId(true);
        container.add(new Component[]{plainSchema});
        AjaxPalettePanel derSchema = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("derSchemas", (IModel)new PropertyModel((Object)this.anyTypeClassTO, "derSchemas"), (IModel)new ListModel(this.availableDerSchemas));
        derSchema.hideLabel();
        derSchema.setOutputMarkupId(true);
        container.add(new Component[]{derSchema});
        AjaxPalettePanel virSchema = new AjaxPalettePanel.Builder().setAllowOrder(true).setAllowMoveAll(true).build("virSchemas", (IModel)new PropertyModel((Object)this.anyTypeClassTO, "virSchemas"), (IModel)new ListModel(this.availableVirSchemas));
        virSchema.hideLabel();
        virSchema.setOutputMarkupId(true);
        container.add(new Component[]{virSchema});
    }

    protected void buildAvailableSchemas(String key) {
        this.anyTypeClassRestClient.list().stream().filter(item -> key == null || !item.getKey().equals(key)).forEach(item -> {
            this.availablePlainSchemas.removeAll(item.getPlainSchemas());
            this.availableDerSchemas.removeAll(item.getDerSchemas());
            this.availableVirSchemas.removeAll(item.getVirSchemas());
        });
        this.availablePlainSchemas.removeAll(LAYOUT_PARAMETERS);
    }
}

