/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public final class RelationshipViewPanel
extends WizardMgtPanel<RelationshipTO> {
    private static final long serialVersionUID = -7510529471158257903L;
    private ActionLinksTogglePanel<RelationshipTO> togglePanel;
    private final ListView<RelationshipTO> relationshipsList;

    private RelationshipViewPanel(String id, final List<RelationshipTO> relationships, final AnyTO anyTO, boolean reuseItem, boolean wizardInModal) {
        super(id, wizardInModal);
        WebMarkupContainer header = new WebMarkupContainer("header");
        header.add(new Component[]{new Label("header_left_end", (Serializable)((Object)this.getString("left.end")))});
        header.add(new Component[]{new Label("header_relationship", (IModel)new ResourceModel("relationship"))});
        header.add(new Component[]{new Label("header_right_end", (IModel)new ResourceModel("right.end"))});
        this.addInnerObject(new Component[]{header});
        this.relationshipsList = new ListView<RelationshipTO>("relationships", relationships){
            private static final long serialVersionUID = 4983556433071042668L;

            protected void populateItem(final ListItem<RelationshipTO> relationshipItem) {
                final RelationshipTO relationshipTO = (RelationshipTO)relationshipItem.getModelObject();
                RelationshipViewPanel.buildRowLabels(relationshipItem, relationshipTO, anyTO);
                final ActionsPanel<RelationshipTO> action = new ActionsPanel<RelationshipTO>("action", (IModel<RelationshipTO>)new Model((Serializable)relationshipTO));
                action.add(new ActionLink<RelationshipTO>(){
                    private static final long serialVersionUID = 5207800927605869051L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RelationshipTO modelObject) {
                        relationships.remove(modelObject);
                        RelationshipViewPanel.this.relationshipsList.remove((Component)relationshipItem);
                        target.add(new Component[]{RelationshipViewPanel.this});
                    }
                }, ActionLink.ActionType.DELETE, AnyEntitlement.UPDATE.getFor(anyTO.getType()), true).hideLabel();
                if (RelationshipViewPanel.this.togglePanel != null) {
                    relationshipItem.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"cursor: pointer;"))});
                    relationshipItem.add(new Behavior[]{new AjaxEventBehavior("click"){
                        private static final long serialVersionUID = -9027652037484739586L;

                        protected String findIndicatorId() {
                            return "";
                        }

                        protected void onEvent(AjaxRequestTarget target) {
                            RelationshipViewPanel.this.togglePanel.toggleWithContent(target, action, relationshipTO);
                        }
                    }});
                }
                if (RelationshipViewPanel.this.togglePanel == null) {
                    relationshipItem.add(new Component[]{action});
                } else {
                    relationshipItem.add(new Component[]{new ActionsPanel("action", new Model((Serializable)relationshipTO)).setVisible(false).setEnabled(false)});
                }
            }
        };
        this.relationshipsList.setOutputMarkupId(true);
        this.relationshipsList.setReuseItems(reuseItem);
        this.relationshipsList.setRenderBodyOnly(true);
        this.addInnerObject(new Component[]{this.relationshipsList});
    }

    private static void buildRowLabels(ListItem<RelationshipTO> row, RelationshipTO relationshipTO, AnyTO anyTO) {
        boolean isLeftRelation = relationshipTO.getEnd() == RelationshipTO.End.LEFT;
        String anyName = anyTO instanceof UserTO ? ((UserTO)UserTO.class.cast(anyTO)).getUsername() : ((AnyObjectTO)AnyObjectTO.class.cast(anyTO)).getName();
        row.add(new Component[]{new Label("relationship", (Serializable)((Object)relationshipTO.getType()))});
        Label leftEnd = new Label("left_end", (Serializable)((Object)(isLeftRelation ? String.format("%s %s", anyTO.getType(), anyName) : String.format("%s %s", relationshipTO.getOtherEndType(), relationshipTO.getOtherEndName()))));
        Label rightEnd = new Label("right_end", (Serializable)((Object)(isLeftRelation ? String.format("%s %s", relationshipTO.getOtherEndType(), relationshipTO.getOtherEndName()) : String.format("%s %s", anyTO.getType(), anyName))));
        if (anyTO.getKey() != null && anyTO.getKey().equals(relationshipTO.getOtherEndKey())) {
            RelationshipViewPanel.setBold(leftEnd, rightEnd);
        } else {
            RelationshipViewPanel.setBold(isLeftRelation ? leftEnd : rightEnd);
        }
        row.add(new Component[]{leftEnd, rightEnd});
    }

    private static void setBold(Label ... labels) {
        for (Label label : labels) {
            label.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"font-weight: bold;"))});
        }
    }

    public static class Builder
    extends WizardMgtPanel.Builder<RelationshipTO> {
        private static final long serialVersionUID = -3643771352897992172L;
        private List<RelationshipTO> relationships = null;
        private AnyTO anyTO = null;
        private boolean reuseItem = true;

        public Builder(PageReference pageRef) {
            super(pageRef);
        }

        public Builder setAnyTO(AnyTO anyTO) {
            this.anyTO = anyTO;
            return this;
        }

        public Builder setRelationships(List<RelationshipTO> relationships) {
            this.relationships = relationships;
            return this;
        }

        public Builder addItem(RelationshipTO item) {
            if (item == null) {
                return this;
            }
            if (this.relationships == null) {
                this.relationships = new ArrayList<RelationshipTO>();
            }
            this.relationships.add(item);
            return this;
        }

        public Builder setReuseItem(boolean reuseItem) {
            this.reuseItem = reuseItem;
            return this;
        }

        @Override
        protected WizardMgtPanel<RelationshipTO> newInstance(String id, boolean wizardInModal) {
            return new RelationshipViewPanel(id, this.relationships, this.anyTO, this.reuseItem, wizardInModal);
        }
    }
}

