/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.cmd.methods;

import java.util.ArrayList;
import java.util.List;
import net.tirasa.connid.bundles.cmd.CmdConfiguration;
import net.tirasa.connid.bundles.cmd.methods.CmdExec;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public class CmdDelete
extends CmdExec {
    private static final Log LOG = Log.getLog(CmdDelete.class);
    private final Uid uid;

    public CmdDelete(ObjectClass oc, CmdConfiguration cmdConfiguration, Uid uid) {
        super(oc, cmdConfiguration);
        this.uid = uid;
    }

    public void execDeleteCmd() {
        LOG.info("Executing deletion for {0}", new Object[]{this.uid});
        this.waitFor(this.exec(this.cmdConfiguration.getDeleteCmdPath(), this.createEnv()));
    }

    private List<Pair<String, String>> createEnv() {
        LOG.ok("Creating environment for deletion with:", new Object[0]);
        LOG.ok("ObjectClass: {0}", new Object[]{this.oc.getObjectClassValue()});
        LOG.ok("Environment variable {0}: {1}", new Object[]{this.uid.getName(), this.uid.getUidValue()});
        ArrayList<Pair<String, String>> env = new ArrayList<Pair<String, String>>();
        env.add(new Pair((Object)"OBJECT_CLASS", (Object)this.oc.getObjectClassValue()));
        env.add(new Pair((Object)this.uid.getName(), (Object)this.uid.getUidValue()));
        if (this.cmdConfiguration.isServerInfoEnv()) {
            env.addAll(this.getConfigurationEnvs(this.cmdConfiguration));
        }
        return env;
    }
}

