/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.toolbar;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.IFormVisitorParticipant;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.wicketstuff.egrid.column.AbstractEditablePropertyColumn;
import org.wicketstuff.egrid.column.EditableCellPanel;
import org.wicketstuff.egrid.component.EditableDataTable;
import org.wicketstuff.egrid.component.EditableGridSubmitLink;
import org.wicketstuff.egrid.toolbar.AbstractEditableGridToolbar;

public abstract class EditableGridBottomToolbar<T, S>
extends AbstractEditableGridToolbar {
    private static final long serialVersionUID = 1L;
    private static final String CELL_ID = "cell";
    private static final String CELLS_ID = "cells";
    private T newRow = null;

    protected abstract void onAdd(AjaxRequestTarget var1, T var2);

    public EditableGridBottomToolbar(EditableDataTable<?, ?> table, Class<T> clazz) {
        super(table);
        this.createNewInstance(clazz);
        WebMarkupContainer td = new WebMarkupContainer("td");
        td.add(new Behavior[]{new AttributeModifier("colspan", (Serializable)Integer.valueOf(table.getColumns().size() - 1))});
        AddToolBarForm addToolBarForm = new AddToolBarForm("addToolbarForm");
        td.add(new Component[]{addToolBarForm});
        this.add(new Component[]{td});
        this.add(new Component[]{this.newAddButton((WebMarkupContainer)addToolBarForm)});
    }

    protected void onError(AjaxRequestTarget target) {
    }

    private void createNewInstance(Class<T> clazz) {
        try {
            this.newRow = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Component newAddButton(WebMarkupContainer encapsulatingContainer) {
        return new EditableGridSubmitLink("add", encapsulatingContainer){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSuccess(AjaxRequestTarget target) {
                EditableGridBottomToolbar.this.onAdd(target, EditableGridBottomToolbar.this.newRow);
                EditableGridBottomToolbar.this.createNewInstance(EditableGridBottomToolbar.this.newRow.getClass());
                target.add(new Component[]{EditableGridBottomToolbar.this.getTable()});
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                EditableGridBottomToolbar.this.onError(target);
            }
        };
    }

    private Loop newEditorComponents() {
        final List<AbstractEditablePropertyColumn<T, S>> columns = this.getEditableColumns();
        return new Loop(CELLS_ID, columns.size()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(LoopItem item) {
                EditableGridBottomToolbar.this.addEditorComponent(item, EditableGridBottomToolbar.this.getEditorColumn(columns, item.getIndex()));
            }
        };
    }

    private void addEditorComponent(LoopItem item, AbstractEditablePropertyColumn<T, S> toolBarCell) {
        item.add(new Component[]{this.newCell(toolBarCell)});
    }

    private List<AbstractEditablePropertyColumn<T, S>> getEditableColumns() {
        ArrayList<AbstractEditablePropertyColumn<T, S>> columns = new ArrayList<AbstractEditablePropertyColumn<T, S>>();
        for (IColumn<?, ?> column : this.getTable().getColumns()) {
            if (!(column instanceof AbstractEditablePropertyColumn)) continue;
            columns.add((AbstractEditablePropertyColumn)column);
        }
        return columns;
    }

    private Component newCell(AbstractEditablePropertyColumn<T, S> editableGridColumn) {
        EditableCellPanel panel = editableGridColumn.getEditableCellPanel(CELL_ID);
        FormComponent<?> editorComponent = panel.getEditableComponent();
        editorComponent.setDefaultModel((IModel)new PropertyModel(this.newRow, editableGridColumn.getPropertyExpression()));
        return panel;
    }

    private AbstractEditablePropertyColumn<T, S> getEditorColumn(List<AbstractEditablePropertyColumn<T, S>> editorColumn, int index) {
        return editorColumn.get(index);
    }

    private class AddToolBarForm
    extends Form<T>
    implements IFormVisitorParticipant {
        private static final long serialVersionUID = 1L;

        public AddToolBarForm(String id) {
            super(id);
            this.add(new Component[]{EditableGridBottomToolbar.this.newEditorComponents()});
        }

        public boolean processChildren() {
            IFormSubmittingComponent submitter = this.getRootForm().findSubmitter();
            return submitter != null && submitter.getForm() == this;
        }
    }
}

