/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.account;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DetailedCredentialMetaData;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.ISOStandardDateFormat;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrepareAccountProfileViewAction
extends BaseCasWebflowAction {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final TicketRegistry ticketRegistry;
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;
    private final AuditTrailExecutionPlan auditTrailManager;
    private final GeoLocationService geoLocationService;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        Optional ticketGrantingTicket = (Optional)FunctionUtils.doAndHandle(() -> Optional.of((TicketGrantingTicket)this.ticketRegistry.getTicket(tgt, TicketGrantingTicket.class)), throwable -> Optional.empty()).get();
        ticketGrantingTicket.ifPresent(ticket -> {
            WebUtils.putAuthentication((Authentication)ticket.getAuthentication(), (RequestContext)requestContext);
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            if (this.casProperties.getView().isAuthorizedServicesOnSuccessfulLogin()) {
                this.buildAuthorizedServices(requestContext, (TicketGrantingTicket)ticket, service);
            }
            this.buildAuditLogRecords(requestContext, (TicketGrantingTicket)ticket);
            this.buildActiveSingleSignOnSessions(requestContext, (TicketGrantingTicket)ticket);
        });
        return this.success();
    }

    protected void buildActiveSingleSignOnSessions(RequestContext requestContext, TicketGrantingTicket ticket) {
        List activeSessions = this.ticketRegistry.getSessionsFor(ticket.getAuthentication().getPrincipal().getId()).map(TicketGrantingTicket.class::cast).map(x$0 -> new SingleSignOnSession((TicketGrantingTicket)x$0)).collect(Collectors.toList());
        WebUtils.putSingleSignOnSessions((RequestContext)requestContext, activeSessions);
    }

    protected void buildAuthorizedServices(RequestContext requestContext, TicketGrantingTicket ticket, WebApplicationService service) {
        Map authzAttributes = CollectionUtils.merge((Map[])new Map[]{ticket.getAuthentication().getAttributes(), ticket.getAuthentication().getPrincipal().getAttributes()});
        List authorizedServices = this.servicesManager.getAllServices().stream().filter(registeredService -> (Boolean)FunctionUtils.doAndHandle(() -> RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (String)ticket.getAuthentication().getPrincipal().getId(), (Map)authzAttributes), throwable -> false).get()).collect(Collectors.toList());
        WebUtils.putAuthorizedServices((RequestContext)requestContext, authorizedServices);
    }

    protected void buildAuditLogRecords(RequestContext requestContext, TicketGrantingTicket ticket) {
        LocalDate sinceDate = LocalDate.now(Clock.systemUTC()).minusMonths(2L);
        Map<AuditTrailManager.WhereClauseFields, String> criteria = Map.of(AuditTrailManager.WhereClauseFields.DATE, sinceDate, AuditTrailManager.WhereClauseFields.PRINCIPAL, ticket.getAuthentication().getPrincipal().getId());
        List auditLog = this.auditTrailManager.getAuditRecords(criteria).stream().sorted(Comparator.comparing(AuditActionContext::getWhenActionWasPerformed).reversed()).map(AccountAuditActionContext::new).collect(Collectors.toList());
        FunctionUtils.doIf((!auditLog.isEmpty() ? 1 : 0) != 0, u -> requestContext.getFlowScope().put("auditLog", (Object)auditLog)).accept(auditLog);
    }

    @Generated
    public PrepareAccountProfileViewAction(TicketRegistry ticketRegistry, ServicesManager servicesManager, CasConfigurationProperties casProperties, AuditTrailExecutionPlan auditTrailManager, GeoLocationService geoLocationService) {
        this.ticketRegistry = ticketRegistry;
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
        this.auditTrailManager = auditTrailManager;
        this.geoLocationService = geoLocationService;
    }

    class SingleSignOnSession
    implements Serializable {
        private static final long serialVersionUID = 8935451143814878214L;
        private final String payload;
        private final String principal;
        private final String authenticationDate;
        private final String userAgent;
        private final String clientIpAddress;
        private final String geoLocation;

        SingleSignOnSession(TicketGrantingTicket ticket) {
            this.principal = ticket.getAuthentication().getPrincipal().getId();
            this.userAgent = ticket.getAuthentication().getCredentials().stream().filter(cred -> cred instanceof DetailedCredentialMetaData).map(DetailedCredentialMetaData.class::cast).filter(cred -> cred.getProperties().containsKey("UserAgent")).map(cred -> ((Serializable)cred.getProperties().get("UserAgent")).toString()).findFirst().orElse("");
            this.clientIpAddress = CollectionUtils.firstElement(ticket.getAuthentication().getAttributes().get("clientIpAddress")).map(Object::toString).orElse("");
            ISOStandardDateFormat dateFormat = new ISOStandardDateFormat();
            this.authenticationDate = dateFormat.format(DateTimeUtils.dateOf((ChronoZonedDateTime)ticket.getAuthentication().getAuthenticationDate()));
            this.geoLocation = (String)FunctionUtils.doIf((boolean)BeanSupplier.isNotProxy((Object)PrepareAccountProfileViewAction.this.geoLocationService), () -> PrepareAccountProfileViewAction.this.geoLocationService.locate(this.clientIpAddress).build(), () -> "N/A").get();
            this.payload = (String)FunctionUtils.doUnchecked(() -> MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this));
        }

        @Generated
        public String getPayload() {
            return this.payload;
        }

        @Generated
        public String getPrincipal() {
            return this.principal;
        }

        @Generated
        public String getAuthenticationDate() {
            return this.authenticationDate;
        }

        @Generated
        public String getUserAgent() {
            return this.userAgent;
        }

        @Generated
        public String getClientIpAddress() {
            return this.clientIpAddress;
        }

        @Generated
        public String getGeoLocation() {
            return this.geoLocation;
        }
    }

    private static class AccountAuditActionContext
    extends AuditActionContext {
        private static final long serialVersionUID = 8935451143814878214L;
        private final String json = (String)FunctionUtils.doUnchecked(() -> MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this));

        AccountAuditActionContext(AuditActionContext context) {
            super(context.getPrincipal(), context.getResourceOperatedUpon(), context.getActionPerformed(), context.getApplicationCode(), context.getWhenActionWasPerformed(), context.getClientIpAddress(), context.getServerIpAddress(), context.getUserAgent());
        }

        @Generated
        public String getJson() {
            return this.json;
        }
    }
}

