/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.notification;

import javax.mail.internet.MimeMessage;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.java.job.notification.AbstractNotificationJobDelegate;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailNotificationJobDelegate
extends AbstractNotificationJobDelegate {
    protected final JavaMailSender mailSender;

    public MailNotificationJobDelegate(TaskDAO taskDAO, TaskUtilsFactory taskUtilsFactory, AuditManager auditManager, NotificationManager notificationManager, ApplicationEventPublisher publisher, JavaMailSender mailSender) {
        super(taskDAO, taskUtilsFactory, auditManager, notificationManager, publisher);
        this.mailSender = mailSender;
    }

    @Override
    protected void notify(String to, NotificationTask task, TaskExec<NotificationTask> execution) throws Exception {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setTo(to);
        helper.setFrom(task.getSender());
        helper.setSubject(task.getSubject());
        helper.setText(task.getTextBody(), task.getHtmlBody());
        this.mailSender.send(message);
        execution.setStatus(NotificationJob.Status.SENT.name());
        StringBuilder report = new StringBuilder();
        switch (task.getTraceLevel()) {
            case ALL: {
                report.append("FROM: ").append(task.getSender()).append('\n').append("TO: ").append(to).append('\n').append("SUBJECT: ").append(task.getSubject()).append('\n').append('\n').append(task.getTextBody()).append('\n').append('\n').append(task.getHtmlBody()).append('\n');
                break;
            }
            case SUMMARY: {
                report.append("E-mail sent to ").append(to).append('\n');
                break;
            }
        }
        if (report.length() > 0) {
            execution.setMessage(report.toString());
        }
    }
}

