/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropagationReporter
implements PropagationReporter {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultPropagationReporter.class);
    protected final List<PropagationStatus> statuses = new CopyOnWriteArrayList<PropagationStatus>();

    protected boolean add(PropagationStatus status) {
        return this.statuses.stream().anyMatch(item -> item.getResource().equals(status.getResource())) ? false : this.statuses.add(status);
    }

    public void onSuccessOrNonPriorityResourceFailures(PropagationTaskInfo taskInfo, ExecStatus executionStatus, String failureReason, String fiql, ConnectorObject beforeObj, ConnectorObject afterObj) {
        PropagationStatus status = new PropagationStatus();
        status.setResource(taskInfo.getResource().getKey());
        status.setStatus(executionStatus);
        status.setFailureReason(failureReason);
        if (beforeObj != null) {
            status.setBeforeObj(ConnObjectUtils.getConnObjectTO(fiql, beforeObj.getAttributes()));
        }
        if (afterObj != null) {
            status.setAfterObj(ConnObjectUtils.getConnObjectTO(fiql, afterObj.getAttributes()));
        }
        this.add(status);
    }

    public void onPriorityResourceFailure(String failingResource, Collection<PropagationTaskInfo> taskInfos) {
        LOG.debug("Propagation error: {} priority resource failed to propagate", (Object)failingResource);
        taskInfos.stream().filter(task -> task.getResource().getKey().equals(failingResource)).findFirst().ifPresentOrElse(task -> {
            PropagationStatus status = new PropagationStatus();
            status.setResource(task.getResource().getKey());
            status.setStatus(ExecStatus.FAILURE);
            status.setFailureReason("Propagation error: " + failingResource + " priority resource failed to propagate.");
            this.add(status);
        }, () -> LOG.error("Could not find {} for {}", (Object)PropagationTask.class.getName(), (Object)failingResource));
    }

    public List<PropagationStatus> getStatuses() {
        return Collections.unmodifiableList(this.statuses);
    }
}

