/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationResult;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityPasscodeCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationCredential;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class DuoSecurityAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler
implements MultifactorAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityAuthenticationHandler.class);
    private final ObjectProvider<? extends DuoSecurityMultifactorAuthenticationProvider> multifactorAuthenticationProvider;
    private final List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver;

    public DuoSecurityAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, ObjectProvider<DuoSecurityMultifactorAuthenticationProvider> multifactorAuthenticationProvider, Integer order, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver) {
        super(name, servicesManager, principalFactory, order);
        this.multifactorAuthenticationProvider = multifactorAuthenticationProvider;
        this.multifactorAuthenticationPrincipalResolver = multifactorAuthenticationPrincipalResolver;
    }

    public boolean supports(Credential credential) {
        if (credential instanceof MultifactorAuthenticationCredential) {
            String id = ((MultifactorAuthenticationCredential)credential).getProviderId();
            return ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).matches(id);
        }
        return false;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws GeneralSecurityException {
        if (credential instanceof DuoSecurityPasscodeCredential) {
            LOGGER.debug("Attempting to authenticate credential via duo passcode");
            return this.authenticateDuoPasscodeCredential(credential);
        }
        if (credential instanceof DuoSecurityUniversalPromptCredential) {
            LOGGER.debug("Attempting to authenticate credential via duo universal prompt");
            return this.authenticateDuoUniversalPromptCredential(credential);
        }
        if (credential instanceof DuoSecurityDirectCredential) {
            LOGGER.debug("Attempting to directly authenticate credential against Duo");
            return this.authenticateDuoApiCredential(credential);
        }
        return this.authenticateDuoCredential(credential);
    }

    protected Principal resolvePrincipal(Principal principal) {
        return this.multifactorAuthenticationPrincipalResolver.stream().filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElseThrow(() -> new IllegalStateException("Unable to resolve principal for multifactor authentication"));
    }

    private AuthenticationHandlerExecutionResult authenticateDuoPasscodeCredential(Credential credential) {
        try {
            DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).getDuoAuthenticationService();
            DuoSecurityPasscodeCredential creds = (DuoSecurityPasscodeCredential)DuoSecurityPasscodeCredential.class.cast(credential);
            if (duoAuthenticationService.authenticate((Credential)creds).isSuccess()) {
                Principal principal = this.principalFactory.createPrincipal(creds.getId());
                return this.createHandlerResult(credential, principal, new ArrayList(0));
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new FailedLoginException("Duo passcode authentication has failed");
    }

    private AuthenticationHandlerExecutionResult authenticateDuoUniversalPromptCredential(Credential c) {
        try {
            DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).getDuoAuthenticationService();
            DuoSecurityUniversalPromptCredential credential = (DuoSecurityUniversalPromptCredential)c;
            DuoSecurityAuthenticationResult result = duoAuthenticationService.authenticate((Credential)credential);
            if (result.isSuccess()) {
                Principal principal = this.principalFactory.createPrincipal(result.getUsername(), result.getAttributes());
                LOGGER.debug("Duo has successfully authenticated [{}]", (Object)principal.getId());
                return this.createHandlerResult((Credential)credential, principal, new ArrayList(0));
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new FailedLoginException("Duo universal prompt authentication has failed");
    }

    private AuthenticationHandlerExecutionResult authenticateDuoApiCredential(Credential credential) throws FailedLoginException {
        try {
            DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).getDuoAuthenticationService();
            DuoSecurityDirectCredential creds = (DuoSecurityDirectCredential)DuoSecurityDirectCredential.class.cast(credential);
            if (duoAuthenticationService.authenticate((Credential)creds).isSuccess()) {
                Principal principal = this.resolvePrincipal(creds.getPrincipal());
                LOGGER.debug("Duo has successfully authenticated [{}]", (Object)principal.getId());
                return this.createHandlerResult(credential, principal, new ArrayList(0));
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new FailedLoginException("Duo authentication has failed");
    }

    private AuthenticationHandlerExecutionResult authenticateDuoCredential(Credential credential) throws FailedLoginException {
        try {
            DuoSecurityCredential duoCredential = (DuoSecurityCredential)credential;
            if (!duoCredential.isValid()) {
                throw new GeneralSecurityException("Duo credential validation failed. Ensure a username  and the signed Duo response is configured and passed. Credential received: " + duoCredential);
            }
            DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).getDuoAuthenticationService();
            String userId = duoAuthenticationService.authenticate((Credential)duoCredential).getUsername();
            LOGGER.debug("Verified Duo authentication for user [{}]", (Object)userId);
            String primaryCredentialsUsername = duoCredential.getUsername();
            boolean isGoodAuthentication = userId.equals(primaryCredentialsUsername);
            if (isGoodAuthentication) {
                LOGGER.info("Successful Duo authentication for [{}]", (Object)primaryCredentialsUsername);
                Principal principal = this.principalFactory.createPrincipal(userId);
                return this.createHandlerResult(credential, principal, new ArrayList(0));
            }
            throw new FailedLoginException("Duo authentication username " + primaryCredentialsUsername + " does not match Duo response: " + userId);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new FailedLoginException(e.getMessage());
        }
    }

    @Generated
    public ObjectProvider<? extends DuoSecurityMultifactorAuthenticationProvider> getMultifactorAuthenticationProvider() {
        return this.multifactorAuthenticationProvider;
    }
}

