/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow;

import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.webauthn.data.ByteArray;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.webauthn.WebAuthnMultifactorAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WebAuthnAccountSaveRegistrationAction
extends AbstractMultifactorAuthenticationAction<WebAuthnMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnAccountSaveRegistrationAction.class);
    private final RegistrationStorage webAuthnCredentialRepository;
    private final SessionManager sessionManager;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal());
        String sessionToken = requestContext.getRequestParameters().getRequired("sessionToken");
        LOGGER.trace("Checking registration record for [{}] by session id [{}]", (Object)principal.getId(), (Object)sessionToken);
        ByteArray token = ByteArray.fromBase64Url((String)sessionToken);
        Set credentials = this.webAuthnCredentialRepository.getCredentialIdsForUsername(principal.getId());
        if (!credentials.isEmpty() && this.sessionManager.getSession(token).isPresent()) {
            return this.success();
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        WebUtils.produceErrorView((HttpServletRequest)request, (HttpStatus)HttpStatus.BAD_REQUEST, (String)"Unable to verify registration record");
        return this.error();
    }

    @Generated
    public WebAuthnAccountSaveRegistrationAction(RegistrationStorage webAuthnCredentialRepository, SessionManager sessionManager) {
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
        this.sessionManager = sessionManager;
    }

    @Generated
    public RegistrationStorage getWebAuthnCredentialRepository() {
        return this.webAuthnCredentialRepository;
    }

    @Generated
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

