/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.CasServerProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionOptionalSigningOptionalJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthCsrfCookieProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.configuration.model.support.replication.CookieSessionReplicationProperties;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.pac4j.DistributedJEESessionStore;
import org.apereo.cas.pac4j.PrefixedSessionStore;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ClientIdAwareProfileManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20AccessTokenAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20AuthenticationClientProvider;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientIdClientSecretAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20DefaultCasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuth20ProofKeyCodeExchangeAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20RefreshTokenAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20UsernamePasswordAuthenticator;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuth20RegisteredServiceCipherExecutor;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.DefaultOAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20IdTokenAndTokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20IdTokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20ProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20TokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20AuthorizationCodeGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20ClientCredentialsGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20DeviceCodeResponseTypeRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20PasswordGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20RefreshTokenGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20RevocationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.DefaultOAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.OAuth20CasCallbackUrlResolver;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20AccessTokenGrantRequestAuditResourceResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20AccessTokenResponseAuditResourceResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20CodeResponseAuditResourceResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20UserProfileDataAuditResourceResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.OAuth20DefaultCasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20DefaultTokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenClientCredentialsGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenDeviceCodeResponseRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantAuditableRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenPasswordGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRefreshTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20DefaultAccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenCipherExecutor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20RegisteredServiceJwtAccessTokenCipherExecutor;
import org.apereo.cas.support.oauth.web.response.callback.DefaultOAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationCodeAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ClientCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20InvalidAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResourceOwnerCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20DefaultUserProfileViewRenderer;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.TicketValidator;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenExpirationPolicyBuilder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20DefaultAccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20JwtBuilder;
import org.apereo.cas.ticket.code.OAuth20CodeExpirationPolicyBuilder;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.code.OAuth20DefaultOAuthCodeFactory;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceUserCodeFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenExpirationPolicyBuilder;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.refreshtoken.OAuth20DefaultRefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenExpirationPolicyBuilder;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.InternalTicketValidator;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.validation.AssertionImpl;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.matching.matcher.csrf.CsrfTokenGenerator;
import org.pac4j.core.matching.matcher.csrf.CsrfTokenGeneratorMatcher;
import org.pac4j.core.matching.matcher.csrf.DefaultCsrfTokenGenerator;
import org.pac4j.http.client.direct.DirectBasicAuthClient;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.OAuth)
@AutoConfiguration
public class CasOAuth20Configuration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasOAuth20Configuration.class);
    private static final String OAUTH_OIDC_SERVER_SUPPORT_PREFIX = "OauthOidcServerSupport";

    @Configuration(value="CasOAuth20AuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20AuditConfiguration {
        @ConditionalOnMissingBean(name={"accessTokenGrantAuditableRequestExtractor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditableExecution accessTokenGrantAuditableRequestExtractor(List<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors) {
            return new AccessTokenGrantAuditableRequestExtractor(accessTokenGrantRequestExtractors);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthAuditTrailRecordResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer oauthAuditTrailRecordResolutionPlanConfigurer() {
            return plan -> {
                plan.registerAuditActionResolver("OAUTH2_USER_PROFILE_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
                plan.registerAuditResourceResolver("OAUTH2_USER_PROFILE_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20UserProfileDataAuditResourceResolver());
                plan.registerAuditActionResolver("OAUTH2_ACCESS_TOKEN_REQUEST_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
                plan.registerAuditResourceResolver("OAUTH2_ACCESS_TOKEN_REQUEST_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20AccessTokenGrantRequestAuditResourceResolver());
                plan.registerAuditActionResolver("OAUTH2_ACCESS_TOKEN_RESPONSE_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
                plan.registerAuditResourceResolver("OAUTH2_ACCESS_TOKEN_RESPONSE_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20AccessTokenResponseAuditResourceResolver());
                plan.registerAuditActionResolver("OAUTH2_CODE_RESPONSE_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_CREATED"));
                plan.registerAuditResourceResolver("OAUTH2_CODE_RESPONSE_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20CodeResponseAuditResourceResolver());
            };
        }
    }

    @Configuration(value="CasOAuth20AuthenticatorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20AuthenticatorConfiguration {
        @ConditionalOnMissingBean(name={"oauthCasAuthenticationBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CasAuthenticationBuilder oauthCasAuthenticationBuilder(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="oauthPrincipalFactory") PrincipalFactory oauthPrincipalFactory, @Qualifier(value="profileScopeToAttributesFilter") OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, CasConfigurationProperties casProperties) {
            return new OAuth20DefaultCasAuthenticationBuilder(oauthPrincipalFactory, webApplicationServiceFactory, profileScopeToAttributesFilter, oauthRequestParameterResolver, casProperties);
        }

        @ConditionalOnMissingBean(name={"oauthClientAuthenticator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oauthClientAuthenticator(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="oauth20ClientSecretValidator") OAuth20ClientSecretValidator oauth20ClientSecretValidator) {
            return new OAuth20ClientIdClientSecretAuthenticator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, ticketRegistry, defaultPrincipalResolver, oauthRequestParameterResolver, oauth20ClientSecretValidator);
        }

        @ConditionalOnMissingBean(name={"oAuthProofKeyCodeExchangeAuthenticator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oAuthProofKeyCodeExchangeAuthenticator(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="oauth20ClientSecretValidator") OAuth20ClientSecretValidator oauth20ClientSecretValidator) {
            return new OAuth20ProofKeyCodeExchangeAuthenticator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, ticketRegistry, defaultPrincipalResolver, oauthRequestParameterResolver, oauth20ClientSecretValidator);
        }

        @ConditionalOnMissingBean(name={"oAuthRefreshTokenAuthenticator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oAuthRefreshTokenAuthenticator(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="oauth20ClientSecretValidator") OAuth20ClientSecretValidator oauth20ClientSecretValidator) {
            return new OAuth20RefreshTokenAuthenticator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, ticketRegistry, defaultPrincipalResolver, oauthRequestParameterResolver, oauth20ClientSecretValidator);
        }

        @ConditionalOnMissingBean(name={"oauthUserAuthenticator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oauthUserAuthenticator(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="oauth20ClientSecretValidator") OAuth20ClientSecretValidator oauth20ClientSecretValidator, @Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy) {
            return new OAuth20UsernamePasswordAuthenticator(authenticationSystemSupport, servicesManager, webApplicationServiceFactory, oauthDistributedSessionStore, oauthRequestParameterResolver, oauth20ClientSecretValidator, authenticationAttributeReleasePolicy);
        }

        @ConditionalOnMissingBean(name={"oauthAccessTokenAuthenticator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Authenticator oauthAccessTokenAuthenticator(@Qualifier(value="profileScopeToAttributesFilter") OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, @Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return new OAuth20AccessTokenAuthenticator(ticketRegistry, accessTokenJwtBuilder, profileScopeToAttributesFilter, authenticationAttributeReleasePolicy);
        }
    }

    @Configuration(value="CasOAuth20ResponseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ResponseConfiguration {
        @ConditionalOnMissingBean(name={"oauthResourceOwnerCredentialsResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationResponseBuilder oauthResourceOwnerCredentialsResponseBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext oauth20ConfigurationContext) {
            return new OAuth20ResourceOwnerCredentialsResponseBuilder(oauth20ConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }

        @ConditionalOnMissingBean(name={"oauthClientCredentialsResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationResponseBuilder oauthClientCredentialsResponseBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext oauth20ConfigurationContext) {
            return new OAuth20ClientCredentialsResponseBuilder(oauth20ConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }

        @ConditionalOnMissingBean(name={"oauthTokenResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationResponseBuilder oauthTokenResponseBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext oauth20ConfigurationContext) {
            return new OAuth20TokenAuthorizationResponseBuilder(oauth20ConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }

        @ConditionalOnMissingBean(name={"oauthAuthorizationCodeResponseBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationResponseBuilder oauthAuthorizationCodeResponseBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new OAuth20AuthorizationCodeAuthorizationResponseBuilder(context, oauthAuthorizationModelAndViewBuilder);
        }

        @ConditionalOnMissingBean(name={"oauthInvalidAuthorizationBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationBuilder(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OAuth20InvalidAuthorizationResponseBuilder(servicesManager, oauthRequestParameterResolver);
        }
    }

    @Configuration(value="CasOAuth20TicketsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20TicketsConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"accessTokenExpirationPolicy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder accessTokenExpirationPolicy(CasConfigurationProperties casProperties) {
            return new OAuth20AccessTokenExpirationPolicyBuilder(casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"deviceTokenExpirationPolicy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder deviceTokenExpirationPolicy(CasConfigurationProperties casProperties) {
            return new OAuth20DeviceTokenExpirationPolicyBuilder(casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder oAuthCodeExpirationPolicy(CasConfigurationProperties casProperties) {
            return new OAuth20CodeExpirationPolicyBuilder(casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oAuthCodeIdGenerator"})
        public UniqueTicketIdGenerator oAuthCodeIdGenerator() {
            return new DefaultUniqueTicketIdGenerator();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"refreshTokenIdGenerator"})
        public UniqueTicketIdGenerator refreshTokenIdGenerator() {
            return new DefaultUniqueTicketIdGenerator();
        }

        @ConditionalOnMissingBean(name={"accessTokenIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator accessTokenIdGenerator() {
            return new DefaultUniqueTicketIdGenerator();
        }

        @ConditionalOnMissingBean(name={"deviceTokenIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator deviceTokenIdGenerator() {
            return new DefaultUniqueTicketIdGenerator();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder refreshTokenExpirationPolicy(CasConfigurationProperties casProperties) {
            return new OAuth20RefreshTokenExpirationPolicyBuilder(casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultRefreshTokenFactory"})
        public OAuth20RefreshTokenFactory defaultRefreshTokenFactory(@Qualifier(value="refreshTokenIdGenerator") UniqueTicketIdGenerator refreshTokenIdGenerator, @Qualifier(value="refreshTokenExpirationPolicy") ExpirationPolicyBuilder refreshTokenExpirationPolicy, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return new OAuth20DefaultRefreshTokenFactory(refreshTokenIdGenerator, refreshTokenExpirationPolicy, servicesManager, casProperties.getLogout().isRemoveDescendantTickets());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultAccessTokenFactory"})
        public OAuth20AccessTokenFactory defaultAccessTokenFactory(@Qualifier(value="accessTokenIdGenerator") UniqueTicketIdGenerator accessTokenIdGenerator, @Qualifier(value="accessTokenExpirationPolicy") ExpirationPolicyBuilder accessTokenExpirationPolicy, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder) {
            return new OAuth20DefaultAccessTokenFactory(accessTokenIdGenerator, accessTokenExpirationPolicy, accessTokenJwtBuilder, servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultDeviceTokenFactory"})
        public OAuth20DeviceTokenFactory defaultDeviceTokenFactory(@Qualifier(value="deviceTokenExpirationPolicy") ExpirationPolicyBuilder deviceTokenExpirationPolicy, @Qualifier(value="deviceTokenIdGenerator") UniqueTicketIdGenerator deviceTokenIdGenerator, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return new OAuth20DefaultDeviceTokenFactory(deviceTokenIdGenerator, deviceTokenExpirationPolicy, casProperties.getAuthn().getOauth().getDeviceUserCode().getUserCodeLength(), servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultDeviceUserCodeFactory"})
        public OAuth20DeviceUserCodeFactory defaultDeviceUserCodeFactory(@Qualifier(value="deviceTokenExpirationPolicy") ExpirationPolicyBuilder deviceTokenExpirationPolicy, @Qualifier(value="deviceTokenIdGenerator") UniqueTicketIdGenerator deviceTokenIdGenerator, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return new OAuth20DefaultDeviceUserCodeFactory(deviceTokenIdGenerator, deviceTokenExpirationPolicy, casProperties.getAuthn().getOauth().getDeviceUserCode().getUserCodeLength(), servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultOAuthCodeFactory"})
        public OAuth20CodeFactory defaultOAuthCodeFactory(@Qualifier(value="protocolTicketCipherExecutor") CipherExecutor protocolTicketCipherExecutor, @Qualifier(value="oAuthCodeIdGenerator") UniqueTicketIdGenerator oAuthCodeIdGenerator, @Qualifier(value="oAuthCodeExpirationPolicy") ExpirationPolicyBuilder oAuthCodeExpirationPolicy, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OAuth20DefaultOAuthCodeFactory(oAuthCodeIdGenerator, oAuthCodeExpirationPolicy, servicesManager, protocolTicketCipherExecutor);
        }
    }

    @Configuration(value="CasOAuth20TicketFactoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20TicketFactoryPlanConfiguration {
        @ConditionalOnMissingBean(name={"defaultRefreshTokenFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultRefreshTokenFactoryConfigurer(@Qualifier(value="defaultRefreshTokenFactory") OAuth20RefreshTokenFactory defaultRefreshTokenFactory) {
            return () -> defaultRefreshTokenFactory;
        }

        @ConditionalOnMissingBean(name={"defaultDeviceUserCodeFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultDeviceUserCodeFactoryConfigurer(@Qualifier(value="defaultDeviceUserCodeFactory") OAuth20DeviceUserCodeFactory defaultDeviceUserCodeFactory) {
            return () -> defaultDeviceUserCodeFactory;
        }

        @ConditionalOnMissingBean(name={"defaultAccessTokenFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultAccessTokenFactoryConfigurer(@Qualifier(value="defaultAccessTokenFactory") OAuth20AccessTokenFactory defaultAccessTokenFactory) {
            return () -> defaultAccessTokenFactory;
        }

        @ConditionalOnMissingBean(name={"defaultDeviceTokenFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultDeviceTokenFactoryConfigurer(@Qualifier(value="defaultDeviceTokenFactory") OAuth20DeviceTokenFactory defaultDeviceTokenFactory) {
            return () -> defaultDeviceTokenFactory;
        }

        @ConditionalOnMissingBean(name={"defaultOAuthCodeFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultOAuthCodeFactoryConfigurer(@Qualifier(value="defaultOAuthCodeFactory") OAuth20CodeFactory defaultOAuthCodeFactory) {
            return () -> defaultOAuthCodeFactory;
        }
    }

    @Configuration(value="CasOAuth20ValidatorsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ValidatorsConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oauth20ClientSecretValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20ClientSecretValidator oauth20ClientSecretValidator(@Qualifier(value="oauthRegisteredServiceCipherExecutor") CipherExecutor oauthRegisteredServiceCipherExecutor) {
            return new DefaultOAuth20ClientSecretValidator(oauthRegisteredServiceCipherExecutor);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oauth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            List grantTypesSupported = context.getCasProperties().getAuthn().getOidc().getDiscovery().getGrantTypesSupported();
            return (OAuth20TokenRequestValidator)BeanSupplier.of(OAuth20TokenRequestValidator.class).when(grantTypesSupported.contains(OAuth20GrantTypes.AUTHORIZATION_CODE.getType())).supply(() -> new OAuth20AuthorizationCodeGrantTypeProofKeyCodeExchangeTokenRequestValidator(context)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthAuthorizationCodeGrantTypeTokenRequestValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oauthAuthorizationCodeGrantTypeTokenRequestValidator(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext oauth20ConfigurationContext) {
            List grantTypesSupported = oauth20ConfigurationContext.getCasProperties().getAuthn().getOidc().getDiscovery().getGrantTypesSupported();
            return (OAuth20TokenRequestValidator)BeanSupplier.of(OAuth20TokenRequestValidator.class).when(grantTypesSupported.contains(OAuth20GrantTypes.AUTHORIZATION_CODE.getType())).supply(() -> new OAuth20AuthorizationCodeGrantTypeTokenRequestValidator(oauth20ConfigurationContext)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthDeviceCodeResponseTypeRequestValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oauthDeviceCodeResponseTypeRequestValidator(CasConfigurationProperties casProperties, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            List responseTypesSupported = casProperties.getAuthn().getOidc().getDiscovery().getResponseTypesSupported();
            return (OAuth20TokenRequestValidator)BeanSupplier.of(OAuth20TokenRequestValidator.class).when(responseTypesSupported.contains(OAuth20ResponseTypes.DEVICE_CODE.getType())).supply(() -> new OAuth20DeviceCodeResponseTypeRequestValidator(servicesManager, webApplicationServiceFactory, oauthRequestParameterResolver)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthRevocationRequestValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oauthRevocationRequestValidator(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OAuth20RevocationRequestValidator(servicesManager, oauthDistributedSessionStore, oauthRequestParameterResolver);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthRefreshTokenGrantTypeTokenRequestValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oauthRefreshTokenGrantTypeTokenRequestValidator(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext oauth20ConfigurationContext) {
            List grantTypesSupported = oauth20ConfigurationContext.getCasProperties().getAuthn().getOidc().getDiscovery().getGrantTypesSupported();
            return (OAuth20TokenRequestValidator)BeanSupplier.of(OAuth20TokenRequestValidator.class).when(grantTypesSupported.contains(OAuth20GrantTypes.REFRESH_TOKEN.getType())).supply(() -> new OAuth20RefreshTokenGrantTypeTokenRequestValidator(oauth20ConfigurationContext)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthPasswordGrantTypeTokenRequestValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oauthPasswordGrantTypeTokenRequestValidator(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext oauth20ConfigurationContext) {
            List grantTypesSupported = oauth20ConfigurationContext.getCasProperties().getAuthn().getOidc().getDiscovery().getGrantTypesSupported();
            return (OAuth20TokenRequestValidator)BeanSupplier.of(OAuth20TokenRequestValidator.class).when(grantTypesSupported.contains(OAuth20GrantTypes.PASSWORD.getType())).supply(() -> new OAuth20PasswordGrantTypeTokenRequestValidator(oauth20ConfigurationContext)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthClientCredentialsGrantTypeTokenRequestValidator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oauthClientCredentialsGrantTypeTokenRequestValidator(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext oauth20ConfigurationContext) {
            List grantTypesSupported = oauth20ConfigurationContext.getCasProperties().getAuthn().getOidc().getDiscovery().getGrantTypesSupported();
            return (OAuth20TokenRequestValidator)BeanSupplier.of(OAuth20TokenRequestValidator.class).when(grantTypesSupported.contains(OAuth20GrantTypes.CLIENT_CREDENTIALS.getType())).supply(() -> new OAuth20ClientCredentialsGrantTypeTokenRequestValidator(oauth20ConfigurationContext)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oauthAuthorizationCodeResponseTypeRequestValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationRequestValidator oauthAuthorizationCodeResponseTypeRequestValidator(CasConfigurationProperties casProperties, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            List responseTypesSupported = casProperties.getAuthn().getOidc().getDiscovery().getResponseTypesSupported();
            return (OAuth20AuthorizationRequestValidator)BeanSupplier.of(OAuth20AuthorizationRequestValidator.class).when(() -> responseTypesSupported.contains(OAuth20ResponseTypes.CODE.getType())).supply(() -> new OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, oauthRequestParameterResolver)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oauthProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationRequestValidator oauthProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator(CasConfigurationProperties casProperties, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            List responseTypesSupported = casProperties.getAuthn().getOidc().getDiscovery().getResponseTypesSupported();
            return (OAuth20AuthorizationRequestValidator)BeanSupplier.of(OAuth20AuthorizationRequestValidator.class).when(() -> responseTypesSupported.contains(OAuth20ResponseTypes.CODE.getType())).supply(() -> new OAuth20ProofKeyCodeExchangeResponseTypeAuthorizationRequestValidator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, oauthRequestParameterResolver)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oauthTokenResponseTypeRequestValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationRequestValidator oauthTokenResponseTypeRequestValidator(CasConfigurationProperties casProperties, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            List responseTypesSupported = casProperties.getAuthn().getOidc().getDiscovery().getResponseTypesSupported();
            return (OAuth20AuthorizationRequestValidator)BeanSupplier.of(OAuth20AuthorizationRequestValidator.class).when(() -> responseTypesSupported.contains(OAuth20ResponseTypes.TOKEN.getType())).supply(() -> new OAuth20TokenResponseTypeAuthorizationRequestValidator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, oauthRequestParameterResolver)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oauthIdTokenResponseTypeRequestValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationRequestValidator oauthIdTokenResponseTypeRequestValidator(CasConfigurationProperties casProperties, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            List responseTypesSupported = casProperties.getAuthn().getOidc().getDiscovery().getResponseTypesSupported();
            return (OAuth20AuthorizationRequestValidator)BeanSupplier.of(OAuth20AuthorizationRequestValidator.class).when(() -> responseTypesSupported.contains(OAuth20ResponseTypes.ID_TOKEN.getType())).supply(() -> new OAuth20IdTokenResponseTypeAuthorizationRequestValidator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, oauthRequestParameterResolver)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oauthIdTokenAndTokenResponseTypeRequestValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationRequestValidator oauthIdTokenAndTokenResponseTypeRequestValidator(CasConfigurationProperties casProperties, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            List responseTypesSupported = casProperties.getAuthn().getOidc().getDiscovery().getResponseTypesSupported();
            return (OAuth20AuthorizationRequestValidator)BeanSupplier.of(OAuth20AuthorizationRequestValidator.class).when(() -> responseTypesSupported.contains(OAuth20ResponseTypes.IDTOKEN_TOKEN.getType())).supply(() -> new OAuth20IdTokenAndTokenResponseTypeAuthorizationRequestValidator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, oauthRequestParameterResolver)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasOAuth20CoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20CoreConfiguration {
        @ConditionalOnMissingBean(name={"oauthRequestParameterResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20RequestParameterResolver oauthRequestParameterResolver(@Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder) {
            return new DefaultOAuth20RequestParameterResolver(accessTokenJwtBuilder);
        }

        @ConditionalOnMissingBean(name={"oauthPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory oauthPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oauthAuthorizationModelAndViewBuilder"})
        public OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder() {
            return new DefaultOAuth20AuthorizationModelAndViewBuilder();
        }

        @ConditionalOnMissingBean(name={"oauthUserProfileViewRenderer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20UserProfileViewRenderer oauthUserProfileViewRenderer(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return new OAuth20DefaultUserProfileViewRenderer(servicesManager, casProperties.getAuthn().getOauth());
        }

        @ConditionalOnMissingBean(name={"callbackAuthorizeViewResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
            return OAuth20CallbackAuthorizeViewResolver.asDefault();
        }

        @ConditionalOnMissingBean(name={"profileScopeToAttributesFilter"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
            return new DefaultOAuth20ProfileScopeToAttributesFilter();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"oauthRegisteredServiceCipherExecutor"})
        public CipherExecutor oauthRegisteredServiceCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionOptionalSigningOptionalJwtCryptographyProperties crypto = casProperties.getAuthn().getOauth().getCrypto();
            boolean bl = !crypto.isEnabled() && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey());
            Boolean enabled = (Boolean)FunctionUtils.doIf((boolean)bl, () -> {
                LOGGER.warn("Secret encryption/signing is not enabled explicitly in the configuration for OAuth/OIDC services, yet signing/encryption keys are defined for operations. CAS will proceed to enable the encryption/signing functionality.");
                return Boolean.TRUE;
            }, () -> ((EncryptionOptionalSigningOptionalJwtCryptographyProperties)crypto).isEnabled()).get();
            if (enabled.booleanValue()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionOptionalSigningOptionalJwtCryptographyProperties)crypto, OAuth20RegisteredServiceCipherExecutor.class);
            }
            LOGGER.info("Relying party secret encryption/signing is turned off for OAuth/OIDC services. This MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of relying party secrets.");
            return CipherExecutor.noOp();
        }

        @ConditionalOnMissingBean(name={"oauthCasClientRedirectActionBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
            return new OAuth20DefaultCasClientRedirectActionBuilder();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casCallbackUrlResolver"})
        public UrlResolver casCallbackUrlResolver(CasConfigurationProperties casProperties, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver) {
            String callbackUrl = OAuth20Utils.casOAuthCallbackUrl((String)casProperties.getServer().getPrefix());
            return new OAuth20CasCallbackUrlResolver(callbackUrl, oauthRequestParameterResolver);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthSecCsrfTokenMatcher"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Matcher oauthSecCsrfTokenMatcher(CasConfigurationProperties casProperties) {
            CsrfTokenGeneratorMatcher csrfMatcher = new CsrfTokenGeneratorMatcher((CsrfTokenGenerator)new DefaultCsrfTokenGenerator());
            OAuthProperties oauth = casProperties.getAuthn().getOauth();
            OAuthCsrfCookieProperties csrfCookie = oauth.getCsrfCookie();
            int maxAge = csrfCookie.getMaxAge();
            if (maxAge >= 0) {
                csrfMatcher.setMaxAge(Integer.valueOf(maxAge));
            }
            csrfMatcher.setSameSitePolicy(csrfCookie.getSameSitePolicy());
            csrfMatcher.setDomain(csrfCookie.getDomain());
            csrfMatcher.setPath(csrfCookie.getPath());
            csrfMatcher.setHttpOnly(Boolean.valueOf(csrfCookie.isHttpOnly()));
            csrfMatcher.setSecure(Boolean.valueOf(csrfCookie.isSecure()));
            return csrfMatcher;
        }
    }

    @Configuration(value="CasOAuth20LogoutConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20LogoutConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"oauthLogoutExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LogoutExecutionPlanConfigurer oauthLogoutExecutionPlanConfigurer(CasConfigurationProperties casProperties, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore) {
            return plan -> {
                boolean replicate = casProperties.getAuthn().getOauth().getSessionReplication().isReplicateSessions();
                if (replicate) {
                    plan.registerLogoutPostProcessor(ticketGrantingTicket -> {
                        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
                        HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
                        if (request != null && response != null) {
                            oauthDistributedSessionStore.destroySession((WebContext)new JEEContext(request, response));
                        }
                    });
                }
            };
        }
    }

    @Configuration(value="CasOAuth20SessionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20SessionConfiguration {
        @ConditionalOnMissingBean(name={"oauthDistributedSessionCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder oauthDistributedSessionCookieGenerator(CasConfigurationProperties casProperties) {
            CookieSessionReplicationProperties cookie = casProperties.getAuthn().getOauth().getSessionReplication().getCookie();
            if (StringUtils.isBlank((CharSequence)cookie.getName())) {
                cookie.setName("DISSESSIONOauthOidcServerSupport");
            }
            return CookieUtils.buildCookieRetrievingGenerator((CookieProperties)cookie);
        }

        @ConditionalOnMissingBean(name={"oauthDistributedSessionStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SessionStore oauthDistributedSessionStore(@Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="oauthDistributedSessionCookieGenerator") CasCookieBuilder oauthDistributedSessionCookieGenerator, CasConfigurationProperties casProperties) {
            boolean replicate = casProperties.getAuthn().getOauth().getSessionReplication().isReplicateSessions();
            if (replicate) {
                return new DistributedJEESessionStore(ticketRegistry, ticketFactory, oauthDistributedSessionCookieGenerator);
            }
            PrefixedSessionStore sessionStore = new PrefixedSessionStore();
            sessionStore.setPrefix(CasOAuth20Configuration.OAUTH_OIDC_SERVER_SUPPORT_PREFIX);
            return sessionStore;
        }
    }

    @Configuration(value="CasOAuth20ExtractorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ExtractorConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccessTokenGrantRequestExtractor accessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new AccessTokenProofKeyCodeExchangeAuthorizationCodeGrantRequestExtractor(context);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccessTokenGrantRequestExtractor accessTokenAuthorizationCodeGrantRequestExtractor(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new AccessTokenAuthorizationCodeGrantRequestExtractor(context);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccessTokenGrantRequestExtractor accessTokenRefreshTokenGrantRequestExtractor(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new AccessTokenRefreshTokenGrantRequestExtractor(context);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccessTokenGrantRequestExtractor accessTokenPasswordGrantRequestExtractor(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new AccessTokenPasswordGrantRequestExtractor(context);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccessTokenGrantRequestExtractor accessTokenClientCredentialsGrantRequestExtractor(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new AccessTokenClientCredentialsGrantRequestExtractor(context);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccessTokenGrantRequestExtractor accessTokenDeviceCodeResponseRequestExtractor(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new AccessTokenDeviceCodeResponseRequestExtractor(context);
        }
    }

    @Configuration(value="CasOAuth20ClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ClientConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Client oauthCasClient(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="oauthCasClientRedirectActionBuilder") OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder, @Qualifier(value="casCallbackUrlResolver") UrlResolver casCallbackUrlResolver, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, CasConfigurationProperties casProperties, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy) {
            CasServerProperties server = casProperties.getServer();
            CasConfiguration cfg = new CasConfiguration(server.getLoginUrl());
            InternalTicketValidator validator = new InternalTicketValidator(centralAuthenticationService, webApplicationServiceFactory, authenticationAttributeReleasePolicy, servicesManager);
            cfg.setDefaultTicketValidator((ticket, service) -> {
                TicketValidator.ValidationResult validationResult = validator.validate(ticket, service);
                Assertion assertion = (Assertion)validationResult.getContext().get(Assertion.class.getName());
                HashMap principalAttributes = new HashMap(validationResult.getPrincipal().getAttributes());
                principalAttributes.putAll(validationResult.getContext());
                AttributePrincipalImpl attrPrincipal = new AttributePrincipalImpl(validationResult.getPrincipal().getId(), principalAttributes);
                RegisteredService registeredService = (RegisteredService)validationResult.getContext().get(RegisteredService.class.getName());
                Map authenticationAttributes = authenticationAttributeReleasePolicy.getAuthenticationAttributesForRelease(assertion.getPrimaryAuthentication(), assertion, new HashMap(0), registeredService);
                return new AssertionImpl((AttributePrincipal)attrPrincipal, authenticationAttributes);
            });
            cfg.setHostnameVerifier(casSslContext.getHostnameVerifier());
            cfg.setSslSocketFactory(casSslContext.getSslContext().getSocketFactory());
            CasClient oauthCasClient = new CasClient(cfg);
            oauthCasClient.setRedirectionActionBuilder((webContext, sessionStore) -> oauthCasClientRedirectActionBuilder.build(oauthCasClient, webContext));
            oauthCasClient.setName("CasOAuthClient");
            oauthCasClient.setUrlResolver(casCallbackUrlResolver);
            oauthCasClient.setCallbackUrl(OAuth20Utils.casOAuthCallbackUrl((String)server.getPrefix()));
            oauthCasClient.setCheckAuthenticationAttempt(false);
            oauthCasClient.init();
            return oauthCasClient;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Client basicAuthClient(@Qualifier(value="oauthClientAuthenticator") Authenticator oauthClientAuthenticator) {
            DirectBasicAuthClient basicAuthClient = new DirectBasicAuthClient(oauthClientAuthenticator);
            basicAuthClient.setName("clientBasicAuth");
            basicAuthClient.init();
            return basicAuthClient;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Client directFormClient(@Qualifier(value="oauthClientAuthenticator") Authenticator oauthClientAuthenticator) {
            DirectFormClient directFormClient = new DirectFormClient(oauthClientAuthenticator);
            directFormClient.setName("clientForm");
            directFormClient.setUsernameParameter("client_id");
            directFormClient.setPasswordParameter("client_secret");
            directFormClient.init();
            return directFormClient;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Client pkceAuthnFormClient(@Qualifier(value="oAuthProofKeyCodeExchangeAuthenticator") Authenticator oAuthProofKeyCodeExchangeAuthenticator) {
            DirectFormClient pkceAuthnFormClient = new DirectFormClient(oAuthProofKeyCodeExchangeAuthenticator);
            pkceAuthnFormClient.setName("pkceFormAuthn");
            pkceAuthnFormClient.setUsernameParameter("client_id");
            pkceAuthnFormClient.setPasswordParameter("code_verifier");
            pkceAuthnFormClient.init();
            return pkceAuthnFormClient;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Client pkceBasicAuthClient(@Qualifier(value="oAuthProofKeyCodeExchangeAuthenticator") Authenticator oAuthProofKeyCodeExchangeAuthenticator) {
            DirectBasicAuthClient pkceBasicAuthClient = new DirectBasicAuthClient(oAuthProofKeyCodeExchangeAuthenticator);
            pkceBasicAuthClient.setName("pkceBasicAuthn");
            pkceBasicAuthClient.init();
            return pkceBasicAuthClient;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Client refreshTokenFormClient(@Qualifier(value="oAuthRefreshTokenAuthenticator") Authenticator oAuthRefreshTokenAuthenticator) {
            DirectFormClient refreshTokenFormClient = new DirectFormClient(oAuthRefreshTokenAuthenticator);
            refreshTokenFormClient.setName("clientRefreshTokenFormAuth");
            refreshTokenFormClient.setUsernameParameter("client_id");
            refreshTokenFormClient.setPasswordParameter("refresh_token");
            refreshTokenFormClient.init();
            return refreshTokenFormClient;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Client userFormClient(@Qualifier(value="oauthUserAuthenticator") Authenticator oauthUserAuthenticator) {
            DirectFormClient userFormClient = new DirectFormClient(oauthUserAuthenticator);
            userFormClient.setName("userForm");
            userFormClient.init();
            return userFormClient;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Client accessTokenClient(@Qualifier(value="oauthAccessTokenAuthenticator") Authenticator oauthAccessTokenAuthenticator) {
            HeaderClient accessTokenClient = new HeaderClient();
            accessTokenClient.setCredentialsExtractor((CredentialsExtractor)new BearerAuthExtractor());
            accessTokenClient.setAuthenticator(oauthAccessTokenAuthenticator);
            accessTokenClient.setName("clientAccessTokenAuth");
            accessTokenClient.init();
            return accessTokenClient;
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthSecConfigClients"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<Client> oauthSecConfigClients(@Qualifier(value="basicAuthClient") Client basicAuthClient, @Qualifier(value="directFormClient") Client directFormClient, @Qualifier(value="pkceAuthnFormClient") Client pkceAuthnFormClient, @Qualifier(value="pkceBasicAuthClient") Client pkceBasicAuthClient, @Qualifier(value="refreshTokenFormClient") Client refreshTokenFormClient, @Qualifier(value="oauthCasClient") Client oauthCasClient, @Qualifier(value="userFormClient") Client userFormClient, @Qualifier(value="accessTokenClient") Client accessTokenClient, ObjectProvider<List<OAuth20AuthenticationClientProvider>> providers) {
            List clientProviders = Optional.ofNullable((List)providers.getIfAvailable()).orElseGet(ArrayList::new);
            AnnotationAwareOrderComparator.sort((List)clientProviders);
            ArrayList<Client> clientList = new ArrayList<Client>();
            clientProviders.forEach(p -> clientList.add(p.createClient()));
            clientList.add(oauthCasClient);
            clientList.add(basicAuthClient);
            clientList.add(pkceAuthnFormClient);
            clientList.add(pkceBasicAuthClient);
            clientList.add(refreshTokenFormClient);
            clientList.add(directFormClient);
            clientList.add(userFormClient);
            clientList.add(accessTokenClient);
            return BeanContainer.of(clientList);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthSecConfig"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Config oauthSecConfig(@Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, @Qualifier(value="oauthSecCsrfTokenMatcher") Matcher oauthSecCsrfTokenMatcher, @Qualifier(value="oauthSecConfigClients") BeanContainer<Client> oauthSecConfigClients, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) throws Exception {
            String callbackUrl = OAuth20Utils.casOAuthCallbackUrl((String)casProperties.getServer().getPrefix());
            Config config = new Config(callbackUrl, oauthSecConfigClients.toList());
            config.setSessionStore(oauthDistributedSessionStore);
            config.setMatcher(oauthSecCsrfTokenMatcher);
            Config.setProfileManagerFactory((String)"CASOAuthSecurityProfileManager", (webContext, sessionStore) -> new OAuth20ClientIdAwareProfileManager(webContext, config.getSessionStore(), servicesManager, oauthRequestParameterResolver));
            return config;
        }
    }

    @Configuration(value="CasOAuth20TokenGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20TokenGeneratorConfiguration {
        @ConditionalOnMissingBean(name={"oauthTokenGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenGenerator oauthTokenGenerator(@Qualifier(value="defaultDeviceUserCodeFactory") OAuth20DeviceUserCodeFactory defaultDeviceUserCodeFactory, @Qualifier(value="defaultDeviceTokenFactory") OAuth20DeviceTokenFactory defaultDeviceTokenFactory, @Qualifier(value="defaultRefreshTokenFactory") OAuth20RefreshTokenFactory defaultRefreshTokenFactory, @Qualifier(value="defaultAccessTokenFactory") OAuth20AccessTokenFactory defaultAccessTokenFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties) {
            return new OAuth20DefaultTokenGenerator(defaultAccessTokenFactory, defaultDeviceTokenFactory, defaultDeviceUserCodeFactory, defaultRefreshTokenFactory, ticketRegistry, casProperties);
        }

        @ConditionalOnMissingBean(name={"accessTokenResponseGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator(@Qualifier(value="profileScopeToAttributesFilter") OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, CasConfigurationProperties casProperties) {
            return new OAuth20DefaultAccessTokenResponseGenerator(accessTokenJwtBuilder, casProperties, profileScopeToAttributesFilter);
        }
    }

    @Configuration(value="CasOAuth20WebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20WebConfiguration {
        @ConditionalOnMissingBean(name={"consentApprovalViewResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ConsentApprovalViewResolver consentApprovalViewResolver(@Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, CasConfigurationProperties casProperties) {
            return new OAuth20ConsentApprovalViewResolver(casProperties, oauthDistributedSessionStore);
        }

        @ConditionalOnMissingBean(name={"oAuth2UserProfileDataCreator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20UserProfileDataCreator oAuth2UserProfileDataCreator(@Qualifier(value="oauth20ConfigurationContext") ObjectProvider<OAuth20ConfigurationContext> context) {
            return new DefaultOAuth20UserProfileDataCreator(context);
        }
    }

    @Configuration(value="CasOAuth20ContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20ContextConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20ConfigurationContext oauth20ConfigurationContext(@Qualifier(value="oauth20ClientSecretValidator") OAuth20ClientSecretValidator oauth20ClientSecretValidator, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="accessTokenJwtBuilder") JwtBuilder accessTokenJwtBuilder, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="oAuth2UserProfileDataCreator") OAuth20UserProfileDataCreator oAuth2UserProfileDataCreator, @Qualifier(value="oauthDistributedSessionCookieGenerator") CasCookieBuilder oauthDistributedSessionCookieGenerator, @Qualifier(value="oauthUserProfileViewRenderer") OAuth20UserProfileViewRenderer oauthUserProfileViewRenderer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="oauthDistributedSessionStore") SessionStore oauthDistributedSessionStore, @Qualifier(value="oauthRegisteredServiceCipherExecutor") CipherExecutor oauthRegisteredServiceCipherExecutor, @Qualifier(value="oauthPrincipalFactory") PrincipalFactory oauthPrincipalFactory, @Qualifier(value="callbackAuthorizeViewResolver") OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver, @Qualifier(value="profileScopeToAttributesFilter") OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, @Qualifier(value="oauthSecConfig") Config oauthSecConfig, ObjectProvider<List<OAuth20TokenRequestValidator>> oauthTokenRequestValidators, @Qualifier(value="deviceTokenExpirationPolicy") ExpirationPolicyBuilder deviceTokenExpirationPolicy, @Qualifier(value="oauthInvalidAuthorizationBuilder") OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationBuilder, @Qualifier(value="consentApprovalViewResolver") ConsentApprovalViewResolver consentApprovalViewResolver, @Qualifier(value="accessTokenResponseGenerator") OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator, @Qualifier(value="oauthCasAuthenticationBuilder") OAuth20CasAuthenticationBuilder oauthCasAuthenticationBuilder, ObjectProvider<List<OAuth20AuthorizationResponseBuilder>> oauthAuthorizationResponseBuilders, ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthAuthorizationRequestValidators, @Qualifier(value="oauthTokenGenerator") OAuth20TokenGenerator oauthTokenGenerator) {
            return OAuth20ConfigurationContext.builder().requestParameterResolver(oauthRequestParameterResolver).applicationContext(applicationContext).registeredServiceCipherExecutor(oauthRegisteredServiceCipherExecutor).sessionStore(oauthDistributedSessionStore).servicesManager(servicesManager).ticketRegistry(ticketRegistry).ticketFactory(ticketFactory).principalFactory(oauthPrincipalFactory).webApplicationServiceServiceFactory(webApplicationServiceFactory).casProperties(casProperties).ticketGrantingTicketCookieGenerator(ticketGrantingTicketCookieGenerator).oauthDistributedSessionCookieGenerator(oauthDistributedSessionCookieGenerator).oauthConfig(oauthSecConfig).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer).centralAuthenticationService(centralAuthenticationService).callbackAuthorizeViewResolver(callbackAuthorizeViewResolver).profileScopeToAttributesFilter(profileScopeToAttributesFilter).accessTokenGenerator(oauthTokenGenerator).accessTokenJwtBuilder(accessTokenJwtBuilder).accessTokenResponseGenerator(accessTokenResponseGenerator).deviceTokenExpirationPolicy(deviceTokenExpirationPolicy).accessTokenGrantRequestValidators(oauthTokenRequestValidators).userProfileDataCreator(oAuth2UserProfileDataCreator).userProfileViewRenderer(oauthUserProfileViewRenderer).consentApprovalViewResolver(consentApprovalViewResolver).authenticationBuilder(oauthCasAuthenticationBuilder).oauthInvalidAuthorizationResponseBuilder(oauthInvalidAuthorizationBuilder).oauthAuthorizationResponseBuilders(oauthAuthorizationResponseBuilders).oauthRequestValidators(oauthAuthorizationRequestValidators).clientSecretValidator(oauth20ClientSecretValidator).build();
        }
    }

    @Configuration(value="CasOAuth20JwtConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasOAuth20JwtConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oauthAccessTokenJwtCipherExecutor"})
        public CipherExecutor oauthAccessTokenJwtCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionOptionalSigningOptionalJwtCryptographyProperties crypto = casProperties.getAuthn().getOauth().getAccessToken().getCrypto();
            boolean bl = !crypto.isEnabled() && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey());
            Boolean enabled = (Boolean)FunctionUtils.doIf((boolean)bl, () -> {
                LOGGER.warn("Default encryption/signing is not enabled explicitly for OAuth access tokens as JWTs if necessary, yet signing/encryption keys are defined for operations. CAS will proceed to enable the token encryption/signing functionality.");
                return Boolean.TRUE;
            }, () -> ((EncryptionOptionalSigningOptionalJwtCryptographyProperties)crypto).isEnabled()).get();
            if (enabled.booleanValue()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionOptionalSigningOptionalJwtCryptographyProperties)crypto, OAuth20JwtAccessTokenCipherExecutor.class);
            }
            LOGGER.info("OAuth access token encryption/signing is turned off for JWTs, if/when needed. This MAY NOT be safe in a production environment.");
            return CipherExecutor.noOp();
        }

        @ConditionalOnMissingBean(name={"oauthRegisteredServiceJwtAccessTokenCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredServiceCipherExecutor oauthRegisteredServiceJwtAccessTokenCipherExecutor() {
            return new OAuth20RegisteredServiceJwtAccessTokenCipherExecutor();
        }

        @ConditionalOnMissingBean(name={"accessTokenJwtBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public JwtBuilder accessTokenJwtBuilder(CasConfigurationProperties casProperties, @Qualifier(value="oauthRegisteredServiceJwtAccessTokenCipherExecutor") RegisteredServiceCipherExecutor oauthRegisteredServiceJwtAccessTokenCipherExecutor, @Qualifier(value="oauthAccessTokenJwtCipherExecutor") CipherExecutor oauthAccessTokenJwtCipherExecutor, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new OAuth20JwtBuilder(oauthAccessTokenJwtCipherExecutor, servicesManager, oauthRegisteredServiceJwtAccessTokenCipherExecutor, casProperties);
        }
    }
}

