/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.engine.DynamicBpmnConstants;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.dynamic.DynamicProcessDefinitionSummary;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.GetBpmnModelCmd;
import org.flowable.engine.impl.cmd.GetProcessDefinitionInfoCmd;
import org.flowable.engine.impl.cmd.InjectEmbeddedSubProcessInProcessInstanceCmd;
import org.flowable.engine.impl.cmd.InjectParallelEmbeddedSubProcessCmd;
import org.flowable.engine.impl.cmd.InjectParallelUserTaskCmd;
import org.flowable.engine.impl.cmd.InjectUserTaskInProcessInstanceCmd;
import org.flowable.engine.impl.cmd.SaveProcessDefinitionInfoCmd;
import org.flowable.engine.impl.dynamic.DynamicEmbeddedSubProcessBuilder;
import org.flowable.engine.impl.dynamic.DynamicUserTaskBuilder;

public class DynamicBpmnServiceImpl
extends CommonEngineServiceImpl<ProcessEngineConfigurationImpl>
implements DynamicBpmnService,
DynamicBpmnConstants {
    public DynamicBpmnServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super((AbstractEngineConfiguration)processEngineConfiguration);
    }

    @Override
    public void injectUserTaskInProcessInstance(String processInstanceId, DynamicUserTaskBuilder dynamicUserTaskBuilder) {
        this.commandExecutor.execute((Command)new InjectUserTaskInProcessInstanceCmd(processInstanceId, dynamicUserTaskBuilder));
    }

    @Override
    public void injectParallelUserTask(String taskId, DynamicUserTaskBuilder dynamicUserTaskBuilder) {
        this.commandExecutor.execute((Command)new InjectParallelUserTaskCmd(taskId, dynamicUserTaskBuilder));
    }

    @Override
    public void injectEmbeddedSubProcessInProcessInstance(String processInstanceId, DynamicEmbeddedSubProcessBuilder dynamicEmbeddedSubProcessBuilder) {
        this.commandExecutor.execute((Command)new InjectEmbeddedSubProcessInProcessInstanceCmd(processInstanceId, dynamicEmbeddedSubProcessBuilder));
    }

    @Override
    public void injectParallelEmbeddedSubProcess(String taskId, DynamicEmbeddedSubProcessBuilder dynamicEmbeddedSubProcessBuilder) {
        this.commandExecutor.execute((Command)new InjectParallelEmbeddedSubProcessCmd(taskId, dynamicEmbeddedSubProcessBuilder));
    }

    @Override
    public ObjectNode getProcessDefinitionInfo(String processDefinitionId) {
        return (ObjectNode)this.commandExecutor.execute((Command)new GetProcessDefinitionInfoCmd(processDefinitionId));
    }

    @Override
    public void saveProcessDefinitionInfo(String processDefinitionId, ObjectNode infoNode) {
        this.commandExecutor.execute((Command)new SaveProcessDefinitionInfoCmd(processDefinitionId, infoNode));
    }

    @Override
    public ObjectNode changeServiceTaskClassName(String id, String className) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeServiceTaskClassName(id, className, infoNode);
        return infoNode;
    }

    @Override
    public void changeServiceTaskClassName(String id, String className, ObjectNode infoNode) {
        this.setElementProperty(id, "serviceTaskClassName", className, infoNode);
    }

    @Override
    public ObjectNode changeServiceTaskExpression(String id, String expression) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeServiceTaskExpression(id, expression, infoNode);
        return infoNode;
    }

    @Override
    public void changeServiceTaskExpression(String id, String expression, ObjectNode infoNode) {
        this.setElementProperty(id, "serviceTaskExpression", expression, infoNode);
    }

    @Override
    public ObjectNode changeServiceTaskDelegateExpression(String id, String expression) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeServiceTaskDelegateExpression(id, expression, infoNode);
        return infoNode;
    }

    @Override
    public void changeServiceTaskDelegateExpression(String id, String expression, ObjectNode infoNode) {
        this.setElementProperty(id, "serviceTaskDelegateExpression", expression, infoNode);
    }

    @Override
    public ObjectNode changeScriptTaskScript(String id, String script) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeScriptTaskScript(id, script, infoNode);
        return infoNode;
    }

    @Override
    public void changeScriptTaskScript(String id, String script, ObjectNode infoNode) {
        this.setElementProperty(id, "scriptTaskScript", script, infoNode);
    }

    @Override
    public ObjectNode changeSkipExpression(String id, String skipExpression) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeSkipExpression(id, skipExpression, infoNode);
        return infoNode;
    }

    @Override
    public void changeSkipExpression(String id, String skipExpression, ObjectNode infoNode) {
        this.setElementProperty(id, "taskSkipExpression", skipExpression, infoNode);
    }

    @Override
    public void removeSkipExpression(String id, ObjectNode infoNode) {
        this.removeElementProperty(id, "taskSkipExpression", infoNode);
    }

    @Override
    public ObjectNode enableSkipExpression() {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.enableSkipExpression(infoNode);
        return infoNode;
    }

    @Override
    public void enableSkipExpression(ObjectNode infoNode) {
        this.setElementProperty("_flowableGlobalProcessDefinitionProperties", "enableSkipExpression", "true", infoNode);
    }

    @Override
    public void removeEnableSkipExpression(ObjectNode infoNode) {
        this.removeElementProperty("_flowableGlobalProcessDefinitionProperties", "enableSkipExpression", infoNode);
    }

    @Override
    public ObjectNode changeUserTaskName(String id, String name) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskName(id, name, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskName(String id, String name, ObjectNode infoNode) {
        this.setElementProperty(id, "userTaskName", name, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskDescription(String id, String description) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskDescription(id, description, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskDescription(String id, String description, ObjectNode infoNode) {
        this.setElementProperty(id, "userTaskDescription", description, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskDueDate(String id, String dueDate) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskDueDate(id, dueDate, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskDueDate(String id, String dueDate, ObjectNode infoNode) {
        this.setElementProperty(id, "userTaskDueDate", dueDate, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskPriority(String id, String priority) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskPriority(id, priority, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskPriority(String id, String priority, ObjectNode infoNode) {
        this.setElementProperty(id, "userTaskPriority", priority, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskCategory(String id, String category) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskCategory(id, category, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskCategory(String id, String category, ObjectNode infoNode) {
        this.setElementProperty(id, "userTaskCategory", category, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskFormKey(String id, String formKey) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskFormKey(id, formKey, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskFormKey(String id, String formKey, ObjectNode infoNode) {
        this.setElementProperty(id, "userTaskFormKey", formKey, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskAssignee(String id, String assignee) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskAssignee(id, assignee, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskAssignee(String id, String assignee, ObjectNode infoNode) {
        this.setElementProperty(id, "userTaskAssignee", assignee, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskOwner(String id, String owner) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskOwner(id, owner, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskOwner(String id, String owner, ObjectNode infoNode) {
        this.setElementProperty(id, "userTaskOwner", owner, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskCandidateUser(String id, String candidateUser, boolean overwriteOtherChangedEntries) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskCandidateUser(id, candidateUser, overwriteOtherChangedEntries, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskCandidateUser(String id, String candidateUser, boolean overwriteOtherChangedEntries, ObjectNode infoNode) {
        ArrayNode valuesNode = null;
        if (overwriteOtherChangedEntries) {
            valuesNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createArrayNode();
        } else {
            if (this.doesElementPropertyExist(id, "userTaskCandidateUsers", infoNode)) {
                valuesNode = (ArrayNode)infoNode.get("bpmn").get(id).get("userTaskCandidateUsers");
            }
            if (valuesNode == null || valuesNode.isNull()) {
                valuesNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createArrayNode();
            }
        }
        valuesNode.add(candidateUser);
        this.setElementProperty(id, "userTaskCandidateUsers", (JsonNode)valuesNode, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskCandidateGroup(String id, String candidateGroup, boolean overwriteOtherChangedEntries) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskCandidateGroup(id, candidateGroup, overwriteOtherChangedEntries, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskCandidateGroup(String id, String candidateGroup, boolean overwriteOtherChangedEntries, ObjectNode infoNode) {
        ArrayNode valuesNode = null;
        if (overwriteOtherChangedEntries) {
            valuesNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createArrayNode();
        } else {
            if (this.doesElementPropertyExist(id, "userTaskCandidateGroups", infoNode)) {
                valuesNode = (ArrayNode)infoNode.get("bpmn").get(id).get("userTaskCandidateGroups");
            }
            if (valuesNode == null || valuesNode.isNull()) {
                valuesNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createArrayNode();
            }
        }
        valuesNode.add(candidateGroup);
        this.setElementProperty(id, "userTaskCandidateGroups", (JsonNode)valuesNode, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskCandidateUsers(String id, List<String> candidateUsers) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskCandidateUsers(id, candidateUsers, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskCandidateUsers(String id, List<String> candidateUsers, ObjectNode infoNode) {
        ArrayNode candidateUsersNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createArrayNode();
        for (String candidateUser : candidateUsers) {
            candidateUsersNode.add(candidateUser);
        }
        this.setElementProperty(id, "userTaskCandidateUsers", (JsonNode)candidateUsersNode, infoNode);
    }

    @Override
    public ObjectNode changeUserTaskCandidateGroups(String id, List<String> candidateGroups) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeUserTaskCandidateGroups(id, candidateGroups, infoNode);
        return infoNode;
    }

    @Override
    public void changeUserTaskCandidateGroups(String id, List<String> candidateGroups, ObjectNode infoNode) {
        ArrayNode candidateGroupsNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createArrayNode();
        for (String candidateGroup : candidateGroups) {
            candidateGroupsNode.add(candidateGroup);
        }
        this.setElementProperty(id, "userTaskCandidateGroups", (JsonNode)candidateGroupsNode, infoNode);
    }

    @Override
    public ObjectNode changeMultiInstanceCompletionCondition(String id, String completionCondition) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeMultiInstanceCompletionCondition(id, completionCondition, infoNode);
        return infoNode;
    }

    @Override
    public void changeMultiInstanceCompletionCondition(String id, String completionCondition, ObjectNode infoNode) {
        this.setElementProperty(id, "multiInstanceCompletionCondition", completionCondition, infoNode);
    }

    @Override
    public ObjectNode changeDmnTaskDecisionTableKey(String id, String decisionTableKey) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeDmnTaskDecisionTableKey(id, decisionTableKey, infoNode);
        return infoNode;
    }

    @Override
    public void changeDmnTaskDecisionTableKey(String id, String decisionTableKey, ObjectNode infoNode) {
        this.setElementProperty(id, "dmnTaskDecisionTableKey", decisionTableKey, infoNode);
    }

    @Override
    public ObjectNode changeSequenceFlowCondition(String id, String condition) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeSequenceFlowCondition(id, condition, infoNode);
        return infoNode;
    }

    @Override
    public void changeSequenceFlowCondition(String id, String condition, ObjectNode infoNode) {
        this.setElementProperty(id, "sequenceFlowCondition", condition, infoNode);
    }

    @Override
    public ObjectNode changeCallActivityCalledElement(String id, String calledElement) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeCallActivityCalledElement(id, calledElement, infoNode);
        return infoNode;
    }

    @Override
    public void changeCallActivityCalledElement(String id, String calledElement, ObjectNode infoNode) {
        this.setElementProperty(id, "callActivityCalledElement", calledElement, infoNode);
    }

    @Override
    public ObjectNode getBpmnElementProperties(String id, ObjectNode infoNode) {
        ObjectNode propertiesNode = null;
        ObjectNode bpmnNode = this.getBpmnNode(infoNode);
        if (bpmnNode != null) {
            propertiesNode = (ObjectNode)bpmnNode.get(id);
        }
        return propertiesNode;
    }

    @Override
    public ObjectNode changeLocalizationName(String language, String id, String value) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeLocalizationName(language, id, value, infoNode);
        return infoNode;
    }

    @Override
    public void changeLocalizationName(String language, String id, String value, ObjectNode infoNode) {
        this.setLocalizationProperty(language, id, "name", value, infoNode);
    }

    @Override
    public ObjectNode changeLocalizationDescription(String language, String id, String value) {
        ObjectNode infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
        this.changeLocalizationDescription(language, id, value, infoNode);
        return infoNode;
    }

    @Override
    public void changeLocalizationDescription(String language, String id, String value, ObjectNode infoNode) {
        this.setLocalizationProperty(language, id, "description", value, infoNode);
    }

    @Override
    public ObjectNode getLocalizationElementProperties(String language, String id, ObjectNode infoNode) {
        JsonNode languageNode;
        ObjectNode propertiesNode = null;
        ObjectNode localizationNode = this.getLocalizationNode(infoNode);
        if (localizationNode != null && (languageNode = localizationNode.get(language)) != null) {
            propertiesNode = (ObjectNode)languageNode.get(id);
        }
        return propertiesNode;
    }

    protected boolean doesElementPropertyExist(String id, String propertyName, ObjectNode infoNode) {
        JsonNode propNode;
        boolean exists = false;
        if (infoNode.get("bpmn") != null && infoNode.get("bpmn").get(id) != null && infoNode.get("bpmn").get(id).get(propertyName) != null && !(propNode = infoNode.get("bpmn").get(id).get(propertyName)).isNull()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public void resetProperty(String elementId, String property, ObjectNode infoNode) {
        ObjectNode path = (ObjectNode)infoNode.path("bpmn").path(elementId);
        if (!path.isMissingNode()) {
            path.remove(property);
        }
    }

    @Override
    public DynamicProcessDefinitionSummary getDynamicProcessDefinitionSummary(String processDefinitionId) {
        ObjectNode infoNode = this.getProcessDefinitionInfo(processDefinitionId);
        ObjectMapper objectMapper = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper();
        BpmnModel bpmnModel = (BpmnModel)this.commandExecutor.execute((Command)new GetBpmnModelCmd(processDefinitionId));
        if (bpmnModel == null) {
            throw new FlowableException("ProcessDefinition " + processDefinitionId + " does not exists");
        }
        if (infoNode == null) {
            infoNode = ((ProcessEngineConfigurationImpl)((Object)this.configuration)).getObjectMapper().createObjectNode();
            this.createOrGetBpmnNode(infoNode);
        }
        return new DynamicProcessDefinitionSummary(bpmnModel, infoNode, objectMapper);
    }

    protected void setElementProperty(String id, String propertyName, String propertyValue, ObjectNode infoNode) {
        ObjectNode bpmnNode = this.createOrGetBpmnNode(infoNode);
        if (!bpmnNode.has(id)) {
            bpmnNode.putObject(id);
        }
        ((ObjectNode)bpmnNode.get(id)).put(propertyName, propertyValue);
    }

    protected void setElementProperty(String id, String propertyName, JsonNode propertyValue, ObjectNode infoNode) {
        ObjectNode bpmnNode = this.createOrGetBpmnNode(infoNode);
        if (!bpmnNode.has(id)) {
            bpmnNode.putObject(id);
        }
        ((ObjectNode)bpmnNode.get(id)).set(propertyName, propertyValue);
    }

    protected void removeElementProperty(String id, String propertyName, ObjectNode infoNode) {
        ObjectNode activityNode;
        ObjectNode bpmnNode = this.createOrGetBpmnNode(infoNode);
        if (bpmnNode.has(id) && (activityNode = (ObjectNode)bpmnNode.get(id)).has(propertyName)) {
            activityNode.remove(propertyName);
        }
    }

    protected ObjectNode createOrGetBpmnNode(ObjectNode infoNode) {
        if (!infoNode.has("bpmn")) {
            infoNode.putObject("bpmn");
        }
        return (ObjectNode)infoNode.get("bpmn");
    }

    protected ObjectNode getBpmnNode(ObjectNode infoNode) {
        return (ObjectNode)infoNode.get("bpmn");
    }

    protected void setLocalizationProperty(String language, String id, String propertyName, String propertyValue, ObjectNode infoNode) {
        ObjectNode languageNode;
        ObjectNode localizationNode = this.createOrGetLocalizationNode(infoNode);
        if (!localizationNode.has(language)) {
            localizationNode.putObject(language);
        }
        if (!(languageNode = (ObjectNode)localizationNode.get(language)).has(id)) {
            languageNode.putObject(id);
        }
        ((ObjectNode)languageNode.get(id)).put(propertyName, propertyValue);
    }

    protected ObjectNode createOrGetLocalizationNode(ObjectNode infoNode) {
        if (!infoNode.has("localization")) {
            infoNode.putObject("localization");
        }
        return (ObjectNode)infoNode.get("localization");
    }

    protected ObjectNode getLocalizationNode(ObjectNode infoNode) {
        return (ObjectNode)infoNode.get("localization");
    }
}

