/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.flowable.engine.impl.bpmn.data.FieldBaseStructureDefinition;
import org.flowable.engine.impl.bpmn.data.StructureInstance;
import org.flowable.engine.impl.util.CommandContextUtil;

public class FieldBaseStructureInstance
implements StructureInstance {
    protected FieldBaseStructureDefinition structureDefinition;
    protected Map<String, Object> fieldValues;

    public FieldBaseStructureInstance(FieldBaseStructureDefinition structureDefinition) {
        this.structureDefinition = structureDefinition;
        this.fieldValues = new HashMap<String, Object>();
    }

    public Object getFieldValue(String fieldName) {
        return this.fieldValues.get(fieldName);
    }

    public void setFieldValue(String fieldName, Object value) {
        this.fieldValues.put(fieldName, value);
    }

    public int getFieldSize() {
        return this.structureDefinition.getFieldSize();
    }

    public String getFieldNameAt(int index) {
        return this.structureDefinition.getFieldNameAt(index);
    }

    public Class<?> getFieldTypeAt(int index) {
        return this.structureDefinition.getFieldTypeAt(index);
    }

    @Override
    public Object[] toArray() {
        int fieldSize = this.getFieldSize();
        Object[] arguments = new Object[fieldSize];
        for (int i = 0; i < fieldSize; ++i) {
            Object argument;
            arguments[i] = argument = this.getFieldValue(i);
        }
        return arguments;
    }

    private Object getFieldValue(int index) {
        String fieldName = this.getFieldNameAt(index);
        Object fieldValueObject = this.getFieldValue(fieldName);
        if (fieldValueObject instanceof ArrayNode) {
            ArrayNode fieldArrayNodeValueObject = (ArrayNode)fieldValueObject;
            Class<?> fieldParameterType = this.structureDefinition.getFieldParameterTypeAt(index);
            ObjectMapper objectMapper = CommandContextUtil.getProcessEngineConfiguration().getObjectMapper();
            Object value = objectMapper.convertValue(fieldValueObject, Array.newInstance(fieldParameterType, fieldArrayNodeValueObject.size()).getClass());
            return Arrays.asList((Object[])value);
        }
        if (fieldValueObject instanceof ValueNode || fieldValueObject instanceof ObjectNode) {
            ObjectMapper objectMapper = CommandContextUtil.getProcessEngineConfiguration().getObjectMapper();
            return objectMapper.convertValue(fieldValueObject, this.getFieldTypeAt(index));
        }
        return fieldValueObject;
    }

    @Override
    public void loadFrom(Object[] array) {
        int fieldSize = this.getFieldSize();
        for (int i = 0; i < fieldSize; ++i) {
            String fieldName = this.getFieldNameAt(i);
            Object fieldValue = array[i];
            this.setFieldValue(fieldName, fieldValue);
        }
    }
}

