/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.impl.test.TestHelper;
import org.flowable.engine.test.ConfigurationResource;
import org.flowable.engine.test.Deployment;
import org.flowable.engine.test.DeploymentId;
import org.flowable.engine.test.FlowableTestHelper;
import org.flowable.engine.test.mock.FlowableMockSupport;
import org.flowable.engine.test.mock.MockServiceTask;
import org.flowable.engine.test.mock.NoOpServiceTasks;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "flowable.cfg.xml";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{FlowableExtension.class});
    private static final Set<Class<?>> SUPPORTED_PARAMETERS = new HashSet<Class>(Arrays.asList(ProcessEngineConfiguration.class, ProcessEngine.class, RepositoryService.class, RuntimeService.class, TaskService.class, HistoryService.class, IdentityService.class, ManagementService.class, FormService.class));
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) throws Exception {
        FlowableTestHelper flowableTestHelper = this.getTestHelper(context);
        FlowableMockSupport mockSupport = flowableTestHelper.getMockSupport();
        if (mockSupport != null) {
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)context.getRequiredTestClass(), MockServiceTask.class).forEach(mockServiceTask -> TestHelper.handleMockServiceTaskAnnotation(mockSupport, mockServiceTask));
            AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)context.getRequiredTestMethod(), MockServiceTask.class).forEach(mockServiceTask -> TestHelper.handleMockServiceTaskAnnotation(mockSupport, mockServiceTask));
            AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), NoOpServiceTasks.class).ifPresent(noOpServiceTasks -> TestHelper.handleNoOpServiceTasksAnnotation(mockSupport, noOpServiceTasks));
        }
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), Deployment.class).ifPresent(deployment -> {
            String deploymentIdFromDeploymentAnnotation = TestHelper.annotationDeploymentSetUp(flowableTestHelper.getProcessEngine(), context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(deploymentIdFromDeploymentAnnotation);
        });
    }

    public void afterEach(ExtensionContext context) throws Exception {
        FlowableTestHelper flowableTestHelper = this.getTestHelper(context);
        ProcessEngine processEngine = flowableTestHelper.getProcessEngine();
        String deploymentIdFromDeploymentAnnotation = flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        if (deploymentIdFromDeploymentAnnotation != null) {
            TestHelper.annotationDeploymentTearDown(processEngine, deploymentIdFromDeploymentAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
            flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(null);
        }
        processEngine.getProcessEngineConfiguration().getClock().reset();
        FlowableMockSupport mockSupport = flowableTestHelper.getMockSupport();
        if (mockSupport != null) {
            TestHelper.annotationMockSupportTeardown(mockSupport);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return SUPPORTED_PARAMETERS.contains(parameterType) || FlowableTestHelper.class.equals(parameterType) || FlowableMockSupport.class.equals(parameterType) || parameterContext.isAnnotated(DeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        ProcessEngine processEngine;
        FlowableTestHelper flowableTestHelper = this.getTestHelper(context);
        if (parameterContext.isAnnotated(DeploymentId.class)) {
            return flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        }
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isInstance(processEngine = flowableTestHelper.getProcessEngine())) {
            return processEngine;
        }
        if (FlowableTestHelper.class.equals(parameterType)) {
            return flowableTestHelper;
        }
        if (FlowableMockSupport.class.equals(parameterType)) {
            return flowableTestHelper.getMockSupport();
        }
        try {
            return ProcessEngine.class.getDeclaredMethod("get" + parameterType.getSimpleName(), new Class[0]).invoke((Object)processEngine, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ParameterResolutionException("Could not find service " + parameterType, (Throwable)ex);
        }
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), ConfigurationResource.class).map(ConfigurationResource::value).orElse(DEFAULT_CONFIGURATION_RESOURCE);
    }

    protected FlowableTestHelper getTestHelper(ExtensionContext context) {
        return (FlowableTestHelper)this.getStore(context).getOrComputeIfAbsent((Object)context.getRequiredTestClass(), key -> new FlowableTestHelper(this.createProcessEngine(context)), FlowableTestHelper.class);
    }

    protected ProcessEngine createProcessEngine(ExtensionContext context) {
        return TestHelper.getProcessEngine(this.getConfigurationResource(context));
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

