/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.servlet;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.webflow.context.servlet.AjaxHandler;
import org.springframework.webflow.context.servlet.FilenameFlowUrlHandler;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.AbstractFlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

public class FlowController
implements Controller,
ApplicationContextAware,
InitializingBean {
    private FlowHandlerAdapter flowHandlerAdapter;
    private Map<String, FlowHandler> flowHandlers = new HashMap<String, FlowHandler>();
    private boolean customFlowHandlerAdapterSet;

    public FlowController() {
        this.flowHandlerAdapter = new FlowHandlerAdapter();
        this.flowHandlerAdapter.setFlowUrlHandler(new FilenameFlowUrlHandler());
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowHandlerAdapter.getFlowExecutor();
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowHandlerAdapter.setFlowExecutor(flowExecutor);
    }

    public FlowUrlHandler getFlowUrlHandler() {
        return this.flowHandlerAdapter.getFlowUrlHandler();
    }

    public void setFlowUrlHandler(FlowUrlHandler urlHandler) {
        this.flowHandlerAdapter.setFlowUrlHandler(urlHandler);
    }

    public AjaxHandler getAjaxHandler() {
        return this.flowHandlerAdapter.getAjaxHandler();
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.flowHandlerAdapter.setAjaxHandler(ajaxHandler);
    }

    public void setRedirectHttp10Compatible(boolean redirectHttp10Compatible) {
        this.flowHandlerAdapter.setRedirectHttp10Compatible(redirectHttp10Compatible);
    }

    public void setFlowHandlers(Map<String, FlowHandler> flowHandlers) {
        this.flowHandlers = flowHandlers;
    }

    public void registerFlowHandler(FlowHandler flowHandler) {
        this.flowHandlers.put(flowHandler.getFlowId(), flowHandler);
    }

    public FlowHandlerAdapter getFlowHandlerAdapter() {
        return this.flowHandlerAdapter;
    }

    public void setFlowHandlerAdapter(FlowHandlerAdapter flowHandlerAdapter) {
        this.flowHandlerAdapter = flowHandlerAdapter;
        this.customFlowHandlerAdapterSet = true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!this.customFlowHandlerAdapterSet) {
            this.flowHandlerAdapter.setApplicationContext(applicationContext);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.customFlowHandlerAdapterSet) {
            this.flowHandlerAdapter.afterPropertiesSet();
        }
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        FlowHandler handler = this.getFlowHandler(request);
        return this.flowHandlerAdapter.handle(request, response, handler);
    }

    private FlowHandler getFlowHandler(HttpServletRequest request) {
        FlowUrlHandler urlHandler = this.flowHandlerAdapter.getFlowUrlHandler();
        String flowId = urlHandler.getFlowId(request);
        return this.getFlowHandler(flowId);
    }

    private FlowHandler getFlowHandler(String flowId) {
        FlowHandler handler = this.flowHandlers.get(flowId);
        if (handler == null) {
            handler = new DefaultFlowHandler(flowId);
        }
        return handler;
    }

    private static class DefaultFlowHandler
    extends AbstractFlowHandler {
        private String flowId;

        public DefaultFlowHandler(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public String getFlowId() {
            return this.flowId;
        }
    }
}

