/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.redis;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.extensions.types.DurationUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.SessionUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.TypeParser;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.redis.DataStoreRedisProperties;
import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.datastores.common.SessionQuotaManagingDataStore;
import org.wicketstuff.datastores.redis.IRedisSettings;
import org.wicketstuff.datastores.redis.RedisDataStore;
import org.wicketstuff.datastores.redis.RedisSettings;
import redis.clients.jedis.Jedis;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.datastore.redis", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Jedis.class, RedisDataStore.class})
@EnableConfigurationProperties(value={DataStoreRedisProperties.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class DataStoreRedisConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DataStoreRedisProperties prop;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(final WebApplication webApplication) {
        webApplication.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((Application)webApplication){

            protected IPageStore newPersistentStore() {
                RedisSettings settings = new RedisSettings();
                settings.setHostname(DataStoreRedisConfig.this.prop.getHostname());
                settings.setPort(DataStoreRedisConfig.this.prop.getPort());
                settings.setRecordTtl(TypeParser.parse((Long)DataStoreRedisConfig.this.prop.getRecordTtl(), (DurationUnit)DataStoreRedisConfig.this.prop.getRecordTtlUnit()));
                RedisDataStore redisDataStore = new RedisDataStore(webApplication.getName(), (IRedisSettings)settings);
                return new SessionQuotaManagingDataStore((IPageStore)redisDataStore, TypeParser.parse((Long)DataStoreRedisConfig.this.prop.getSessionSize(), (SessionUnit)DataStoreRedisConfig.this.prop.getSessionUnit()));
            }
        });
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.prop).build());
    }
}

