/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.ServiceImpl;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;

public class TimerJobServiceImpl
extends ServiceImpl
implements TimerJobService {
    public TimerJobServiceImpl(JobServiceConfiguration jobServiceConfiguration) {
        super(jobServiceConfiguration);
    }

    @Override
    public TimerJobEntity findTimerJobById(String jobId) {
        return (TimerJobEntity)this.getTimerJobEntityManager().findById(jobId);
    }

    @Override
    public List<TimerJobEntity> findTimerJobsByExecutionId(String executionId) {
        return this.getTimerJobEntityManager().findJobsByExecutionId(executionId);
    }

    @Override
    public List<TimerJobEntity> findTimerJobsByProcessInstanceId(String processInstanceId) {
        return this.getTimerJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionId(String type, String processDefinitionId) {
        return this.getTimerJobEntityManager().findJobsByTypeAndProcessDefinitionId(type, processDefinitionId);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionKeyNoTenantId(String type, String processDefinitionKey) {
        return this.getTimerJobEntityManager().findJobsByTypeAndProcessDefinitionKeyNoTenantId(type, processDefinitionKey);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionKeyAndTenantId(String type, String processDefinitionKey, String tenantId) {
        return this.getTimerJobEntityManager().findJobsByTypeAndProcessDefinitionKeyAndTenantId(type, processDefinitionKey, tenantId);
    }

    @Override
    public void scheduleTimerJob(TimerJobEntity timerJob) {
        this.getJobManager().scheduleTimerJob(timerJob);
    }

    @Override
    public AbstractRuntimeJobEntity moveJobToTimerJob(JobEntity job) {
        return this.getJobManager().moveJobToTimerJob(job);
    }

    @Override
    public TimerJobEntity createTimerJob() {
        return (TimerJobEntity)this.getTimerJobEntityManager().create();
    }

    @Override
    public void insertTimerJob(TimerJobEntity timerJob) {
        this.getTimerJobEntityManager().insert(timerJob);
    }

    @Override
    public void deleteTimerJob(TimerJobEntity timerJob) {
        this.getTimerJobEntityManager().delete(timerJob);
    }

    @Override
    public void deleteTimerJobsByExecutionId(String executionId) {
        TimerJobEntityManager timerJobEntityManager = this.getTimerJobEntityManager();
        List timerJobsForExecution = timerJobEntityManager.findJobsByExecutionId(executionId);
        for (TimerJobEntity job : timerJobsForExecution) {
            timerJobEntityManager.delete(job);
            if (this.getEventDispatcher() == null || !this.getEventDispatcher().isEnabled()) continue;
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, job), ((JobServiceConfiguration)((Object)this.configuration)).getEngineName());
        }
    }
}

